/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import org.neo4j.batchimport.api.InputIterator;
import org.neo4j.batchimport.api.input.InputChunk;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.storemigration.StoreScanChunk;

abstract class StoreScanAsInputIterator<RECORD extends AbstractBaseRecord>
implements InputIterator {
    private final int batchSize;
    private final long highId;
    private long id;

    StoreScanAsInputIterator(RecordStore<RECORD> store) {
        this.batchSize = store.getRecordsPerPage() * 10;
        this.highId = store.getIdGenerator().getHighId();
    }

    public void close() {
    }

    public synchronized boolean next(InputChunk chunk) {
        if (this.id >= this.highId) {
            return false;
        }
        long startId = this.id;
        this.id = Long.min(this.highId, startId + (long)this.batchSize);
        ((StoreScanChunk)chunk).initialize(startId, this.id);
        return true;
    }
}

