/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Stream;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.csv.Decorator;

public class InputEntityDecorators {
    public static final Decorator NO_DECORATOR = value -> value;

    private InputEntityDecorators() {
    }

    public static Decorator additiveLabels(String ... labelNamesToAdd) {
        if (labelNamesToAdd == null || labelNamesToAdd.length == 0) {
            return NO_DECORATOR;
        }
        return node -> new AdditiveLabelsDecorator((InputEntityVisitor)node, labelNamesToAdd);
    }

    public static Decorator defaultRelationshipType(String defaultType) {
        return defaultType == null ? NO_DECORATOR : relationship -> new RelationshipTypeDecorator((InputEntityVisitor)relationship, defaultType);
    }

    public static Decorator decorators(final Decorator ... decorators) {
        return new Decorator(){

            @Override
            public InputEntityVisitor apply(InputEntityVisitor from) {
                for (Decorator decorator : decorators) {
                    from = (InputEntityVisitor)decorator.apply(from);
                }
                return from;
            }

            @Override
            public boolean isMutable() {
                return Stream.of(decorators).anyMatch(Decorator::isMutable);
            }
        };
    }

    private static final class RelationshipTypeDecorator
    extends InputEntityVisitor.Delegate {
        private final String defaultType;
        private boolean hasType;

        RelationshipTypeDecorator(InputEntityVisitor actual, String defaultType) {
            super(actual);
            this.defaultType = defaultType;
        }

        public boolean type(int type) {
            this.hasType = true;
            return super.type(type);
        }

        public boolean type(String type) {
            if (type != null) {
                this.hasType = true;
            }
            return super.type(type);
        }

        public void endOfEntity() throws IOException {
            if (!this.hasType) {
                super.type(this.defaultType);
                this.hasType = false;
            }
            super.endOfEntity();
        }
    }

    private static final class AdditiveLabelsDecorator
    extends InputEntityVisitor.Delegate {
        private final String[] transport = new String[1];
        private final String[] labelNamesToAdd;
        private final boolean[] seenLabels;
        private boolean seenLabelField;

        AdditiveLabelsDecorator(InputEntityVisitor actual, String[] labelNamesToAdd) {
            super(actual);
            this.labelNamesToAdd = labelNamesToAdd;
            this.seenLabels = new boolean[labelNamesToAdd.length];
        }

        public boolean labelField(long labelField) {
            this.seenLabelField = true;
            return super.labelField(labelField);
        }

        public boolean labels(String[] labels) {
            if (!this.seenLabelField) {
                for (String label : labels) {
                    for (int i = 0; i < this.labelNamesToAdd.length; ++i) {
                        if (this.seenLabels[i] || !this.labelNamesToAdd[i].equals(label)) continue;
                        this.seenLabels[i] = true;
                    }
                }
            }
            return super.labels(labels);
        }

        public void endOfEntity() throws IOException {
            if (!this.seenLabelField) {
                for (int i = 0; i < this.seenLabels.length; ++i) {
                    if (this.seenLabels[i]) continue;
                    this.transport[0] = this.labelNamesToAdd[i];
                    super.labels(this.transport);
                }
            }
            Arrays.fill(this.seenLabels, false);
            this.seenLabelField = false;
            super.endOfEntity();
        }
    }
}

