/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.StampedLock;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.staging.AbstractStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;

public abstract class ForkedProcessorStep<T>
extends AbstractStep<T> {
    private final Object[] forkedProcessors;
    private volatile int numberOfForkedProcessors;
    private final AtomicReference<Unit> head;
    private final AtomicReference<Unit> tail;
    private final Thread downstreamSender;
    private volatile int targetNumberOfProcessors = 1;
    private final int maxProcessors;
    private final int maxQueueLength;
    private volatile Thread receiverThread;
    private final StampedLock stripingLock;
    private static final VarHandle COMPLETED_PROCESSORS;
    private static final VarHandle PROCESSING_TIME;

    protected ForkedProcessorStep(StageControl control, String name, Configuration config, StatsProvider ... statsProviders) {
        super(control, name, config, statsProviders);
        this.maxProcessors = Integer.max(1, (int)((double)config.maxNumberOfWorkerThreads() * 0.7));
        this.forkedProcessors = new Object[this.maxProcessors];
        this.stripingLock = new StampedLock();
        Unit noop = new Unit(-1L, null, 0);
        this.head = new AtomicReference<Unit>(noop);
        this.tail = new AtomicReference<Unit>(noop);
        this.stripingLock.unlock(this.applyProcessorCount(this.stripingLock.readLock()));
        this.downstreamSender = new CompletedBatchesSender(name + " [CompletedBatchSender]");
        this.maxQueueLength = this.maxProcessors + config.maxQueueSize() * 2;
    }

    private long applyProcessorCount(long lock) {
        if (this.numberOfForkedProcessors != this.targetNumberOfProcessors) {
            this.stripingLock.unlock(lock);
            lock = this.stripingLock.writeLock();
            this.awaitAllCompleted();
            int processors = this.targetNumberOfProcessors;
            while (this.numberOfForkedProcessors < processors) {
                if (this.forkedProcessors[this.numberOfForkedProcessors] == null) {
                    this.forkedProcessors[this.numberOfForkedProcessors] = new ForkedProcessor(this.numberOfForkedProcessors, this.tail.get());
                }
                ++this.numberOfForkedProcessors;
            }
            if (this.numberOfForkedProcessors > processors) {
                this.numberOfForkedProcessors = processors;
            }
        }
        return lock;
    }

    private void awaitAllCompleted() {
        while (this.head.get() != this.tail.get() && this.panic == null) {
            this.receiverThread = Thread.currentThread();
            PARK.park(this.receiverThread);
        }
    }

    @Override
    public int processors(int delta) {
        this.targetNumberOfProcessors = Integer.max(1, Integer.min(this.targetNumberOfProcessors + delta, this.maxProcessors));
        return this.targetNumberOfProcessors;
    }

    @Override
    public int maxProcessors() {
        return this.maxProcessors;
    }

    @Override
    public void start(int orderingGuarantees) {
        super.start(orderingGuarantees);
        this.downstreamSender.start();
    }

    @Override
    public long receive(long ticket, T batch) {
        long time = System.nanoTime();
        while (this.queuedBatches.get() >= this.maxQueueLength && !this.isPanic()) {
            this.receiverThread = Thread.currentThread();
            PARK.park(this.receiverThread);
        }
        long lock = this.applyProcessorCount(this.stripingLock.readLock());
        this.queuedBatches.incrementAndGet();
        Unit unit = new Unit(ticket, batch, this.numberOfForkedProcessors);
        Unit myHead = this.head.getAndSet(unit);
        myHead.next = unit;
        this.stripingLock.unlock(lock);
        return System.nanoTime() - time;
    }

    protected abstract void forkedProcess(int var1, int var2, T var3) throws Throwable;

    void sendDownstream(Unit unit) {
        this.downstreamIdleTime.add(this.downstream.receive(unit.ticket, unit.batch));
    }

    @Override
    public void close() throws Exception {
        Arrays.fill(this.forkedProcessors, null);
        super.close();
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            COMPLETED_PROCESSORS = l.findVarHandle(Unit.class, "completedProcessors", Integer.TYPE);
            PROCESSING_TIME = l.findVarHandle(Unit.class, "processingTime", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    class Unit {
        private final long ticket;
        private final T batch;
        private final int processors;
        private volatile int completedProcessors;
        private volatile long processingTime;
        private volatile Unit next;

        Unit(long ticket, T batch, int processors) {
            this.ticket = ticket;
            this.batch = batch;
            this.processors = processors;
        }

        boolean isCompleted() {
            return this.processors > 0 && this.processors == this.completedProcessors;
        }

        void processorDone(long time) {
            PROCESSING_TIME.getAndAdd(this, time);
            int prevCompletedProcessors = COMPLETED_PROCESSORS.getAndAdd(this, 1);
            assert (prevCompletedProcessors < this.processors) : prevCompletedProcessors + " vs " + this.processors + " for " + this.ticket;
        }

        public String toString() {
            return String.format("Unit[%d/%d]", this.completedProcessors, this.processors);
        }
    }

    private final class CompletedBatchesSender
    extends Thread {
        CompletedBatchesSender(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                Unit current = ForkedProcessorStep.this.tail.get();
                while (!ForkedProcessorStep.this.isCompleted() && !ForkedProcessorStep.this.isPanic()) {
                    Unit candidate = current.next;
                    if (candidate != null && candidate.isCompleted()) {
                        if (ForkedProcessorStep.this.downstream != null) {
                            ForkedProcessorStep.this.sendDownstream(candidate);
                        } else {
                            ForkedProcessorStep.this.control.recycle(candidate.batch);
                        }
                        current = candidate;
                        ForkedProcessorStep.this.tail.set(current);
                        ForkedProcessorStep.this.queuedBatches.decrementAndGet();
                        ForkedProcessorStep.this.doneBatches.incrementAndGet();
                        ForkedProcessorStep.this.totalProcessingTime.add(candidate.processingTime);
                        ForkedProcessorStep.this.checkNotifyEndDownstream();
                        continue;
                    }
                    Thread receiver = ForkedProcessorStep.this.receiverThread;
                    if (receiver != null) {
                        AbstractStep.PARK.unpark(receiver);
                    }
                    AbstractStep.PARK.park(this);
                }
            }
            catch (Throwable e) {
                ForkedProcessorStep.this.issuePanic(e, false);
            }
        }
    }

    class ForkedProcessor
    extends Thread {
        private final int id;
        private Unit current;

        ForkedProcessor(int id, Unit startingUnit) {
            super(ForkedProcessorStep.this.name() + "-" + id);
            this.id = id;
            this.current = startingUnit;
            this.start();
        }

        @Override
        public void run() {
            try {
                while (!ForkedProcessorStep.this.isCompleted() && !ForkedProcessorStep.this.isPanic()) {
                    Unit candidate = this.current.next;
                    if (candidate != null) {
                        if (this.id < candidate.processors) {
                            long time = System.nanoTime();
                            ForkedProcessorStep.this.forkedProcess(this.id, candidate.processors, candidate.batch);
                            candidate.processorDone(System.nanoTime() - time);
                        }
                        this.current = candidate;
                        continue;
                    }
                    AbstractStep.PARK.park(this);
                }
            }
            catch (Throwable e) {
                ForkedProcessorStep.this.issuePanic(e, false);
            }
        }
    }
}

