/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.apache.commons.lang3.ClassUtils;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.lazy.LazyIterableAdapter;
import org.neo4j.genai.util.ParameterValueMapper;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.procedure.impl.TypeCheckers;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class Parameters {
    private static final ValueMapper<Object> MAPPER = new ParameterValueMapper();

    public static <T> T parse(Class<T> parameterDeclaration, MapValue map) {
        try {
            T instance = Parameters.constructInstance(parameterDeclaration);
            List<Parameter> parameters = Parameters.getParameters(parameterDeclaration, instance);
            for (Parameter parameter : parameters) {
                Object value2 = parameter.getFromMap(map);
                parameter.field.set(instance, value2);
            }
            if (instance instanceof WithDynamic) {
                WithDynamic withDynamic = (WithDynamic)instance;
                MutableSet parameterKeys = new LazyIterableAdapter(parameters).collect(Parameter::name).toSet();
                MutableMap dynamicValues = Maps.mutable.empty();
                map.foreach((key, value) -> {
                    if (!parameterKeys.contains(key)) {
                        dynamicValues.put(key, Parameters.toOptionalJavaValue(value).orElse(null));
                    }
                });
                withDynamic.dynamic = dynamicValues.asUnmodifiable();
            }
            return instance;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<Object> toOptionalJavaValue(AnyValue value) {
        return value != Values.NO_VALUE ? Optional.of(value.map(MAPPER)) : Optional.empty();
    }

    public static <T> List<Parameter> getParameters(Class<T> parameterDeclaration) {
        T defaults = Parameters.constructInstance(parameterDeclaration);
        return Parameters.getParameters(parameterDeclaration, defaults);
    }

    private static <T> List<Parameter> getParameters(Class<T> parameterDeclaration, T defaults) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Field field : parameterDeclaration.getDeclaredFields()) {
            if (!field.canAccess(defaults)) continue;
            parameters.add(new Parameter(field, defaults));
        }
        return parameters;
    }

    private static <T> T constructInstance(Class<T> parameterDeclaration) {
        try {
            Constructor<T> constructor = parameterDeclaration.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("%s must have an accessible zero-argument constructor".formatted(parameterDeclaration.getCanonicalName()));
        }
    }

    public static class Parameter {
        private static final TypeCheckers TYPE_CHECKERS = new TypeCheckers();
        private final ParameterType type;
        private final Field field;
        private final Object defaultValue;

        public String name() {
            return this.field.getName();
        }

        public ParameterType type() {
            return this.type;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public boolean isRequired() {
            return !this.type.nullable && this.defaultValue == null;
        }

        public boolean isOptional() {
            return !this.isRequired();
        }

        public Object getFromMap(MapValue config) {
            AnyValue value = this.get(config, this.name());
            if (value == null) {
                if (this.isRequired()) {
                    throw new IllegalArgumentException("'%s' is expected to have been set".formatted(this.name()));
                }
                return this.defaultValue;
            }
            Object object = this.toJavaValueOfExpectedType(value);
            if (object == null && this.isRequired()) {
                throw new IllegalArgumentException("'%s' is expected to be non-null".formatted(this.name()));
            }
            return this.wrapIfNullable(object);
        }

        private Parameter(Field field, Object defaults) {
            this.field = field;
            this.type = Parameter.typeOf(field);
            this.defaultValue = this.computeDefaultValue(defaults);
        }

        private Object computeDefaultValue(Object defaults) {
            if (defaults == null) {
                return null;
            }
            try {
                Object defaultValue = this.field.get(defaults);
                if (defaultValue != null) {
                    if (this.annotatedAsRequired()) {
                        if (!this.type.javaType.isPrimitive()) {
                            throw new IllegalStateException("'%s' cannot have a default and be explicitly annotated '@%s'".formatted(this.name(), Required.class.getSimpleName()));
                        }
                        return null;
                    }
                    if (this.type.nullable) {
                        throw new IllegalStateException("'%s' cannot have a default value and have type '%s'".formatted(this.name(), this.type.javaType.getSimpleName()));
                    }
                    return defaultValue;
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (this.type.nullable) {
                if (this.annotatedAsRequired()) {
                    throw new IllegalStateException("'%s' cannot be explicitly annotated '@%s' and have type '%s'".formatted(this.name(), Required.class.getSimpleName(), this.type.javaType.getSimpleName()));
                }
                return this.emptyOptional();
            }
            return null;
        }

        private boolean annotatedAsRequired() {
            return this.field.isAnnotationPresent(Required.class);
        }

        private Object emptyOptional() {
            if (this.type.javaType == Optional.class) {
                return Optional.empty();
            }
            if (this.type.javaType == OptionalLong.class) {
                return OptionalLong.empty();
            }
            if (this.type.javaType == OptionalDouble.class) {
                return OptionalDouble.empty();
            }
            throw new IllegalArgumentException("invalid optional type");
        }

        private Object optionalOf(Object value) {
            if (this.type.javaType == Optional.class) {
                return Optional.of(value);
            }
            if (this.type.javaType == OptionalLong.class) {
                return OptionalLong.of((Long)value);
            }
            if (this.type.javaType == OptionalDouble.class) {
                return OptionalDouble.of((Double)value);
            }
            throw new IllegalArgumentException("invalid optional type");
        }

        private Object optionalOfNullable(Object value) {
            return value != null ? this.optionalOf(value) : this.emptyOptional();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static ParameterType typeOf(Field field) {
            Class<?> javaType = field.getType();
            Class valueType = javaType;
            boolean nullable = false;
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                if (parameterizedType.getRawType() == Optional.class) {
                    Class innerType;
                    Type type2;
                    Type[] typeArgs = parameterizedType.getActualTypeArguments();
                    if (typeArgs.length != 1 || !((type2 = typeArgs[0]) instanceof Class)) throw new IllegalArgumentException("parameter has invalid optional type");
                    valueType = innerType = (Class)type2;
                    nullable = true;
                }
            } else if (javaType == OptionalLong.class) {
                valueType = Long.TYPE;
                nullable = true;
            } else if (javaType == OptionalDouble.class) {
                valueType = Double.TYPE;
                nullable = true;
            }
            try {
                String cypherTypeName = TYPE_CHECKERS.converterFor(valueType).type().toString();
                return new ParameterType(javaType, valueType, nullable, cypherTypeName);
            }
            catch (ProcedureException e) {
                throw new IllegalArgumentException("Parameter '%s' is of an unsupported type: %s".formatted(field.getName(), e.getMessage()));
            }
        }

        private AnyValue get(MapValue config, String key) {
            return config.containsKey(key) ? config.get(key) : null;
        }

        private Object wrapIfNullable(Object value) {
            return this.type.nullable ? this.optionalOfNullable(value) : value;
        }

        private Object toJavaValueOfExpectedType(AnyValue value) {
            Class<?> expectedType;
            if (value == Values.NO_VALUE) {
                return null;
            }
            Object javaValue = value.map(MAPPER);
            Class<?> actualType = javaValue.getClass();
            if (!ClassUtils.isAssignable(actualType, expectedType = this.type.valueType, (boolean)true)) {
                throw new IllegalArgumentException("'%s' is expected to have been of type %s".formatted(this.name(), this.type.cypherName()));
            }
            return javaValue;
        }
    }

    public static class WithDynamic {
        private Map<String, Object> dynamic;

        public Map<String, Object> dynamic() {
            return this.dynamic;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Required {
    }

    public record ParameterType(Class<?> javaType, Class<?> valueType, boolean nullable, String cypherTypeName) {
        public String cypherName() {
            return this.cypherTypeName + (this.nullable ? "" : " NOT NULL");
        }
    }
}

