/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.KeyLayout;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;

public class LongKeyLayout
extends KeyLayout.Adapter<LongKey> {
    protected LongKeyLayout() {
        super(true, Layout.namedIdentifier("long", 1234), 1, 0);
    }

    @Override
    public LongKey newKey() {
        return new LongKey();
    }

    public LongKey newKey(long id) {
        return new LongKey().initialize(id);
    }

    @Override
    public LongKey copyKey(LongKey key, LongKey into) {
        into.id = key.id;
        return into;
    }

    @Override
    public int keySize(LongKey key) {
        return 8;
    }

    @Override
    public void writeKey(PageCursor cursor, LongKey key) {
        cursor.putLong(key.id);
    }

    @Override
    public void readKey(PageCursor cursor, LongKey into, int keySize) {
        into.id = cursor.getLong();
    }

    @Override
    public void initializeAsLowest(LongKey key) {
        key.id = Long.MIN_VALUE;
    }

    @Override
    public void initializeAsHighest(LongKey key) {
        key.id = Long.MAX_VALUE;
    }

    @Override
    public int compare(LongKey o1, LongKey o2) {
        return Long.compare(o1.id, o2.id);
    }

    static class LongKey {
        long id;

        LongKey() {
        }

        LongKey initialize(long id) {
            this.id = id;
            return this;
        }

        public int hashCode() {
            return Long.hashCode(this.id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongKey longKey = (LongKey)o;
            return this.id == longKey.id;
        }

        public String toString() {
            return "LongKey{id=" + this.id + "}";
        }
    }
}

