/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.parser.v6.ast.factory;

import java.io.Serializable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.neo4j.cypher.internal.expressions.FunctionName;
import org.neo4j.cypher.internal.parser.AstRuleCtx;
import org.neo4j.cypher.internal.parser.ast.SyntaxChecker;
import org.neo4j.cypher.internal.parser.ast.util.Util$;
import org.neo4j.cypher.internal.parser.common.ast.factory.ASTExceptionFactory;
import org.neo4j.cypher.internal.parser.common.ast.factory.ConstraintType;
import org.neo4j.cypher.internal.parser.common.ast.factory.HintIndexType;
import org.neo4j.cypher.internal.parser.v6.Cypher6Parser;
import org.neo4j.cypher.internal.parser.v6.ast.factory.Cypher6SyntaxChecker$;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.CypherExceptionFactory;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.cypher.internal.util.symbols.ClosedDynamicUnionType;
import org.neo4j.internal.helpers.NameUtil;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0005\rMa\u0001\u0002\u0017.\u0005yB\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u00071\u0002\u0001\u000b\u0015B-\t\u000b)\u0004A\u0011I6\t\u000bA\u0004A\u0011I9\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!a\u0013\u0001\t\u0013\ti\u0005C\u0004\u0002l\u0001!I!!\u001c\t\u0013\u0005e\u0005!%A\u0005\n\u0005m\u0005bBA[\u0001\u0011%\u0011q\u0017\u0005\n\u0003\u0017\u0004\u0011\u0013!C\u0005\u0003\u001bDq!!5\u0001\t\u0013\t\u0019\u000eC\u0004\u0003\u0002\u0001!IAa\u0001\t\u000f\t]\u0001\u0001\"\u0003\u0003\u001a!9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B\u001a\u0001\u0011%!Q\u0007\u0005\b\u0005\u007f\u0001A\u0011\u0002B!\u0011\u001d\u00119\u0005\u0001C\u0005\u0005\u0013BqAa\u0015\u0001\t\u0013\u0011)\u0006C\u0004\u0003`\u0001!IA!\u0019\t\u000f\t-\u0004\u0001\"\u0003\u0003n!9!q\u000f\u0001\u0005\n\te\u0004b\u0002BB\u0001\u0011%!Q\u0011\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0011\u001d\u0011Y\n\u0001C\u0005\u0005;CqAa*\u0001\t\u0013\u0011I\u000bC\u0004\u00034\u0002!IA!.\t\u000f\t}\u0006\u0001\"\u0003\u0003B\"9!1\u001a\u0001\u0005\n\t5\u0007b\u0002Bl\u0001\u0011%!\u0011\u001c\u0005\b\u0005G\u0004A\u0011\u0002Bs\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005c<qAa?.\u0011\u0003\u0011iP\u0002\u0004-[!\u0005!q \u0005\u0007'\u001a\"\taa\u0002\t\u0013\r%aE1A\u0005\n\r-\u0001\u0002CB\u0007M\u0001\u0006IA!\u0004\t\u0013\r=aE1A\u0005\n\r-\u0001\u0002CB\tM\u0001\u0006IA!\u0004\u0003)\rK\b\u000f[3smMKh\u000e^1y\u0007\",7m[3s\u0015\tqs&A\u0004gC\u000e$xN]=\u000b\u0005A\n\u0014aA1ti*\u0011!gM\u0001\u0003mZR!\u0001N\u001b\u0002\rA\f'o]3s\u0015\t1t'\u0001\u0005j]R,'O\\1m\u0015\tA\u0014(\u0001\u0004dsBDWM\u001d\u0006\u0003um\nQA\\3pi)T\u0011\u0001P\u0001\u0004_J<7\u0001A\n\u0004\u0001}:\u0005C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\u000bAA[1wC&\u0011a)\u0011\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005!SU\"A%\u000b\u0005A\u001a\u0014BA&J\u00055\u0019\u0016P\u001c;bq\u000eCWmY6fe\u0006\u0001R\r_2faRLwN\u001c$bGR|'/\u001f\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!V\nA!\u001e;jY&\u0011!k\u0014\u0002\u0017\u0007f\u0004\b.\u001a:Fq\u000e,\u0007\u000f^5p]\u001a\u000b7\r^8ss\u00061A(\u001b8jiz\"\"!V,\u0011\u0005Y\u0003Q\"A\u0017\t\u000b1\u0013\u0001\u0019A'\u0002\u000f}+'O]8sgB\u0019!\fZ4\u000f\u0005m\u000bgB\u0001/`\u001b\u0005i&B\u00010>\u0003\u0019a$o\\8u}%\t\u0001-A\u0003tG\u0006d\u0017-\u0003\u0002cG\u00069\u0001/Y2lC\u001e,'\"\u00011\n\u0005\u00154'aA*fc*\u0011!m\u0019\t\u00035\"L!!\u001b4\u0003\u0013\u0015C8-\u001a9uS>t\u0017AB3se>\u00148/F\u0001m!\rQF-\u001c\t\u00035:L!a\u001c4\u0003\u0013QC'o\\<bE2,\u0017!\u0004<jg&$H+\u001a:nS:\fG\u000e\u0006\u0002smB\u00111\u000f^\u0007\u0002G&\u0011Qo\u0019\u0002\u0005+:LG\u000fC\u0003x\u000b\u0001\u0007\u00010\u0001\u0003o_\u0012,\u0007cA=\u0002\u00065\t!P\u0003\u0002|y\u0006!AO]3f\u0015\tih0A\u0004sk:$\u0018.\\3\u000b\u0007}\f\t!\u0001\u0002wi)\u0019\u00111A\u001e\u0002\u000b\u0005tG\u000f\u001c:\n\u0007\u0005\u001d!P\u0001\u0007UKJl\u0017N\\1m\u001d>$W-\u0001\bwSNLG/\u0012:s_Jtu\u000eZ3\u0015\u0007I\fi\u0001\u0003\u0004x\r\u0001\u0007\u0011q\u0002\t\u0004s\u0006E\u0011bAA\nu\nIQI\u001d:pe:{G-Z\u0001\u000fK:$XM]#wKJL(+\u001e7f)\r\u0011\u0018\u0011\u0004\u0005\b\u000379\u0001\u0019AA\u000f\u0003\r\u0019G\u000f\u001f\t\u0005\u0003?\t\t#D\u0001}\u0013\r\t\u0019\u0003 \u0002\u0012!\u0006\u00148/\u001a:Sk2,7i\u001c8uKb$\u0018!D3ySR,e/\u001a:z%VdW\rF\u0002s\u0003SAq!a\u0007\t\u0001\u0004\ti\"A\u0003dQ\u0016\u001c7\u000e\u0006\u0003\u00020\u0005U\u0002cA:\u00022%\u0019\u00111G2\u0003\u000f\t{w\u000e\\3b]\"9\u00111D\u0005A\u0002\u0005u\u0011!D5oaV$\bk\\:ji&|g\u000e\u0006\u0003\u0002<\u0005\u0005\u0003c\u0001(\u0002>%\u0019\u0011qH(\u0003\u001b%s\u0007/\u001e;Q_NLG/[8o\u0011\u001d\t\u0019E\u0003a\u0001\u0003\u000b\naa]=nE>d\u0007\u0003BA\u0010\u0003\u000fJ1!!\u0013}\u0005\u0015!vn[3o\u0003A)'O]8s\u001f:$U\u000f\u001d7jG\u0006$X\rF\u0004s\u0003\u001f\n\u0019&a\u001a\t\u000f\u0005E3\u00021\u0001\u0002F\u0005)Ao\\6f]\"9\u0011QK\u0006A\u0002\u0005]\u0013a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004B!!\u0017\u0002b9!\u00111LA/!\ta6-C\u0002\u0002`\r\fa\u0001\u0015:fI\u00164\u0017\u0002BA2\u0003K\u0012aa\u0015;sS:<'bAA0G\"9\u0011\u0011N\u0006A\u0002\u0005=\u0012aB5t!\u0006\u0014\u0018-\\\u0001\u0014KJ\u0014xN](o\tV\u0004H.[2bi\u0016\u001cE\u000f_\u000b\u0005\u0003_\n\t\tF\u0004s\u0003c\n)*a&\t\u000f\u0005mA\u00021\u0001\u0002tA1\u0011QOA=\u0003{j!!a\u001e\u000b\u0005A\u001b\u0015\u0002BA>\u0003o\u0012A\u0001T5tiB!\u0011qPAA\u0019\u0001!q!a!\r\u0005\u0004\t)IA\u0001U#\u0011\t9)!$\u0011\u0007M\fI)C\u0002\u0002\f\u000e\u0014qAT8uQ&tw\r\u0005\u0003\u0002\u0010\u0006EU\"A\u001a\n\u0007\u0005M5G\u0001\u0006BgR\u0014V\u000f\\3DibDq!!\u0016\r\u0001\u0004\t9\u0006C\u0005\u0002j1\u0001\n\u00111\u0001\u00020\u0005iRM\u001d:pe>sG)\u001e9mS\u000e\fG/Z\"uq\u0012\"WMZ1vYR$3'\u0006\u0003\u0002\u001e\u0006MVCAAPU\u0011\ty#!),\u0005\u0005\r\u0006\u0003BAS\u0003_k!!a*\u000b\t\u0005%\u00161V\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!,d\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\u000b9KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$q!a!\u000e\u0005\u0004\t))\u0001\u000bfeJ|'o\u00148EkBd\u0017nY1uKJ+H.Z\u000b\u0005\u0003s\u000b\u0019\rF\u0004s\u0003w\u000b9-!3\t\u000f\u0005uf\u00021\u0001\u0002@\u00061\u0001/\u0019:b[N\u0004b!!\u001e\u0002z\u0005\u0005\u0007\u0003BA@\u0003\u0007$q!a!\u000f\u0005\u0004\t)-\u0005\u0003\u0002\b\u0006u\u0001bBA+\u001d\u0001\u0007\u0011q\u000b\u0005\n\u0003Sr\u0001\u0013!a\u0001\u0003_\ta$\u001a:s_J|e\u000eR;qY&\u001c\u0017\r^3Sk2,G\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005u\u0015q\u001a\u0003\b\u0003\u0007{!\u0019AAc\u0003y)'O]8s\u001f:\fE.[1t\u001d\u0006lWmQ8oi\u0006Lg.\u001b8h\t>$8\u000fF\u0002s\u0003+Dq!a6\u0011\u0001\u0004\tI.\u0001\u0007bY&\f7/Z:OC6,7\u000f\u0005\u0004\u0002v\u0005e\u00141\u001c\t\u0005\u0003;\fYP\u0004\u0003\u0002`\u0006]h\u0002BAq\u0003ktA!a9\u0002t:!\u0011Q]Ay\u001d\u0011\t9/a<\u000f\t\u0005%\u0018Q\u001e\b\u00049\u0006-\u0018\"\u0001\u001f\n\u0005iZ\u0014B\u0001\u001d:\u0013\t1t'\u0003\u00025k%\u0011!gM\u0005\u0004\u0003s\f\u0014!D\"za\",'O\u000e)beN,'/\u0003\u0003\u0002~\u0006}(aI*z[\n|G.[2BY&\f7OT1nK>\u0013\b+\u0019:b[\u0016$XM]\"p]R,\u0007\u0010\u001e\u0006\u0004\u0003s\f\u0014aK3se>\u0014xJ\\!mS\u0006\u001ch*Y7f\u0007>tG/Y5oS:<Gk\\8NC:L8i\\7q_:,g\u000e^:\u0015\u000fI\u0014)A!\u0003\u0003\u0014!9\u0011q[\tA\u0002\t\u001d\u0001\u0003\u0002.e\u00037DqAa\u0003\u0012\u0001\u0004\u0011i!A\u0007nCb\u001cu.\u001c9p]\u0016tGo\u001d\t\u0004g\n=\u0011b\u0001B\tG\n\u0019\u0011J\u001c;\t\u000f\tU\u0011\u00031\u0001\u0002X\u0005iQM\u001d:peR+W\u000e\u001d7bi\u0016\fQe\u00195fG.\u001cVOY9vKJL\u0018J\u001c+sC:\u001c\u0018m\u0019;j_:\u001c\b+\u0019:b[\u0016$XM]:\u0015\u0007I\u0014Y\u0002C\u0004\u0002\u001cI\u0001\rA!\b\u0011\t\t}!1\u0005\b\u0005\u0005C\t90D\u00012\u0013\u0011\u0011)#a@\u0003OM+(-];fefLe\u000e\u0016:b]N\f7\r^5p]N\u0004\u0016M]1nKR,'o]\"p]R,\u0007\u0010^\u0001\u0011G\",7m[\"sK\u0006$X-\u00117jCN$2A\u001dB\u0016\u0011\u001d\tYb\u0005a\u0001\u0005[\u0001BAa\b\u00030%!!\u0011GA\u0000\u0005I\u0019%/Z1uK\u0006c\u0017.Y:D_:$X\r\u001f;\u0002\u001f\rDWmY6BYR,'/\u00117jCN$2A\u001dB\u001c\u0011\u001d\tY\u0002\u0006a\u0001\u0005s\u0001BAa\b\u0003<%!!QHA\u0000\u0005E\tE\u000e^3s\u00032L\u0017m]\"p]R,\u0007\u0010^\u0001\"G\",7m[*z[\n|G.[2BY&\f7OT1nK>\u0013\b+\u0019:b[\u0016$XM\u001d\u000b\u0004e\n\r\u0003bBA\u000e+\u0001\u0007!Q\t\t\u0005\u0005?\tY0A\bdQ\u0016\u001c7n\u0011:fCR,Wk]3s)\r\u0011(1\n\u0005\b\u000371\u0002\u0019\u0001B'!\u0011\u0011yBa\u0014\n\t\tE\u0013q \u0002\u0012\u0007J,\u0017\r^3Vg\u0016\u00148i\u001c8uKb$\u0018AD2iK\u000e\\\u0017\t\u001c;feV\u001bXM\u001d\u000b\u0004e\n]\u0003bBA\u000e/\u0001\u0007!\u0011\f\t\u0005\u0005?\u0011Y&\u0003\u0003\u0003^\u0005}(\u0001E!mi\u0016\u0014Xk]3s\u0007>tG/\u001a=u\u0003E\u0019\u0007.Z2l\u00032d\u0007K]5wS2,w-\u001a\u000b\u0004e\n\r\u0004bBA\u000e1\u0001\u0007!Q\r\t\u0005\u0005?\u00119'\u0003\u0003\u0003j\u0005}(aE!mYB\u0013\u0018N^5mK\u001e,7i\u001c8uKb$\u0018!D2iK\u000e\\w\t\\8c!\u0006\u0014H\u000fF\u0002s\u0005_Bq!a\u0007\u001a\u0001\u0004\u0011\t\b\u0005\u0003\u0003 \tM\u0014\u0002\u0002B;\u0003\u007f\u0014qb\u00127pEB\u000b'\u000f^\"p]R,\u0007\u0010^\u0001\u0016G\",7m[\"sK\u0006$XmQ8ogR\u0014\u0018-\u001b8u)\r\u0011(1\u0010\u0005\b\u00037Q\u0002\u0019\u0001B?!\u0011\u0011yBa \n\t\t\u0005\u0015q \u0002\u0018\u0007J,\u0017\r^3D_:\u001cHO]1j]R\u001cuN\u001c;fqR\f\u0011d\u00195fG.,en\u00197pg\u0016$\u0007K]8qKJ$\u0018\u0010T5tiR\u0019!Oa\"\t\u000f\u0005m1\u00041\u0001\u0003\nB!!q\u0004BF\u0013\u0011\u0011i)a@\u00037\u0015s7\r\\8tK\u0012\u0004&o\u001c9feRLH*[:u\u0007>tG/\u001a=u\u0003M\u0019\u0007.Z2l\u0007J,\u0017\r^3ECR\f'-Y:f)\r\u0011(1\u0013\u0005\b\u00037a\u0002\u0019\u0001BK!\u0011\u0011yBa&\n\t\te\u0015q \u0002\u0016\u0007J,\u0017\r^3ECR\f'-Y:f\u0007>tG/\u001a=u\u0003I\u0019\u0007.Z2l\u00032$XM\u001d#bi\u0006\u0014\u0017m]3\u0015\u0007I\u0014y\nC\u0004\u0002\u001cu\u0001\rA!)\u0011\t\t}!1U\u0005\u0005\u0005K\u000byP\u0001\u000bBYR,'\u000fR1uC\n\f7/Z\"p]R,\u0007\u0010^\u0001\u001bG\",7m[!mi\u0016\u0014H)\u0019;bE\u0006\u001cX\rV8q_2|w-\u001f\u000b\u0004e\n-\u0006bBA\u000e=\u0001\u0007!Q\u0016\t\u0005\u0005?\u0011y+\u0003\u0003\u00032\u0006}(\u0001H!mi\u0016\u0014H)\u0019;bE\u0006\u001cX\rV8q_2|w-_\"p]R,\u0007\u0010^\u0001\u0017G\",7m[\"sK\u0006$X\rT8pWV\u0004\u0018J\u001c3fqR\u0019!Oa.\t\u000f\u0005mq\u00041\u0001\u0003:B!!q\u0004B^\u0013\u0011\u0011i,a@\u00031\r\u0013X-\u0019;f\u0019>|7.\u001e9J]\u0012,\u0007pQ8oi\u0016DH/\u0001\ndQ\u0016\u001c7.\u00138tKJ$\b+\u0019;uKJtGc\u0001:\u0003D\"9\u00111\u0004\u0011A\u0002\t\u0015\u0007\u0003\u0002B\u0010\u0005\u000fLAA!3\u0002\u0000\n!\u0012J\\:feR\u0004\u0016\r\u001e;fe:\u001cuN\u001c;fqR\f1d\u00195fG.Len]3si2\u000b'-\u001a7D_:TWO\\2uS>tGc\u0001:\u0003P\"9\u00111D\u0011A\u0002\tE\u0007\u0003\u0002B\u0010\u0005'LAA!6\u0002\u0000\n\u0001\u0013J\\:feRtu\u000eZ3MC\n,G.\u0012=qe\u0016\u001c8/[8o\u0007>tG/\u001a=u\u0003]\u0019\u0007.Z2l\rVt7\r^5p]&sgo\\2bi&|g\u000eF\u0002s\u00057Dq!a\u0007#\u0001\u0004\u0011i\u000e\u0005\u0003\u0003 \t}\u0017\u0002\u0002Bq\u0003\u007f\u0014\u0011DR;oGRLwN\\%om>\u001c\u0017\r^5p]\u000e{g\u000e^3yi\u0006i1\r[3dWRK\b/\u001a)beR$2A\u001dBt\u0011\u001d\tYb\ta\u0001\u0005S\u0004BAa\b\u0003l&!!Q^A\u0000\u0005=!\u0016\u0010]3QCJ$8i\u001c8uKb$\u0018!C2iK\u000e\\\u0007*\u001b8u)\r\u0011(1\u001f\u0005\b\u00037!\u0003\u0019\u0001B{!\u0011\u0011yBa>\n\t\te\u0018q \u0002\f\u0011&tGoQ8oi\u0016DH/\u0001\u000bDsBDWM\u001d\u001cTs:$\u0018\r_\"iK\u000e\\WM\u001d\t\u0003-\u001a\u001a2AJB\u0001!\r\u001981A\u0005\u0004\u0007\u000b\u0019'AB!osJ+g\r\u0006\u0002\u0003~\u0006IR*\u0011-`\u00032K\u0015iU0O\u00036+ulQ(N!>sUI\u0014+T+\t\u0011i!\u0001\u000eN\u0003b{\u0016\tT%B'~s\u0015)T#`\u0007>k\u0005k\u0014(F\u001dR\u001b\u0006%\u0001\u000fN\u0003b{F)\u0011+B\u0005\u0006\u001bVi\u0018(B\u001b\u0016{6iT'Q\u001f:+e\nV*\u0002;5\u000b\u0005l\u0018#B)\u0006\u0013\u0015iU#`\u001d\u0006kUiX\"P\u001bB{e*\u0012(U'\u0002\u0002")
public final class Cypher6SyntaxChecker
implements SyntaxChecker {
    private final CypherExceptionFactory exceptionFactory;
    private Seq<Exception> _errors;

    public Seq<Throwable> errors() {
        return this._errors;
    }

    public void visitTerminal(TerminalNode node) {
    }

    public void visitErrorNode(ErrorNode node) {
    }

    public void enterEveryRule(ParserRuleContext ctx) {
    }

    public void exitEveryRule(ParserRuleContext ctx) {
        int n = ctx.getRuleIndex();
        switch (n) {
            case 41: {
                this.checkSubqueryInTransactionsParameters((Cypher6Parser.SubqueryInTransactionsParametersContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 175: {
                this.checkCreateConstraint((Cypher6Parser.CreateConstraintContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 188: {
                this.checkEnclosedPropertyList((Cypher6Parser.EnclosedPropertyListContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 183: {
                this.checkCreateLookupIndex((Cypher6Parser.CreateLookupIndexContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 211: {
                this.checkCreateUser((Cypher6Parser.CreateUserContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 215: {
                this.checkAlterUser((Cypher6Parser.AlterUserContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 234: {
                this.checkAllPrivilege((Cypher6Parser.AllPrivilegeContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 279: {
                this.checkCreateDatabase((Cypher6Parser.CreateDatabaseContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 285: {
                this.checkAlterDatabase((Cypher6Parser.AlterDatabaseContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 287: {
                this.checkAlterDatabaseTopology((Cypher6Parser.AlterDatabaseTopologyContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 294: {
                this.checkCreateAlias((Cypher6Parser.CreateAliasContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 296: {
                this.checkAlterAlias((Cypher6Parser.AlterAliasContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 265: {
                this.checkGlobPart((Cypher6Parser.GlobPartContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 48: {
                this.checkInsertPattern((Cypher6Parser.InsertPatternContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 83: {
                this.checkInsertLabelConjunction((Cypher6Parser.InsertNodeLabelExpressionContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 131: {
                this.checkFunctionInvocation((Cypher6Parser.FunctionInvocationContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 138: {
                this.checkTypePart((Cypher6Parser.TypePartContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 29: {
                this.checkHint((Cypher6Parser.HintContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 307: {
                this.checkSymbolicAliasNameOrParameter((Cypher6Parser.SymbolicAliasNameOrParameterContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
        }
    }

    public boolean check(ParserRuleContext ctx) {
        this.exitEveryRule(ctx);
        return this._errors.isEmpty();
    }

    private InputPosition inputPosition(Token symbol) {
        return InputPosition$.MODULE$.apply(symbol.getStartIndex(), symbol.getLine(), symbol.getCharPositionInLine() + 1);
    }

    private void errorOnDuplicate(Token token, String description, boolean isParam) {
        if (isParam) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Duplicated " + description + " parameters", this.inputPosition(token)));
            return;
        }
        this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Duplicate " + description + " clause", this.inputPosition(token)));
    }

    private <T extends AstRuleCtx> void errorOnDuplicateCtx(java.util.List<T> ctx, String description, boolean isParam) {
        if (ctx.size() > 1) {
            this.errorOnDuplicate(Util$.MODULE$.nodeChild((AstRuleCtx)ctx.get(1), 0).getSymbol(), description, isParam);
            return;
        }
    }

    private <T extends AstRuleCtx> boolean errorOnDuplicateCtx$default$3() {
        return false;
    }

    private <T extends ParserRuleContext> void errorOnDuplicateRule(java.util.List<T> params, String description, boolean isParam) {
        if (params.size() > 1) {
            this.errorOnDuplicate(((ParserRuleContext)params.get((int)1)).start, description, isParam);
            return;
        }
    }

    private <T extends ParserRuleContext> boolean errorOnDuplicateRule$default$3() {
        return false;
    }

    private void errorOnAliasNameContainingDots(java.util.List<Cypher6Parser.SymbolicAliasNameOrParameterContext> aliasesNames) {
        if (aliasesNames.size() > 0) {
            Cypher6Parser.SymbolicAliasNameOrParameterContext aliasName = aliasesNames.get(0);
            if (aliasName.symbolicAliasName() != null && aliasName.symbolicAliasName().symbolicNameString().size() > Cypher6SyntaxChecker$.MODULE$.org$neo4j$cypher$internal$parser$v6$ast$factory$Cypher6SyntaxChecker$$MAX_ALIAS_NAME_COMPONENTS()) {
                Token start = ((ParserRuleContext)aliasName.symbolicAliasName().symbolicNameString().get(0)).getStart();
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'.' is not a valid character in the remote alias name '" + aliasName.getText() + "'. Remote alias names using '.' must be quoted with backticks e.g. `remote.alias`.", this.inputPosition(start)));
                return;
            }
            return;
        }
    }

    private void errorOnAliasNameContainingTooManyComponents(Seq<Cypher6Parser.SymbolicAliasNameOrParameterContext> aliasesNames, int maxComponents, String errorTemplate) {
        if (aliasesNames.nonEmpty()) {
            Seq literalAliasNames = (Seq)aliasesNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Cypher6SyntaxChecker.$anonfun$errorOnAliasNameContainingTooManyComponents$1(x$1)));
            literalAliasNames.foreach((Function1 & Serializable)aliasName -> {
                Cypher6SyntaxChecker.$anonfun$errorOnAliasNameContainingTooManyComponents$2(this, maxComponents, errorTemplate, aliasName);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void checkSubqueryInTransactionsParameters(Cypher6Parser.SubqueryInTransactionsParametersContext ctx) {
        this.errorOnDuplicateRule(ctx.subqueryInTransactionsBatchParameters(), "OF ROWS", true);
        this.errorOnDuplicateRule(ctx.subqueryInTransactionsErrorParameters(), "ON ERROR", true);
        this.errorOnDuplicateRule(ctx.subqueryInTransactionsReportParameters(), "REPORT STATUS", true);
    }

    private void checkCreateAlias(Cypher6Parser.CreateAliasContext ctx) {
        if (ctx.stringOrParameter() != null) {
            if (ctx.AT() != null || ctx.USER() != null || ctx.PASSWORD() != null || ctx.DRIVER() != null) {
                this.errorOnAliasNameContainingDots(ctx.symbolicAliasNameOrParameter());
                return;
            }
            return;
        }
    }

    private void checkAlterAlias(Cypher6Parser.AlterAliasContext ctx) {
        java.util.List aliasTargets = ctx.alterAliasTarget();
        boolean hasUrl = !aliasTargets.isEmpty() && ((Cypher6Parser.AlterAliasTargetContext)aliasTargets.get(0)).AT() != null;
        java.util.List usernames = ctx.alterAliasUser();
        java.util.List passwords = ctx.alterAliasPassword();
        java.util.List driverSettings = ctx.alterAliasDriver();
        if (hasUrl || !usernames.isEmpty() || !passwords.isEmpty() || !driverSettings.isEmpty()) {
            this.errorOnAliasNameContainingDots(java.util.List.of(ctx.symbolicAliasNameOrParameter()));
        }
        this.errorOnDuplicateCtx(driverSettings, "DRIVER", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(usernames, "USER", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(passwords, "PASSWORD", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(ctx.alterAliasProperties(), "PROPERTIES", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(aliasTargets, "TARGET", this.errorOnDuplicateCtx$default$3());
    }

    private void checkSymbolicAliasNameOrParameter(Cypher6Parser.SymbolicAliasNameOrParameterContext ctx) {
        int n = ctx.getParent().getRuleIndex();
        switch (n) {
            case 279: {
                this.errorOnAliasNameContainingTooManyComponents((Seq<Cypher6Parser.SymbolicAliasNameOrParameterContext>)new .colon.colon((Object)ctx, (List)Nil$.MODULE$), Cypher6SyntaxChecker$.MODULE$.org$neo4j$cypher$internal$parser$v6$ast$factory$Cypher6SyntaxChecker$$MAX_DATABASE_NAME_COMPONENTS(), "Invalid input `%s` for database name. Expected name to contain at most one component.");
                return;
            }
            case 278: {
                return;
            }
        }
        this.errorOnAliasNameContainingTooManyComponents((Seq<Cypher6Parser.SymbolicAliasNameOrParameterContext>)new .colon.colon((Object)ctx, (List)Nil$.MODULE$), Cypher6SyntaxChecker$.MODULE$.org$neo4j$cypher$internal$parser$v6$ast$factory$Cypher6SyntaxChecker$$MAX_ALIAS_NAME_COMPONENTS(), "Invalid input `%s` for name. Expected name to contain at most two components separated by `.`.");
    }

    private void checkCreateUser(Cypher6Parser.CreateUserContext ctx) {
        this.errorOnDuplicateRule(ctx.userStatus(), "SET STATUS {SUSPENDED|ACTIVE}", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.homeDatabase(), "SET HOME DATABASE", this.errorOnDuplicateRule$default$3());
    }

    private void checkAlterUser(Cypher6Parser.AlterUserContext ctx) {
        this.errorOnDuplicateRule(ctx.userStatus(), "SET STATUS {SUSPENDED|ACTIVE}", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.homeDatabase(), "SET HOME DATABASE", this.errorOnDuplicateRule$default$3());
    }

    private void checkAllPrivilege(Cypher6Parser.AllPrivilegeContext ctx) {
        Cypher6Parser.AllPrivilegeTypeContext privilegeType = ctx.allPrivilegeType();
        Cypher6Parser.AllPrivilegeTargetContext privilegeTarget = ctx.allPrivilegeTarget();
        if (privilegeType != null) {
            Tuple2 tuple2;
            Some privilege = privilegeType.GRAPH() != null ? new Some((Object)"GRAPH") : (privilegeType.DBMS() != null ? new Some((Object)"DBMS") : (privilegeType.DATABASE() != null ? new Some((Object)"DATABASE") : None$.MODULE$));
            Cypher6Parser.AllPrivilegeTargetContext allPrivilegeTargetContext = privilegeTarget;
            if (allPrivilegeTargetContext instanceof Cypher6Parser.DefaultTargetContext) {
                Some some;
                String string;
                Cypher6Parser.DefaultTargetContext defaultTargetContext = (Cypher6Parser.DefaultTargetContext)allPrivilegeTargetContext;
                Some some2 = privilege;
                tuple2 = some2 instanceof Some && "DBMS".equals(string = (String)(some = some2).value()) ? (defaultTargetContext.HOME() != null ? new Tuple2((Object)"HOME", (Object)defaultTargetContext.HOME().getSymbol()) : new Tuple2((Object)"DEFAULT", (Object)defaultTargetContext.DEFAULT().getSymbol())) : (defaultTargetContext.GRAPH() != null ? new Tuple2((Object)"GRAPH", (Object)defaultTargetContext.GRAPH().getSymbol()) : new Tuple2((Object)"DATABASE", (Object)defaultTargetContext.DATABASE().getSymbol()));
            } else if (allPrivilegeTargetContext instanceof Cypher6Parser.DatabaseVariableTargetContext) {
                Cypher6Parser.DatabaseVariableTargetContext databaseVariableTargetContext = (Cypher6Parser.DatabaseVariableTargetContext)allPrivilegeTargetContext;
                tuple2 = databaseVariableTargetContext.DATABASE() != null ? new Tuple2((Object)"DATABASE", (Object)databaseVariableTargetContext.DATABASE().getSymbol()) : new Tuple2((Object)"DATABASES", (Object)databaseVariableTargetContext.DATABASES().getSymbol());
            } else if (allPrivilegeTargetContext instanceof Cypher6Parser.GraphVariableTargetContext) {
                Cypher6Parser.GraphVariableTargetContext graphVariableTargetContext = (Cypher6Parser.GraphVariableTargetContext)allPrivilegeTargetContext;
                tuple2 = graphVariableTargetContext.GRAPH() != null ? new Tuple2((Object)"GRAPH", (Object)graphVariableTargetContext.GRAPH().getSymbol()) : new Tuple2((Object)"GRAPHS", (Object)graphVariableTargetContext.GRAPHS().getSymbol());
            } else if (allPrivilegeTargetContext instanceof Cypher6Parser.DBMSTargetContext) {
                Cypher6Parser.DBMSTargetContext dBMSTargetContext = (Cypher6Parser.DBMSTargetContext)allPrivilegeTargetContext;
                tuple2 = new Tuple2((Object)"DBMS", (Object)dBMSTargetContext.DBMS().getSymbol());
            } else {
                throw new IllegalStateException("Unexpected privilege all command");
            }
            Tuple2 target = tuple2;
            Tuple2 tuple22 = new Tuple2((Object)privilege, (Object)target);
            if (tuple22 != null) {
                Option option = (Option)tuple22._1();
                Tuple2 tuple23 = (Tuple2)tuple22._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String privilege2 = (String)some.value();
                    if (tuple23 != null) {
                        String target2 = (String)tuple23._1();
                        Token symbol = (Token)tuple23._2();
                        if (!target2.startsWith(privilege2)) {
                            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Invalid input '" + target2 + "': expected \"" + privilege2 + "\"", this.inputPosition(symbol)));
                            return;
                        }
                        return;
                    }
                }
            }
            return;
        }
    }

    private void checkGlobPart(Cypher6Parser.GlobPartContext ctx) {
        if (ctx.DOT() == null) {
            Cypher6Parser.GlobContext globContext;
            Cypher6Parser.GlobRecursiveContext globRecursiveContext;
            RuleContext ruleContext = ctx.parent.parent;
            if (ruleContext instanceof Cypher6Parser.GlobRecursiveContext && (globRecursiveContext = (Cypher6Parser.GlobRecursiveContext)ruleContext).globPart().escapedSymbolicNameString() != null) {
                this.addError$1(ctx);
            } else if (ruleContext instanceof Cypher6Parser.GlobContext && (globContext = (Cypher6Parser.GlobContext)ruleContext).escapedSymbolicNameString() != null) {
                this.addError$1(ctx);
            }
            return;
        }
    }

    private void checkCreateConstraint(Cypher6Parser.CreateConstraintContext ctx) {
        Cypher6Parser.ConstraintTypeContext constraintTypeContext = ctx.constraintType();
        if (constraintTypeContext instanceof Cypher6Parser.ConstraintIsUniqueContext) {
            Cypher6Parser.ConstraintIsUniqueContext constraintIsUniqueContext = (Cypher6Parser.ConstraintIsUniqueContext)constraintTypeContext;
            if (ctx.commandNodePattern() != null && (constraintIsUniqueContext.RELATIONSHIP() != null || constraintIsUniqueContext.REL() != null)) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'" + ConstraintType.REL_UNIQUE.description() + "' does not allow node patterns", this.inputPosition(ctx.commandNodePattern().getStart())));
            }
            if (ctx.commandRelPattern() != null && constraintIsUniqueContext.NODE() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'" + ConstraintType.NODE_UNIQUE.description() + "' does not allow relationship patterns", this.inputPosition(ctx.commandRelPattern().getStart())));
                return;
            }
            return;
        }
        if (constraintTypeContext instanceof Cypher6Parser.ConstraintKeyContext) {
            Cypher6Parser.ConstraintKeyContext constraintKeyContext = (Cypher6Parser.ConstraintKeyContext)constraintTypeContext;
            if (ctx.commandNodePattern() != null && (constraintKeyContext.RELATIONSHIP() != null || constraintKeyContext.REL() != null)) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'" + ConstraintType.REL_KEY.description() + "' does not allow node patterns", this.inputPosition(ctx.commandNodePattern().getStart())));
            }
            if (ctx.commandRelPattern() != null && constraintKeyContext.NODE() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("'" + ConstraintType.NODE_KEY.description() + "' does not allow relationship patterns", this.inputPosition(ctx.commandRelPattern().getStart())));
                return;
            }
            return;
        }
        if (constraintTypeContext instanceof Cypher6Parser.ConstraintTypedContext ? true : constraintTypeContext instanceof Cypher6Parser.ConstraintIsNotNullContext) {
            return;
        }
        this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Constraint type is not recognized", this.inputPosition(ctx.constraintType().getStart())));
    }

    private void checkEnclosedPropertyList(Cypher6Parser.EnclosedPropertyListContext ctx) {
        if (ctx.property().size() > 1 && ctx.getParent() != null) {
            Cypher6Parser.DropConstraintContext dropConstraintContext;
            Token secondProperty = ctx.property((int)1).start;
            ParserRuleContext parserRuleContext = ctx.getParent().getParent();
            if (parserRuleContext instanceof Cypher6Parser.ConstraintTypedContext) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Constraint type 'IS TYPED' does not allow multiple properties", this.inputPosition(secondProperty)));
                return;
            }
            if (parserRuleContext instanceof Cypher6Parser.ConstraintIsNotNullContext) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Constraint type 'IS NOT NULL' does not allow multiple properties", this.inputPosition(secondProperty)));
                return;
            }
            if (parserRuleContext instanceof Cypher6Parser.DropConstraintContext && (dropConstraintContext = (Cypher6Parser.DropConstraintContext)parserRuleContext).EXISTS() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Constraint type 'EXISTS' does not allow multiple properties", this.inputPosition(secondProperty)));
                return;
            }
            return;
        }
    }

    private void checkCreateDatabase(Cypher6Parser.CreateDatabaseContext ctx) {
        this.errorOnDuplicateRule(ctx.primaryTopology(), "PRIMARY", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.secondaryTopology(), "SECONDARY", this.errorOnDuplicateRule$default$3());
    }

    private void checkAlterDatabase(Cypher6Parser.AlterDatabaseContext ctx) {
        if (!ctx.REMOVE().isEmpty()) {
            ArraySeq keyNames = Util$.MODULE$.astSeq(ctx.symbolicNameString(), Util$.MODULE$.astSeq$default$2(), ClassTag$.MODULE$.apply(String.class));
            Set keySet = (Set)Set$.MODULE$.empty();
            IntRef i = IntRef.create((int)0);
            keyNames.foreach((Function1 & Serializable)k -> {
                Cypher6SyntaxChecker.$anonfun$checkAlterDatabase$1(this, keySet, ctx, i, k);
                return BoxedUnit.UNIT;
            });
        }
        if (!ctx.alterDatabaseOption().isEmpty()) {
            ArraySeq optionCtxs = Util$.MODULE$.astSeq(ctx.alterDatabaseOption(), Util$.MODULE$.astSeq$default$2(), ClassTag$.MODULE$.apply(Map.class));
            ArraySeq keyNames = (ArraySeq)optionCtxs.flatMap((Function1 & Serializable)m -> {
                if (m != null) {
                    return m.keys();
                }
                return (Iterable)package$.MODULE$.Seq().empty();
            });
            Set keySet = (Set)Set$.MODULE$.empty();
            IntRef i = IntRef.create((int)0);
            keyNames.foreach((Function1 & Serializable)k -> {
                Cypher6SyntaxChecker.$anonfun$checkAlterDatabase$3(this, keySet, ctx, i, k);
                return BoxedUnit.UNIT;
            });
        }
        this.errorOnDuplicateCtx(ctx.alterDatabaseAccess(), "ACCESS", this.errorOnDuplicateCtx$default$3());
        java.util.List topology = ctx.alterDatabaseTopology();
        this.errorOnDuplicateCtx(topology, "TOPOLOGY", this.errorOnDuplicateCtx$default$3());
    }

    private void checkAlterDatabaseTopology(Cypher6Parser.AlterDatabaseTopologyContext ctx) {
        this.errorOnDuplicateRule(ctx.primaryTopology(), "PRIMARY", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.secondaryTopology(), "SECONDARY", this.errorOnDuplicateRule$default$3());
    }

    private void checkCreateLookupIndex(Cypher6Parser.CreateLookupIndexContext ctx) {
        Cypher6Parser.SymbolicNameStringContext functionName = ctx.symbolicNameString();
        Cypher6Parser.LookupIndexRelPatternContext relPattern = ctx.lookupIndexRelPattern();
        String string = functionName.getText().toUpperCase();
        String string2 = "EACH";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (relPattern != null && relPattern.EACH() == null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Missing function name for the LOOKUP INDEX", this.inputPosition(ctx.LPAREN().getSymbol())));
                return;
            }
        }
    }

    private void checkInsertPattern(Cypher6Parser.InsertPatternContext ctx) {
        if (ctx.EQ() != null) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Named patterns are not allowed in `INSERT`. Use `CREATE` instead or remove the name.", Util$.MODULE$.pos((ParserRuleContext)Util$.MODULE$.ctxChild((AstRuleCtx)ctx, 0))));
            return;
        }
    }

    private void checkInsertLabelConjunction(Cypher6Parser.InsertNodeLabelExpressionContext ctx) {
        boolean firstIsColon;
        java.util.List colons = ctx.COLON();
        boolean bl = firstIsColon = Util$.MODULE$.nodeChild((AstRuleCtx)ctx, 0).getSymbol().getType() == 44;
        if (firstIsColon && colons.size() > 1) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Colon `:` conjunction is not allowed in INSERT. Use `CREATE` or conjunction with ampersand `&` instead.", this.inputPosition(((TerminalNode)colons.get(1)).getSymbol())));
            return;
        }
        if (!firstIsColon && colons.size() > 0) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Colon `:` conjunction is not allowed in INSERT. Use `CREATE` or conjunction with ampersand `&` instead.", this.inputPosition(((TerminalNode)colons.get(0)).getSymbol())));
            return;
        }
    }

    private void checkFunctionInvocation(Cypher6Parser.FunctionInvocationContext ctx) {
        FunctionName functionName = (FunctionName)ctx.functionName().ast();
        String string = functionName.name();
        String string2 = "normalize";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (functionName.namespace().parts().isEmpty() && ctx.functionArgument().size() == 2) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Invalid normal form, expected NFC, NFD, NFKC, NFKD", ((ASTNode)ctx.functionArgument(1).expression().ast()).position()));
                return;
            }
        }
    }

    private void checkTypePart(Cypher6Parser.TypePartContext ctx) {
        Object cypherType = ctx.typeName().ast;
        if (cypherType instanceof ClosedDynamicUnionType && ctx.typeNullability() != null) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Closed Dynamic Union Types can not be appended with `NOT NULL`, specify `NOT NULL` on all inner types instead.", Util$.MODULE$.pos((ParserRuleContext)ctx.typeNullability())));
            return;
        }
    }

    private void checkHint(Cypher6Parser.HintContext ctx) {
        int n = Util$.MODULE$.nodeChild((AstRuleCtx)ctx, 1).getSymbol().getType();
        switch (n) {
            case 36: {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException(ASTExceptionFactory.invalidHintIndexType((HintIndexType)HintIndexType.BTREE), Util$.MODULE$.pos(Util$.MODULE$.nodeChild((AstRuleCtx)ctx, 1))));
                return;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$errorOnAliasNameContainingTooManyComponents$1(Cypher6Parser.SymbolicAliasNameOrParameterContext x$1) {
        return x$1.symbolicAliasName() != null;
    }

    public static final /* synthetic */ int $anonfun$errorOnAliasNameContainingTooManyComponents$3(int x0$1, List x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int count = tuple2._1$mcI$sp();
            List list = (List)tuple2._2();
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                Cypher6Parser.SymbolicNameStringContext a = (Cypher6Parser.SymbolicNameStringContext)colon2.head();
                List list2 = colon2.next$access$1();
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list2;
                    Cypher6Parser.SymbolicNameStringContext b = (Cypher6Parser.SymbolicNameStringContext)colon3.head();
                    List list3 = colon3.next$access$1();
                    if (Nil$.MODULE$.equals(list3) && (a.escapedSymbolicNameString() != null || b.escapedSymbolicNameString() != null)) {
                        return count + 1;
                    }
                }
            }
        }
        if (tuple2 != null) {
            int count = tuple2._1$mcI$sp();
            return count;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$errorOnAliasNameContainingTooManyComponents$2(Cypher6SyntaxChecker $this, int maxComponents$1, String errorTemplate$1, Cypher6Parser.SymbolicAliasNameOrParameterContext aliasName) {
        List nameComponents = CollectionConverters$.MODULE$.ListHasAsScala(aliasName.symbolicAliasName().symbolicNameString()).asScala().toList();
        int componentCount = BoxesRunTime.unboxToInt((Object)nameComponents.sliding(2, 1).foldLeft((Object)BoxesRunTime.boxToInteger((int)1), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)Cypher6SyntaxChecker.$anonfun$errorOnAliasNameContainingTooManyComponents$3(BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
        if (componentCount > maxComponents$1) {
            Token start = ((ParserRuleContext)aliasName.symbolicAliasName().symbolicNameString().get(0)).getStart();
            $this._errors = (Seq)$this._errors.$colon$plus((Object)$this.exceptionFactory.syntaxException(errorTemplate$1.formatted(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(aliasName.symbolicAliasName().symbolicNameString()).asScala().map((Function1 & Serializable)x0$2 -> {
                Cypher6Parser.SymbolicNameStringContext symbolicNameStringContext = x0$2;
                if (symbolicNameStringContext.unescapedSymbolicNameString() != null) {
                    return symbolicNameStringContext.unescapedSymbolicNameString().ast;
                }
                if (symbolicNameStringContext.escapedSymbolicNameString() != null) {
                    return NameUtil.forceEscapeName((String)((String)symbolicNameStringContext.escapedSymbolicNameString().ast()));
                }
                return "";
            })).mkString(".")), $this.inputPosition(start)));
            return;
        }
    }

    private final void addError$1(Cypher6Parser.GlobPartContext ctx$1) {
        this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Each part of the glob (a block of text up until a dot) must either be fully escaped or not escaped at all.", this.inputPosition(ctx$1.start)));
    }

    public static final /* synthetic */ void $anonfun$checkAlterDatabase$1(Cypher6SyntaxChecker $this, Set keySet$1, Cypher6Parser.AlterDatabaseContext ctx$2, IntRef i$1, String k) {
        if (keySet$1.contains((Object)k)) {
            $this._errors = (Seq)$this._errors.$colon$plus((Object)$this.exceptionFactory.syntaxException("Duplicate 'REMOVE OPTION " + k + "' clause", Util$.MODULE$.pos((ParserRuleContext)ctx$2.symbolicNameString(i$1.elem))));
            return;
        }
        keySet$1.addOne((Object)k);
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkAlterDatabase$3(Cypher6SyntaxChecker $this, Set keySet$2, Cypher6Parser.AlterDatabaseContext ctx$2, IntRef i$2, String k) {
        if (keySet$2.contains((Object)k)) {
            $this._errors = (Seq)$this._errors.$colon$plus((Object)$this.exceptionFactory.syntaxException("Duplicate 'SET OPTION " + k + "' clause", Util$.MODULE$.pos((ParserRuleContext)ctx$2.alterDatabaseOption(i$2.elem))));
            return;
        }
        keySet$2.addOne((Object)k);
        ++i$2.elem;
    }

    public Cypher6SyntaxChecker(CypherExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
        this._errors = (Seq)package$.MODULE$.Seq().empty();
    }
}

