/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.activedirectory;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.ldap.AbstractLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveDirectoryRealm
extends AbstractLdapRealm {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveDirectoryRealm.class);
    private static final String ROLE_NAMES_DELIMETER = ",";
    private Map<String, String> groupRolesMap;

    public void setGroupRolesMap(Map<String, String> groupRolesMap) {
        this.groupRolesMap = groupRolesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        LdapContext ctx = null;
        try {
            ctx = ldapContextFactory.getLdapContext(upToken.getUsername(), String.valueOf(upToken.getPassword()));
        }
        catch (Throwable throwable) {
            LdapUtils.closeContext(ctx);
            throw throwable;
        }
        LdapUtils.closeContext(ctx);
        return this.buildAuthenticationInfo(upToken.getUsername(), upToken.getPassword());
    }

    protected AuthenticationInfo buildAuthenticationInfo(String username, char[] password) {
        return new SimpleAuthenticationInfo(username, (Object)password, this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        Set<String> roleNames;
        String username = (String)this.getAvailablePrincipal(principals);
        LdapContext ldapContext = ldapContextFactory.getSystemLdapContext();
        try {
            roleNames = this.getRoleNamesForUser(username, ldapContext);
        }
        finally {
            LdapUtils.closeContext(ldapContext);
        }
        return this.buildAuthorizationInfo(roleNames);
    }

    protected AuthorizationInfo buildAuthorizationInfo(Set<String> roleNames) {
        return new SimpleAuthorizationInfo(roleNames);
    }

    protected Set<String> getRoleNamesForUser(String username, LdapContext ldapContext) throws NamingException {
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        Object userPrincipalName = username;
        if (this.principalSuffix != null && !((String)userPrincipalName).toLowerCase(Locale.ROOT).endsWith(this.principalSuffix.toLowerCase(Locale.ROOT))) {
            userPrincipalName = (String)userPrincipalName + this.principalSuffix;
        }
        Object[] searchArguments = new Object[]{userPrincipalName};
        NamingEnumeration<SearchResult> answer = ldapContext.search(this.searchBase, this.searchFilter, searchArguments, searchControls);
        while (answer.hasMoreElements()) {
            Attributes attrs;
            SearchResult sr = answer.next();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retrieving group names for user [" + sr.getName() + "]");
            }
            if ((attrs = sr.getAttributes()) == null) continue;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMore()) {
                Attribute attr = ae.next();
                if (!attr.getID().equals("memberOf")) continue;
                Collection<String> groupNames = LdapUtils.getAllAttributeValues(attr);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Groups found for user [" + username + "]: " + String.valueOf(groupNames));
                }
                Collection<String> rolesForGroups = this.getRoleNamesForGroups(groupNames);
                roleNames.addAll(rolesForGroups);
            }
        }
        return roleNames;
    }

    protected Collection<String> getRoleNamesForGroups(Collection<String> groupNames) {
        HashSet<String> roleNames = new HashSet<String>(groupNames.size());
        if (this.groupRolesMap != null) {
            for (String groupName : groupNames) {
                String strRoleNames = this.groupRolesMap.get(groupName);
                if (strRoleNames == null) continue;
                for (String roleName : strRoleNames.split(ROLE_NAMES_DELIMETER)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("User is member of group [" + groupName + "] so adding role [" + roleName + "]");
                    }
                    roleNames.add(roleName);
                }
            }
        }
        return roleNames;
    }
}

