/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation;

import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AggregationFunction;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AvgFunction$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingDurations$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingNumbers$;
import org.neo4j.exceptions.InternalException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.ValueMath;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001\u0002\u0011\"\u0001IB\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005y!)Q\t\u0001C\u0001\r\")\u0011\n\u0001C\u0001\u0015\"91\u000b\u0001a\u0001\n\u0013!\u0006bB.\u0001\u0001\u0004%I\u0001\u0018\u0005\u0007E\u0002\u0001\u000b\u0015B+\t\u000f\r\u0004\u0001\u0019!C\u0005I\"9\u0001\u000e\u0001a\u0001\n\u0013I\u0007BB6\u0001A\u0003&Q\rC\u0004m\u0001\u0001\u0007I\u0011\u00023\t\u000f5\u0004\u0001\u0019!C\u0005]\"1\u0001\u000f\u0001Q!\n\u0015Dq!\u001d\u0001A\u0002\u0013%A\rC\u0004s\u0001\u0001\u0007I\u0011B:\t\rU\u0004\u0001\u0015)\u0003f\u0011\u001d1\b\u00011A\u0005\n\u0011Dqa\u001e\u0001A\u0002\u0013%\u0001\u0010\u0003\u0004{\u0001\u0001\u0006K!\u001a\u0005\bw\u0002\u0001\r\u0011\"\u0005e\u0011\u001da\b\u00011A\u0005\u0012uDaa \u0001!B\u0013)\u0007bBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAa!a\u0011\u0001\t\u0003!vaBA#C!\u0005\u0011q\t\u0004\u0007A\u0005B\t!!\u0013\t\r\u0015cB\u0011AA)\u0011!\t\u0019\u0006\bb\u0001\n\u0003!\u0006bBA+9\u0001\u0006I!\u0016\u0002\f\u0003Z<g)\u001e8di&|gN\u0003\u0002#G\u0005Y\u0011mZ4sK\u001e\fG/[8o\u0015\t!S%A\u0003qSB,7O\u0003\u0002'O\u0005Y\u0011N\u001c;feB\u0014X\r^3e\u0015\tA\u0013&A\u0004sk:$\u0018.\\3\u000b\u0005)Z\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u00051j\u0013AB2za\",'O\u0003\u0002/_\u0005)a.Z85U*\t\u0001'A\u0002pe\u001e\u001c\u0001aE\u0002\u0001g]\u0002\"\u0001N\u001b\u000e\u0003\u0005J!AN\u0011\u0003'\u0005;wM]3hCRLwN\u001c$v]\u000e$\u0018n\u001c8\u0011\u0005QB\u0014BA\u001d\"\u0005\u0019rU/\\3sS\u000e|%\u000fR;sCRLwN\\!hOJ,w-\u0019;j_:,\u0005\u0010\u001d:fgNLwN\\\u0001\u0006m\u0006dW/Z\u000b\u0002yA\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002BK\u0005A1m\\7nC:$7/\u0003\u0002D}\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\rY\fG.^3!\u0003\u0019a\u0014N\\5u}Q\u0011q\t\u0013\t\u0003i\u0001AQAO\u0002A\u0002q\nAA\\1nKV\t1\n\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006!A.\u00198h\u0015\u0005\u0001\u0016\u0001\u00026bm\u0006L!AU'\u0003\rM#(/\u001b8h\u0003\u0015\u0019w.\u001e8u+\u0005)\u0006C\u0001,Z\u001b\u00059&\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;&\u0001\u0002'p]\u001e\f\u0011bY8v]R|F%Z9\u0015\u0005u\u0003\u0007C\u0001,_\u0013\tyvK\u0001\u0003V]&$\bbB1\u0007\u0003\u0003\u0005\r!V\u0001\u0004q\u0012\n\u0014AB2pk:$\b%\u0001\tn_:$\bn\u001d*v]:LgnZ!wOV\tQ\r\u0005\u0002WM&\u0011qm\u0016\u0002\u0007\t>,(\r\\3\u0002)5|g\u000e\u001e5t%Vtg.\u001b8h\u0003Z<w\fJ3r)\ti&\u000eC\u0004b\u0013\u0005\u0005\t\u0019A3\u0002#5|g\u000e\u001e5t%Vtg.\u001b8h\u0003Z<\u0007%\u0001\beCf\u001c(+\u001e8oS:<\u0017I^4\u0002%\u0011\f\u0017p\u001d*v]:LgnZ!wO~#S-\u001d\u000b\u0003;>Dq!\u0019\u0007\u0002\u0002\u0003\u0007Q-A\beCf\u001c(+\u001e8oS:<\u0017I^4!\u0003E\u0019XmY8oIN\u0014VO\u001c8j]\u001e\feoZ\u0001\u0016g\u0016\u001cwN\u001c3t%Vtg.\u001b8h\u0003Z<w\fJ3r)\tiF\u000fC\u0004b\u001f\u0005\u0005\t\u0019A3\u0002%M,7m\u001c8egJ+hN\\5oO\u00063x\rI\u0001\u0010]\u0006twn\u001d*v]:LgnZ!wO\u0006\u0019b.\u00198pgJ+hN\\5oO\u00063xm\u0018\u0013fcR\u0011Q,\u001f\u0005\bCJ\t\t\u00111\u0001f\u0003Aq\u0017M\\8t%Vtg.\u001b8h\u0003Z<\u0007%A\u0005bm\u001etU/\u001c2fe\u0006i\u0011M^4Ok6\u0014WM]0%KF$\"!\u0018@\t\u000f\u0005,\u0012\u0011!a\u0001K\u0006Q\u0011M^4Ok6\u0014WM\u001d\u0011\u0002\rI,7/\u001e7u)\u0011\t)!!\u0006\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005A1\u000f^8sC\ndWMC\u0002\u0002\u00105\naA^1mk\u0016\u001c\u0018\u0002BA\n\u0003\u0013\u0011QAV1mk\u0016Dq!a\u0006\u0018\u0001\u0004\tI\"A\u0003ti\u0006$X\r\u0005\u0003\u0002\u001c\u0005uQ\"A\u0012\n\u0007\u0005}1E\u0001\u0006Rk\u0016\u0014\u0018p\u0015;bi\u0016\fQ!\u00199qYf$R!XA\u0013\u0003cAq!a\n\u0019\u0001\u0004\tI#\u0001\u0003eCR\f\u0007\u0003BA\u0016\u0003[i\u0011aJ\u0005\u0004\u0003_9#a\u0003*fC\u0012\f'\r\\3S_^Dq!a\u0006\u0019\u0001\u0004\tI\"\u0001\nbaBd\u0017PV1mk\u0016$\u0015N]3di2LHcA/\u00028!9\u0011\u0011H\rA\u0002\u0005m\u0012A\u0001<m!\u0011\ti$a\u0010\u000e\u0005\u00055\u0011\u0002BA!\u0003\u001b\u0011\u0001\"\u00118z-\u0006dW/Z\u0001\u0013C\u001e<'/Z4bi\u0016$'k\\<D_VtG/A\u0006Bm\u001e4UO\\2uS>t\u0007C\u0001\u001b\u001d'\ra\u00121\n\t\u0004-\u00065\u0013bAA(/\n1\u0011I\\=SK\u001a$\"!a\u0012\u0002\u0019MC\u0015\t\u0014'P/~\u001b\u0016JW#\u0002\u001bMC\u0015\t\u0014'P/~\u001b\u0016JW#!\u0001")
public class AvgFunction
extends AggregationFunction
implements NumericOrDurationAggregationExpression {
    private final Expression value;
    private long count;
    private double monthsRunningAvg;
    private double daysRunningAvg;
    private double secondsRunningAvg;
    private double nanosRunningAvg;
    private double avgNumber;
    private volatile NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers$module;
    private volatile NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations$module;
    private Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType;

    public static long SHALLOW_SIZE() {
        return AvgFunction$.MODULE$.SHALLOW_SIZE();
    }

    @Override
    public void actOnNumberOrDuration(AnyValue vl, Function1<NumberValue, BoxedUnit> aggNumber, Function1<DurationValue, BoxedUnit> aggDuration) {
        NumericOrDurationAggregationExpression.actOnNumberOrDuration$(this, vl, aggNumber, aggDuration);
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers() {
        if (this.AggregatingNumbers$module == null) {
            this.AggregatingNumbers$lzycompute$1();
        }
        return this.AggregatingNumbers$module;
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations() {
        if (this.AggregatingDurations$module == null) {
            this.AggregatingDurations$lzycompute$1();
        }
        return this.AggregatingDurations$module;
    }

    @Override
    public Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType() {
        return this.aggregatingType;
    }

    @Override
    public void aggregatingType_$eq(Option<NumericOrDurationAggregationExpression.AggregatingType> x$1) {
        this.aggregatingType = x$1;
    }

    @Override
    public Expression value() {
        return this.value;
    }

    @Override
    public String name() {
        return "AVG";
    }

    private long count() {
        return this.count;
    }

    private void count_$eq(long x$1) {
        this.count = x$1;
    }

    private double monthsRunningAvg() {
        return this.monthsRunningAvg;
    }

    private void monthsRunningAvg_$eq(double x$1) {
        this.monthsRunningAvg = x$1;
    }

    private double daysRunningAvg() {
        return this.daysRunningAvg;
    }

    private void daysRunningAvg_$eq(double x$1) {
        this.daysRunningAvg = x$1;
    }

    private double secondsRunningAvg() {
        return this.secondsRunningAvg;
    }

    private void secondsRunningAvg_$eq(double x$1) {
        this.secondsRunningAvg = x$1;
    }

    private double nanosRunningAvg() {
        return this.nanosRunningAvg;
    }

    private void nanosRunningAvg_$eq(double x$1) {
        this.nanosRunningAvg = x$1;
    }

    public double avgNumber() {
        return this.avgNumber;
    }

    public void avgNumber_$eq(double x$1) {
        this.avgNumber = x$1;
    }

    public Value result(QueryState state) {
        boolean bl = false;
        Some some = null;
        Option<NumericOrDurationAggregationExpression.AggregatingType> option = this.aggregatingType();
        if (None$.MODULE$.equals(option)) {
            return Values.NO_VALUE;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingNumbers().equals(aggregatingType)) {
                return Values.doubleValue((double)this.avgNumber());
            }
        }
        if (bl) {
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingDurations().equals(aggregatingType)) {
                return DurationValue.approximate((double)this.monthsRunningAvg(), (double)this.daysRunningAvg(), (double)this.secondsRunningAvg(), (double)this.nanosRunningAvg()).normalize();
            }
        }
        throw new InternalException("invalid aggregation type " + this.aggregatingType());
    }

    @Override
    public void apply(ReadableRow data, QueryState state) {
        AnyValue vl = this.value().apply(data, state);
        this.applyValueDirectly(vl);
    }

    public void applyValueDirectly(AnyValue vl) {
        this.actOnNumberOrDuration(vl, (Function1<NumberValue, BoxedUnit>)(Function1 & Serializable)number -> {
            AvgFunction.$anonfun$applyValueDirectly$1(this, number);
            return BoxedUnit.UNIT;
        }, (Function1<DurationValue, BoxedUnit>)(Function1 & Serializable)duration -> {
            AvgFunction.$anonfun$applyValueDirectly$2(this, duration);
            return BoxedUnit.UNIT;
        });
    }

    public long aggregatedRowCount() {
        return this.count();
    }

    private final void AggregatingNumbers$lzycompute$1() {
        AvgFunction avgFunction = this;
        synchronized (avgFunction) {
            if (this.AggregatingNumbers$module == null) {
                this.AggregatingNumbers$module = new NumericOrDurationAggregationExpression$AggregatingNumbers$(this);
            }
        }
    }

    private final void AggregatingDurations$lzycompute$1() {
        AvgFunction avgFunction = this;
        synchronized (avgFunction) {
            if (this.AggregatingDurations$module == null) {
                this.AggregatingDurations$module = new NumericOrDurationAggregationExpression$AggregatingDurations$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$applyValueDirectly$1(AvgFunction $this, NumberValue number) {
        $this.count_$eq($this.count() + 1L);
        $this.avgNumber_$eq(ValueMath.incrementalAverage((double)$this.avgNumber(), (double)number.doubleValue(), (double)$this.count()));
    }

    public static final /* synthetic */ void $anonfun$applyValueDirectly$2(AvgFunction $this, DurationValue duration) {
        $this.count_$eq($this.count() + 1L);
        $this.monthsRunningAvg_$eq($this.monthsRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.MONTHS) - $this.monthsRunningAvg()) / (double)$this.count());
        $this.daysRunningAvg_$eq($this.daysRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.DAYS) - $this.daysRunningAvg()) / (double)$this.count());
        $this.secondsRunningAvg_$eq($this.secondsRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.SECONDS) - $this.secondsRunningAvg()) / (double)$this.count());
        $this.nanosRunningAvg_$eq($this.nanosRunningAvg() + ((double)duration.get((TemporalUnit)ChronoUnit.NANOS) - $this.nanosRunningAvg()) / (double)$this.count());
    }

    public AvgFunction(Expression value) {
        this.value = value;
        NumericOrDurationAggregationExpression.$init$(this);
        this.count = 0L;
        this.monthsRunningAvg = 0.0;
        this.daysRunningAvg = 0.0;
        this.secondsRunningAvg = 0.0;
        this.nanosRunningAvg = 0.0;
        this.avgNumber = 0.0;
    }
}

