/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.lang.util.ByteSource;

public class SimpleHashRequest
implements HashRequest {
    private final ByteSource source;
    private final ByteSource salt;
    private final String algorithmName;
    private final Map<String, Object> parameters = new ConcurrentHashMap<String, Object>();

    public SimpleHashRequest(String algorithmName, ByteSource source, ByteSource salt, Map<String, Object> parameters) {
        this.source = Objects.requireNonNull(source);
        this.salt = salt;
        this.algorithmName = algorithmName;
        this.parameters.putAll(Objects.requireNonNull(parameters));
    }

    @Override
    public ByteSource getSource() {
        return this.source;
    }

    @Override
    public Optional<ByteSource> getSalt() {
        return Optional.ofNullable(this.salt);
    }

    @Override
    public Optional<String> getAlgorithmName() {
        return Optional.ofNullable(this.algorithmName);
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }
}

