/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import java.util.HashSet;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.AuthProviderFailedException;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.FormatException;
import org.neo4j.server.security.SecureHasher;
import org.neo4j.server.security.SystemGraphCredential;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;

public class SecurityGraphHelper {
    public static final String NATIVE_AUTH = "native";
    private final AbstractSecurityLog securityLog;
    private final Suppliers.Lazy<GraphDatabaseService> systemSupplier;
    private final SecureHasher secureHasher;

    public SecurityGraphHelper(Suppliers.Lazy<GraphDatabaseService> systemSupplier, SecureHasher secureHasher, AbstractSecurityLog securityLog) {
        this.systemSupplier = systemSupplier;
        this.secureHasher = secureHasher;
        this.securityLog = securityLog;
    }

    public GraphDatabaseService getSystemDb() {
        return (GraphDatabaseService)this.systemSupplier.get();
    }

    public static Suppliers.Lazy<GraphDatabaseService> makeSystemSupplier(DatabaseContextProvider<?> databaseContextProvider) {
        return Suppliers.lazySingleton(() -> ((DatabaseContext)databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new AuthProviderFailedException("No database called `system` was found."))).databaseFacade());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User getUserByName(String username) {
        this.securityLog.debug(String.format("Looking up user '%s'", username));
        try (Transaction tx = ((GraphDatabaseService)this.systemSupplier.get()).beginTx();){
            Node userNode = tx.findNode(KnownCommunitySecurityComponentVersion.USER_LABEL, "name", (Object)username);
            if (userNode == null) {
                this.securityLog.debug(String.format("User '%s' not found", username));
                User user2 = null;
                return user2;
            }
            User user = this.getUser(userNode);
            return user;
        }
        catch (NotFoundException n) {
            this.securityLog.debug(String.format("User '%s' not found", username));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User getUserById(String uuid) {
        this.securityLog.debug(String.format("Looking up user with id '%s'", uuid));
        if (uuid == null) {
            this.securityLog.debug("Cannot look up user with id = null");
            return null;
        }
        try (Transaction tx = ((GraphDatabaseService)this.systemSupplier.get()).beginTx();){
            Node userNode = tx.findNode(KnownCommunitySecurityComponentVersion.USER_LABEL, "id", (Object)uuid);
            if (userNode == null) {
                this.securityLog.debug(String.format("User with id '%s' not found", uuid));
                User user2 = null;
                return user2;
            }
            User user = this.getUser(userNode);
            return user;
        }
        catch (NotFoundException n) {
            this.securityLog.debug(String.format("User with id '%s' not found", uuid));
            return null;
        }
    }

    private User getUser(Node userNode) {
        String userId = (String)userNode.getProperty("id");
        boolean suspended = (Boolean)userNode.getProperty("suspended");
        String username = (String)userNode.getProperty("name");
        boolean requirePasswordChange = (Boolean)userNode.getProperty("passwordChangeRequired", (Object)false);
        SystemGraphCredential credential = null;
        Object maybeCredentials = userNode.getProperty("credentials", null);
        if (maybeCredentials instanceof String) {
            String rawCredentials = (String)maybeCredentials;
            try {
                credential = SystemGraphCredential.deserialize(rawCredentials, this.secureHasher);
            }
            catch (FormatException e) {
                this.securityLog.debug(String.format("Wrong format of credentials for user %s.", username));
                return null;
            }
        }
        try (ResourceIterable authRels = userNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{KnownCommunitySecurityComponentVersion.HAS_AUTH});){
            HashSet<User.Auth> auths = new HashSet<User.Auth>();
            if (!authRels.iterator().hasNext() && credential != null) {
                auths.add(new User.Auth(NATIVE_AUTH, userId));
            }
            for (Relationship rel : authRels) {
                Node authNode = rel.getEndNode();
                String authProvider = (String)authNode.getProperty("provider");
                String id = (String)authNode.getProperty("id");
                User.Auth auth = new User.Auth(authProvider, id);
                auths.add(auth);
            }
            User user = new User(username, userId, new User.SensitiveCredential((Credential)credential), requirePasswordChange, suspended, auths);
            this.securityLog.debug(String.format("Found user: %s", user));
            User user2 = user;
            return user2;
        }
    }

    public String getAuthId(String provider, String username) {
        this.securityLog.debug(String.format("Looking up '%s' auth for user '%s'", provider, username));
        User user = this.getUserByName(username);
        String id = null;
        if (user != null && (id = (String)user.auth().stream().filter(auth -> auth.provider().equals(provider)).map(User.Auth::id).findFirst().orElse(null)) == null) {
            this.securityLog.debug(String.format("'%s' auth not found for user '%s'", provider, username));
        }
        return id;
    }

    public boolean hasExternalAuth(String username) {
        this.securityLog.debug(String.format("Checking whether user '%s' has an external auth", username));
        User user = this.getUserByName(username);
        if (user == null) {
            return false;
        }
        boolean externalAuth = user.auth().stream().anyMatch(a -> !a.provider().equals(NATIVE_AUTH));
        if (externalAuth) {
            this.securityLog.debug(String.format("External auth found for user '%s'", username));
        } else {
            this.securityLog.debug(String.format("No external auth found for user '%s'", username));
        }
        return externalAuth;
    }
}

