/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph.versions;

import java.util.Optional;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.Log;
import org.neo4j.server.security.SecureHasher;
import org.neo4j.server.security.SystemGraphCredential;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.string.UTF8;

public abstract class SupportedCommunitySecurityComponentVersion
extends KnownCommunitySecurityComponentVersion {
    private final UserRepository userRepository;
    private final SecureHasher secureHasher;

    SupportedCommunitySecurityComponentVersion(ComponentVersion componentVersion, UserRepository userRepository, Log debugLog, AbstractSecurityLog securityLog) {
        super(componentVersion, debugLog, securityLog);
        this.userRepository = userRepository;
        this.secureHasher = new SecureHasher();
    }

    @Override
    public void setupUsers(Transaction tx) throws Exception {
        this.addDefaultUser(tx);
    }

    private void addDefaultUser(Transaction tx) throws Exception {
        Optional<User> initialUser = this.getInitialUser();
        if (initialUser.isPresent()) {
            User user = initialUser.get();
            this.debugLog.info(String.format("Setting up initial user from `auth.ini` file: %s", user.name()));
            this.addUser(tx, "neo4j", user.credential().value(), user.passwordChangeRequired(), user.suspended());
        } else {
            SystemGraphCredential credential = SystemGraphCredential.createCredentialForPassword(UTF8.encode((String)"neo4j"), this.secureHasher);
            this.debugLog.info(String.format("Setting up initial user from defaults: %s", "neo4j"));
            this.addUser(tx, "neo4j", credential, true, false);
        }
    }

    @Override
    public void updateInitialUserPassword(Transaction tx) throws Exception {
        Optional<User> initialUser = this.getInitialUser();
        if (initialUser.isPresent()) {
            this.updateInitialUserPassword(tx, initialUser.get());
        } else {
            this.debugLog.debug("Not updating initial user password: No initial user found in `auth.ini`");
        }
    }

    private Optional<User> getInitialUser() throws Exception {
        this.userRepository.start();
        this.debugLog.debug("Opened `auth.ini` file to find the initial user");
        if (this.userRepository.numberOfUsers() == 0) {
            this.debugLog.debug("Not updating initial user password: No initial user found in `auth.ini`");
        }
        if (this.userRepository.numberOfUsers() == 1) {
            User initialUser = this.userRepository.getUserByName("neo4j");
            if (initialUser == null) {
                String errorMessage = "Invalid `auth.ini` file: the user in the file is not named neo4j";
                this.debugLog.error(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
            this.debugLog.debug("Valid `auth.ini` file: found initial user");
            return Optional.of(initialUser);
        }
        if (this.userRepository.numberOfUsers() > 1) {
            String errorMessage = "Invalid `auth.ini` file: the file contains more than one user";
            this.debugLog.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        return Optional.empty();
    }
}

