/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.backup;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.impl.index.backup.ReadOnlyIndexSnapshotFileIterator;
import org.neo4j.kernel.api.impl.index.backup.UnsupportedIndexDeletionPolicy;
import org.neo4j.kernel.api.impl.index.backup.WritableIndexSnapshotFileIterator;

public final class LuceneIndexSnapshots {
    private LuceneIndexSnapshots() {
    }

    public static ResourceIterator<Path> forIndex(Path indexFolder, IndexWriter indexWriter) throws IOException {
        IndexDeletionPolicy deletionPolicy = indexWriter.getConfig().getIndexDeletionPolicy();
        if (deletionPolicy instanceof SnapshotDeletionPolicy) {
            SnapshotDeletionPolicy policy = (SnapshotDeletionPolicy)deletionPolicy;
            return LuceneIndexSnapshots.hasCommits(indexWriter) ? new WritableIndexSnapshotFileIterator(indexFolder, policy) : Iterators.emptyResourceIterator();
        }
        throw new UnsupportedIndexDeletionPolicy("Can't perform index snapshot with specified index deletion policy: " + deletionPolicy.getClass().getName() + ". Only " + SnapshotDeletionPolicy.class.getName() + " is supported");
    }

    public static ResourceIterator<Path> forIndex(Path indexFolder, Directory directory) throws IOException {
        if (!LuceneIndexSnapshots.hasCommits(directory)) {
            return Iterators.emptyResourceIterator();
        }
        List indexCommits = DirectoryReader.listCommits((Directory)directory);
        IndexCommit indexCommit = (IndexCommit)Iterables.last((Iterable)indexCommits);
        return new ReadOnlyIndexSnapshotFileIterator(indexFolder, indexCommit);
    }

    private static boolean hasCommits(IndexWriter indexWriter) throws IOException {
        Directory directory = indexWriter.getDirectory();
        return LuceneIndexSnapshots.hasCommits(directory);
    }

    private static boolean hasCommits(Directory directory) throws IOException {
        return DirectoryReader.indexExists((Directory)directory) && SegmentInfos.readLatestCommit((Directory)directory) != null;
    }
}

