/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.transaction;

import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.router.impl.transaction.QueryRouterTransactionMonitor;
import org.neo4j.router.impl.transaction.RouterTransactionImpl;
import org.neo4j.router.transaction.RouterTransaction;
import org.neo4j.util.VisibleForTesting;

public class RouterTransactionManager
extends LifecycleAdapter {
    private final Set<RouterTransactionImpl> transactions = ConcurrentHashMap.newKeySet();
    private final QueryRouterTransactionMonitor transactionMonitor;
    private final long awaitActiveTransactionDeadlineMillis;

    public RouterTransactionManager(QueryRouterTransactionMonitor transactionMonitor, Config config) {
        this.transactionMonitor = transactionMonitor;
        this.awaitActiveTransactionDeadlineMillis = ((Duration)config.get(GraphDatabaseSettings.shutdown_transaction_end_timeout)).toMillis();
    }

    public void registerTransaction(RouterTransactionImpl transaction) {
        this.transactions.add(transaction);
        this.transactionMonitor.startMonitoringTransaction(transaction);
    }

    public void unregisterTransaction(RouterTransactionImpl transaction) {
        this.transactions.remove(transaction);
        this.transactionMonitor.stopMonitoringTransaction(transaction);
    }

    public Optional<RouterTransaction> findTransactionContaining(InternalTransaction transaction) {
        return this.transactions.stream().filter(routerTransaction -> routerTransaction.getInternalTransactions().stream().anyMatch(itx -> itx.kernelTransaction() == transaction.kernelTransaction())).map(RouterTransaction.class::cast).findAny();
    }

    @VisibleForTesting
    public Set<RouterTransaction> registeredTransactions() {
        return new HashSet<RouterTransaction>(this.transactions);
    }

    public void stop() {
        this.transactions.forEach(rTx -> rTx.stopRemoteDbsAfterTimeout(this.awaitActiveTransactionDeadlineMillis));
    }
}

