/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.util.Arrays;
import org.apache.arrow.flight.SessionOptionValueVisitor;
import org.apache.arrow.flight.impl.Flight;

public abstract class SessionOptionValue {
    SessionOptionValue() {
    }

    public abstract <T> T acceptVisitor(SessionOptionValueVisitor<T> var1);

    Flight.SessionOptionValue toProtocol() {
        Flight.SessionOptionValue.Builder b = Flight.SessionOptionValue.newBuilder();
        SessionOptionValueToProtocolVisitor visitor = new SessionOptionValueToProtocolVisitor(b);
        this.acceptVisitor(visitor);
        return b.build();
    }

    public boolean isEmpty() {
        return false;
    }

    private class SessionOptionValueToProtocolVisitor
    implements SessionOptionValueVisitor<Void> {
        final Flight.SessionOptionValue.Builder b;

        SessionOptionValueToProtocolVisitor(Flight.SessionOptionValue.Builder b) {
            this.b = b;
        }

        @Override
        public Void visit(String value) {
            this.b.setStringValue(value);
            return null;
        }

        @Override
        public Void visit(boolean value) {
            this.b.setBoolValue(value);
            return null;
        }

        @Override
        public Void visit(long value) {
            this.b.setInt64Value(value);
            return null;
        }

        @Override
        public Void visit(double value) {
            this.b.setDoubleValue(value);
            return null;
        }

        @Override
        public Void visit(String[] value) {
            Flight.SessionOptionValue.StringListValue.Builder pbSLVBuilder = Flight.SessionOptionValue.StringListValue.newBuilder();
            pbSLVBuilder.addAllValues(Arrays.asList(value));
            this.b.setStringListValue(pbSLVBuilder.build());
            return null;
        }

        @Override
        public Void visit(Void ignored) {
            this.b.clearOptionValue();
            return null;
        }
    }
}

