/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth2;

import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallInfo;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightServerMiddleware;
import org.apache.arrow.flight.RequestContext;
import org.apache.arrow.flight.auth2.CallHeaderAuthenticator;

public class ServerCallHeaderAuthMiddleware
implements FlightServerMiddleware {
    private final CallHeaderAuthenticator.AuthResult authResult;

    public ServerCallHeaderAuthMiddleware(CallHeaderAuthenticator.AuthResult authResult) {
        this.authResult = authResult;
    }

    @Override
    public void onBeforeSendingHeaders(CallHeaders outgoingHeaders) {
        this.authResult.appendToOutgoingHeaders(outgoingHeaders);
    }

    @Override
    public void onCallCompleted(CallStatus status) {
    }

    @Override
    public void onCallErrored(Throwable err) {
    }

    public static class Factory
    implements FlightServerMiddleware.Factory<ServerCallHeaderAuthMiddleware> {
        private final CallHeaderAuthenticator authHandler;

        public Factory(CallHeaderAuthenticator authHandler) {
            this.authHandler = authHandler;
        }

        @Override
        public ServerCallHeaderAuthMiddleware onCallStarted(CallInfo callInfo, CallHeaders incomingHeaders, RequestContext context) {
            CallHeaderAuthenticator.AuthResult result = this.authHandler.authenticate(incomingHeaders);
            context.put("arrow-flight-peer-identity", result.getPeerIdentity());
            return new ServerCallHeaderAuthMiddleware(result);
        }
    }
}

