/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.InaccessibleLock;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorLookupSet;
import org.neo4j.internal.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;

public class SchemaCache {
    public static final IntSet[] NO_LOGICAL_KEYS = new IntSet[0];
    private final Lock cacheUpdateLock;
    private volatile SchemaCacheState schemaCacheState;

    public SchemaCache(ConstraintRuleAccessor constraintSemantics, IndexConfigCompleter indexConfigCompleter, StorageEngineIndexingBehaviour indexingBehaviour) {
        this.cacheUpdateLock = new StampedLock().asWriteLock();
        this.schemaCacheState = new SchemaCacheState(constraintSemantics, indexConfigCompleter, Collections.emptyList(), indexingBehaviour);
    }

    private SchemaCache(SchemaCacheState schemaCacheState) {
        this.cacheUpdateLock = new InaccessibleLock("Schema cache snapshots are read-only.");
        this.schemaCacheState = schemaCacheState;
    }

    public Iterable<IndexDescriptor> indexes() {
        return this.schemaCacheState.indexes();
    }

    public Iterable<ConstraintDescriptor> constraints() {
        return this.schemaCacheState.constraints();
    }

    public boolean hasConstraintRule(Long constraintRuleId) {
        return this.schemaCacheState.hasConstraintRule(constraintRuleId);
    }

    public boolean hasConstraintRule(ConstraintDescriptor descriptor) {
        return this.schemaCacheState.hasConstraintRule(descriptor);
    }

    public boolean hasIndex(IndexDescriptor index) {
        return this.schemaCacheState.hasIndex(index);
    }

    public Iterator<ConstraintDescriptor> constraintsForLabel(int label) {
        return Iterators.filter((Predicate)SchemaDescriptorPredicates.hasLabel((int)label), this.constraints().iterator());
    }

    public Iterator<ConstraintDescriptor> constraintsForRelationshipType(int relTypeId) {
        return Iterators.filter((Predicate)SchemaDescriptorPredicates.hasRelType((int)relTypeId), this.constraints().iterator());
    }

    public Iterator<ConstraintDescriptor> constraintsForSchema(SchemaDescriptor descriptor) {
        return Iterators.filter((Predicate)SchemaDescriptors.equalTo((SchemaDescriptor)descriptor), this.constraints().iterator());
    }

    public <P, T> T getOrCreateDependantState(Class<T> type, Function<P, T> factory, P parameter) {
        return this.schemaCacheState.getOrCreateDependantState(type, factory, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Iterable<SchemaRule> rules) {
        this.cacheUpdateLock.lock();
        try {
            ConstraintRuleAccessor constraintSemantics = this.schemaCacheState.constraintSemantics;
            IndexConfigCompleter indexConfigCompleter = this.schemaCacheState.indexConfigCompleter;
            StorageEngineIndexingBehaviour behaviour = this.schemaCacheState.indexingBehaviour;
            this.schemaCacheState = new SchemaCacheState(constraintSemantics, indexConfigCompleter, rules, behaviour);
        }
        finally {
            this.cacheUpdateLock.unlock();
        }
    }

    public void addSchemaRule(SchemaRule rule) {
        this.cacheUpdateLock.lock();
        try {
            SchemaCacheState updatedSchemaState = new SchemaCacheState(this.schemaCacheState);
            updatedSchemaState.addSchemaRule(rule);
            this.schemaCacheState = updatedSchemaState;
        }
        finally {
            this.cacheUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaRule(long id) {
        this.cacheUpdateLock.lock();
        try {
            SchemaCacheState updatedSchemaState = new SchemaCacheState(this.schemaCacheState);
            updatedSchemaState.removeSchemaRule(id);
            this.schemaCacheState = updatedSchemaState;
        }
        finally {
            this.cacheUpdateLock.unlock();
        }
    }

    public IndexDescriptor getIndex(long id) {
        return this.schemaCacheState.getIndex(id);
    }

    public Iterator<IndexDescriptor> indexesForSchema(SchemaDescriptor descriptor) {
        return this.schemaCacheState.indexesForSchema(descriptor);
    }

    public IndexDescriptor indexForSchemaAndType(SchemaDescriptor descriptor, IndexType type) {
        return this.schemaCacheState.indexForSchemaAndType(descriptor, type);
    }

    public Iterator<IndexDescriptor> indexesForLabel(int labelId) {
        return this.schemaCacheState.indexesForLabel(labelId);
    }

    public Iterator<IndexDescriptor> indexesForRelationshipType(int relationshipType) {
        return this.schemaCacheState.indexesForRelationshipType(relationshipType);
    }

    public IndexDescriptor indexForName(String name) {
        return this.schemaCacheState.indexForName(name);
    }

    public ConstraintDescriptor constraintForName(String name) {
        return this.schemaCacheState.constraintForName(name);
    }

    public Set<IndexDescriptor> getValueIndexesRelatedTo(int[] changedEntityTokens, int[] unchangedEntityTokens, int[] properties, boolean propertyListIsComplete, EntityType entityType) {
        return this.schemaCacheState.getIndexesRelatedTo(entityType, changedEntityTokens, unchangedEntityTokens, properties, propertyListIsComplete);
    }

    public Collection<IndexBackedConstraintDescriptor> getUniquenessConstraintsRelatedTo(int[] changedLabels, int[] unchangedLabels, int[] properties, boolean propertyListIsComplete, EntityType entityType) {
        return this.schemaCacheState.getUniquenessConstraintsRelatedTo(entityType, changedLabels, unchangedLabels, properties, propertyListIsComplete);
    }

    public boolean hasRelatedSchema(int[] tokens, int propertyKey, EntityType entityType) {
        return this.schemaCacheState.hasRelatedSchema(tokens, propertyKey, entityType);
    }

    public boolean hasRelatedSchema(int token, EntityType entityType) {
        return this.schemaCacheState.hasRelatedSchema(token, entityType);
    }

    public IntSet[] constraintsGetPropertyTokensForLogicalKey(int token, EntityType entityType) {
        return this.schemaCacheState.constraintsGetPropertyTokensForLogicalKey(token, entityType);
    }

    public SchemaCache snapshot() {
        return new SchemaCache(this.schemaCacheState);
    }

    private static Set<IndexDescriptor> removeFromImmutable(Set<IndexDescriptor> set, IndexDescriptor toRemove) {
        MutableSet result = Sets.mutable.withAll(set).without((Object)toRemove);
        return !result.isEmpty() ? result.asUnmodifiable() : null;
    }

    private static class SchemaCacheState {
        private final ConstraintRuleAccessor constraintSemantics;
        private final IndexConfigCompleter indexConfigCompleter;
        private final MutableLongObjectMap<IndexDescriptor> indexesById;
        private final MutableLongObjectMap<ConstraintDescriptor> constraintsById;
        private final Set<ConstraintDescriptor> constraints;
        private final StorageEngineIndexingBehaviour indexingBehaviour;
        private final Map<SchemaDescriptor, Set<IndexDescriptor>> indexesBySchema;
        private final Map<TypeDescriptorKey, IndexDescriptor> indexesBySchemaAndType;
        private final SchemaDescriptorLookupSet<IndexDescriptor> indexesByNode;
        private final SchemaDescriptorLookupSet<IndexDescriptor> indexesByRelationship;
        private final SchemaDescriptorLookupSet<IndexBackedConstraintDescriptor> uniquenessConstraintsByNode;
        private final SchemaDescriptorLookupSet<IndexBackedConstraintDescriptor> uniquenessConstraintsByRelationship;
        private final Map<String, IndexDescriptor> indexesByName;
        private final Map<String, ConstraintDescriptor> constrainsByName;
        private final Map<Class<?>, Object> dependantState;
        private final ConcurrentMap<Object, Set<IndexDescriptor>> indexCache;
        private final ConcurrentMap<Object, Set<IndexBackedConstraintDescriptor>> constraintCache;
        private final Map<LogicalEntityKey, LogicalKeyState> logicalKeyConstraints;

        SchemaCacheState(ConstraintRuleAccessor constraintSemantics, IndexConfigCompleter indexConfigCompleter, Iterable<SchemaRule> rules, StorageEngineIndexingBehaviour storageEngineIndexingBehaviour) {
            this.constraintSemantics = constraintSemantics;
            this.indexConfigCompleter = indexConfigCompleter;
            this.indexingBehaviour = storageEngineIndexingBehaviour;
            this.indexesById = new LongObjectHashMap();
            this.constraintsById = new LongObjectHashMap();
            this.constraints = new HashSet<ConstraintDescriptor>();
            this.indexesBySchema = new HashMap<SchemaDescriptor, Set<IndexDescriptor>>();
            this.indexesBySchemaAndType = new HashMap<TypeDescriptorKey, IndexDescriptor>();
            this.indexesByNode = new SchemaDescriptorLookupSet();
            this.indexesByRelationship = new SchemaDescriptorLookupSet();
            this.uniquenessConstraintsByNode = new SchemaDescriptorLookupSet();
            this.uniquenessConstraintsByRelationship = new SchemaDescriptorLookupSet();
            this.indexesByName = new HashMap<String, IndexDescriptor>();
            this.constrainsByName = new HashMap<String, ConstraintDescriptor>();
            this.logicalKeyConstraints = new HashMap<LogicalEntityKey, LogicalKeyState>();
            this.dependantState = new ConcurrentHashMap();
            this.indexCache = new ConcurrentHashMap<Object, Set<IndexDescriptor>>();
            this.constraintCache = new ConcurrentHashMap<Object, Set<IndexBackedConstraintDescriptor>>();
            this.load(rules);
        }

        SchemaCacheState(SchemaCacheState schemaCacheState) {
            this.constraintSemantics = schemaCacheState.constraintSemantics;
            this.indexConfigCompleter = schemaCacheState.indexConfigCompleter;
            this.indexesById = LongObjectHashMap.newMap(schemaCacheState.indexesById);
            this.indexingBehaviour = schemaCacheState.indexingBehaviour;
            this.constraintsById = LongObjectHashMap.newMap(schemaCacheState.constraintsById);
            this.constraints = new HashSet<ConstraintDescriptor>(schemaCacheState.constraints);
            this.indexesBySchema = new HashMap<SchemaDescriptor, Set<IndexDescriptor>>(schemaCacheState.indexesBySchema);
            this.indexesBySchemaAndType = new HashMap<TypeDescriptorKey, IndexDescriptor>(schemaCacheState.indexesBySchemaAndType);
            this.indexesByNode = new SchemaDescriptorLookupSet();
            this.indexesByRelationship = new SchemaDescriptorLookupSet();
            this.uniquenessConstraintsByNode = new SchemaDescriptorLookupSet();
            this.uniquenessConstraintsByRelationship = new SchemaDescriptorLookupSet();
            this.indexesById.forEachValue((Procedure & Serializable)index -> this.selectIndexSetByEntityType(index.schema().entityType()).add((SchemaDescriptorSupplier)index));
            this.constraintsById.forEachValue(this::cacheUniquenessConstraint);
            this.indexesByName = new HashMap<String, IndexDescriptor>(schemaCacheState.indexesByName);
            this.constrainsByName = new HashMap<String, ConstraintDescriptor>(schemaCacheState.constrainsByName);
            this.logicalKeyConstraints = new HashMap<LogicalEntityKey, LogicalKeyState>(schemaCacheState.logicalKeyConstraints);
            this.dependantState = new ConcurrentHashMap();
            this.indexCache = new ConcurrentHashMap<Object, Set<IndexDescriptor>>();
            this.constraintCache = new ConcurrentHashMap<Object, Set<IndexBackedConstraintDescriptor>>();
        }

        private void cacheUniquenessConstraint(ConstraintDescriptor constraint) {
            if (constraint.enforcesUniqueness()) {
                this.selectUniquenessConstraintSetByEntityType(constraint.schema().entityType()).add((SchemaDescriptorSupplier)constraint.asIndexBackedConstraint());
            }
        }

        private void cacheConstraint(ConstraintDescriptor constraint) {
            this.cacheUniquenessConstraint(constraint);
            this.logicalKeyConstraints.compute(LogicalEntityKey.create(constraint.schema()), (key, state) -> state == null ? new LogicalKeyState(constraint) : state.addConstraint(constraint));
        }

        private void load(Iterable<SchemaRule> schemaRuleIterator) {
            for (SchemaRule schemaRule : schemaRuleIterator) {
                this.addSchemaRule(schemaRule);
            }
        }

        Iterable<IndexDescriptor> indexes() {
            return this.indexesById.values();
        }

        boolean hasConstraintRule(Long constraintRuleId) {
            return constraintRuleId != null && this.constraintsById.containsKey(constraintRuleId.longValue());
        }

        boolean hasConstraintRule(ConstraintDescriptor descriptor) {
            return this.constraints.contains(descriptor);
        }

        boolean hasIndex(IndexDescriptor index) {
            return this.indexesById.containsKey(index.getId());
        }

        Iterable<ConstraintDescriptor> constraints() {
            return this.constraints;
        }

        IndexDescriptor getIndex(long id) {
            return (IndexDescriptor)this.indexesById.get(id);
        }

        Iterator<IndexDescriptor> indexesForSchema(SchemaDescriptor descriptor) {
            Set<IndexDescriptor> indexes = this.indexesBySchema.get(descriptor);
            return indexes == null ? Iterators.emptyResourceIterator() : indexes.iterator();
        }

        IndexDescriptor indexForSchemaAndType(SchemaDescriptor descriptor, IndexType type) {
            return this.indexesBySchemaAndType.get(new TypeDescriptorKey(type, descriptor));
        }

        IndexDescriptor indexForName(String name) {
            return this.indexesByName.get(name);
        }

        ConstraintDescriptor constraintForName(String name) {
            return this.constrainsByName.get(name);
        }

        Iterator<IndexDescriptor> indexesForLabel(int labelId) {
            if (this.indexesByNode.isEmpty()) {
                return Collections.emptyIterator();
            }
            IndexesForLabelKey key = new IndexesForLabelKey(labelId);
            Set result = (Set)this.indexCache.get(key);
            if (result != null) {
                return result.iterator();
            }
            return this.indexCache.computeIfAbsent(key, k -> SchemaCacheState.getSchemaRelatedTo(this.indexesByNode, new int[]{labelId}, ArrayUtils.EMPTY_INT_ARRAY, ArrayUtils.EMPTY_INT_ARRAY, false)).iterator();
        }

        Iterator<IndexDescriptor> indexesForRelationshipType(int relationshipType) {
            if (this.indexesByRelationship.isEmpty()) {
                return Collections.emptyIterator();
            }
            IndexesForRelationshipTypeKey key = new IndexesForRelationshipTypeKey(relationshipType);
            Set result = (Set)this.indexCache.get(key);
            if (result != null) {
                return result.iterator();
            }
            return this.indexCache.computeIfAbsent(key, k -> SchemaCacheState.getSchemaRelatedTo(this.indexesByRelationship, new int[]{relationshipType}, ArrayUtils.EMPTY_INT_ARRAY, ArrayUtils.EMPTY_INT_ARRAY, false)).iterator();
        }

        Set<IndexDescriptor> getIndexesRelatedTo(EntityType entityType, int[] changedEntityTokens, int[] unchangedEntityTokens, int[] properties, boolean propertyListIsComplete) {
            SchemaDescriptorLookupSet<IndexDescriptor> set = this.selectIndexSetByEntityType(entityType);
            if (set.isEmpty()) {
                return Collections.emptySet();
            }
            IndexesRelatedToKey key = new IndexesRelatedToKey(entityType, changedEntityTokens, unchangedEntityTokens, properties, propertyListIsComplete);
            Set result = (Set)this.indexCache.get(key);
            if (result != null) {
                return result;
            }
            return this.indexCache.computeIfAbsent(key, k -> SchemaCacheState.getSchemaRelatedTo(set, changedEntityTokens, unchangedEntityTokens, properties, propertyListIsComplete));
        }

        Set<IndexBackedConstraintDescriptor> getUniquenessConstraintsRelatedTo(EntityType entityType, int[] changedEntityTokens, int[] unchangedEntityTokens, int[] properties, boolean propertyListIsComplete) {
            SchemaDescriptorLookupSet<IndexBackedConstraintDescriptor> set = this.selectUniquenessConstraintSetByEntityType(entityType);
            if (set.isEmpty()) {
                return Collections.emptySet();
            }
            UniqueIndexesRelatedToKey key = new UniqueIndexesRelatedToKey(entityType, changedEntityTokens, unchangedEntityTokens, properties, propertyListIsComplete);
            Set result = (Set)this.constraintCache.get(key);
            if (result != null) {
                return result;
            }
            return this.constraintCache.computeIfAbsent(key, k -> SchemaCacheState.getSchemaRelatedTo(set, changedEntityTokens, unchangedEntityTokens, properties, propertyListIsComplete));
        }

        private static <T extends SchemaDescriptorSupplier> Set<T> getSchemaRelatedTo(SchemaDescriptorLookupSet<T> set, int[] changedEntityTokens, int[] unchangedEntityTokens, int[] properties, boolean propertyListIsComplete) {
            UnifiedSet descriptors = UnifiedSet.newSet();
            if (propertyListIsComplete) {
                set.matchingDescriptorsForCompleteListOfProperties((Collection)descriptors, changedEntityTokens, properties);
            } else if (properties.length == 0) {
                set.matchingDescriptors((Collection)descriptors, changedEntityTokens);
            } else if (changedEntityTokens.length == 0) {
                set.matchingDescriptorsForPartialListOfProperties((Collection)descriptors, unchangedEntityTokens, properties);
            } else {
                set.matchingDescriptors((Collection)descriptors, changedEntityTokens);
                set.matchingDescriptorsForPartialListOfProperties((Collection)descriptors, unchangedEntityTokens, properties);
            }
            return descriptors;
        }

        boolean hasRelatedSchema(int[] tokens, int propertyKey, EntityType entityType) {
            return this.selectIndexSetByEntityType(entityType).has(tokens, propertyKey) || this.selectUniquenessConstraintSetByEntityType(entityType).has(tokens, propertyKey);
        }

        boolean hasRelatedSchema(int token, EntityType entityType) {
            return this.selectIndexSetByEntityType(entityType).has(token) || this.selectUniquenessConstraintSetByEntityType(entityType).has(token);
        }

        private SchemaDescriptorLookupSet<IndexDescriptor> selectIndexSetByEntityType(EntityType entityType) {
            return switch (entityType) {
                default -> throw new IncompatibleClassChangeError();
                case EntityType.NODE -> this.indexesByNode;
                case EntityType.RELATIONSHIP -> this.indexesByRelationship;
            };
        }

        private SchemaDescriptorLookupSet<IndexBackedConstraintDescriptor> selectUniquenessConstraintSetByEntityType(EntityType entityType) {
            return switch (entityType) {
                default -> throw new IncompatibleClassChangeError();
                case EntityType.NODE -> this.uniquenessConstraintsByNode;
                case EntityType.RELATIONSHIP -> this.uniquenessConstraintsByRelationship;
            };
        }

        <P, T> T getOrCreateDependantState(Class<T> type, Function<P, T> factory, P parameter) {
            return type.cast(this.dependantState.computeIfAbsent(type, key -> factory.apply(parameter)));
        }

        void addSchemaRule(SchemaRule rule) {
            if (rule instanceof ConstraintDescriptor) {
                ConstraintDescriptor constraint = (ConstraintDescriptor)rule;
                constraint = this.constraintSemantics.readConstraint(constraint);
                this.constraintsById.put(constraint.getId(), (Object)constraint);
                this.constrainsByName.put(constraint.getName(), constraint);
                this.constraints.add(constraint);
                this.cacheConstraint(constraint);
            } else if (rule instanceof IndexDescriptor) {
                IndexDescriptor index = (IndexDescriptor)rule;
                index = this.indexConfigCompleter.completeConfiguration(index, this.indexingBehaviour);
                this.indexesById.put(index.getId(), (Object)index);
                SchemaDescriptor schema = index.schema();
                this.indexesBySchema.merge(schema, Set.of(index), SchemaCacheState::concatImmutableSets);
                this.indexesBySchemaAndType.put(new TypeDescriptorKey(index.getIndexType(), schema), index);
                this.indexesByName.put(rule.getName(), index);
                this.selectIndexSetByEntityType(schema.entityType()).add((SchemaDescriptorSupplier)index);
            }
        }

        private static Set<IndexDescriptor> concatImmutableSets(Set<IndexDescriptor> left, Set<IndexDescriptor> right) {
            return Sets.union(left, right).asUnmodifiable();
        }

        void removeSchemaRule(long id) {
            if (this.constraintsById.containsKey(id)) {
                ConstraintDescriptor constraint = (ConstraintDescriptor)this.constraintsById.remove(id);
                this.constrainsByName.remove(constraint.getName());
                this.constraints.remove(constraint);
                if (constraint.enforcesUniqueness()) {
                    this.selectUniquenessConstraintSetByEntityType(constraint.schema().entityType()).remove((SchemaDescriptorSupplier)constraint.asIndexBackedConstraint());
                }
                this.logicalKeyConstraints.computeIfPresent(LogicalEntityKey.create(constraint.schema()), (key, state) -> state.removeConstraint(constraint));
            } else if (this.indexesById.containsKey(id)) {
                IndexDescriptor index = (IndexDescriptor)this.indexesById.remove(id);
                SchemaDescriptor schema = index.schema();
                this.indexesBySchema.computeIfPresent(schema, (key, value) -> SchemaCache.removeFromImmutable(value, index));
                this.indexesBySchemaAndType.remove(new TypeDescriptorKey(index.getIndexType(), schema));
                this.indexesByName.remove(index.getName(), index);
                this.selectIndexSetByEntityType(schema.entityType()).remove((SchemaDescriptorSupplier)index);
            }
        }

        IntSet[] constraintsGetPropertyTokensForLogicalKey(int token, EntityType entityType) {
            LogicalKeyState state = this.logicalKeyConstraints.get(new LogicalEntityKey(entityType, token));
            return state == null ? NO_LOGICAL_KEYS : state.propertyIds();
        }
    }

    private static class TypeDescriptorKey {
        private final int hash;
        private final IndexType type;
        private final SchemaDescriptor descriptor;

        private TypeDescriptorKey(IndexType type, SchemaDescriptor descriptor) {
            this.type = type;
            this.descriptor = descriptor;
            this.hash = TypeDescriptorKey.hash(type, descriptor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeDescriptorKey that = (TypeDescriptorKey)o;
            return this.type == that.type && Objects.equals(this.descriptor, that.descriptor);
        }

        public int hashCode() {
            return this.hash;
        }

        private static int hash(IndexType type, SchemaDescriptor descriptor) {
            return Objects.hash(type, descriptor);
        }
    }

    private static class UniqueIndexesRelatedToKey
    extends IndexesRelatedToKey {
        private static final int PRIME = UniqueIndexesRelatedToKey.nextPrime();

        UniqueIndexesRelatedToKey(EntityType entityType, int[] changedEntityTokens, int[] unchangedEntityTokens, int[] properties, boolean propertyListIsComplete) {
            super(UniqueIndexesRelatedToKey.hash(entityType, changedEntityTokens, unchangedEntityTokens, properties, propertyListIsComplete) * PRIME, entityType, changedEntityTokens, unchangedEntityTokens, properties, propertyListIsComplete);
        }
    }

    private static class IndexesRelatedToKey
    extends QueryCacheKey {
        private static final int PRIME = IndexesRelatedToKey.nextPrime();
        private final EntityType entityType;
        private final int[] changedEntityTokens;
        private final int[] unchangedEntityTokens;
        private final int[] properties;
        private final boolean propertyListIsComplete;

        IndexesRelatedToKey(EntityType entityType, int[] changedEntityTokens, int[] unchangedEntityTokens, int[] properties, boolean propertyListIsComplete) {
            this(IndexesRelatedToKey.hash(entityType, changedEntityTokens, unchangedEntityTokens, properties, propertyListIsComplete) * PRIME, entityType, changedEntityTokens, unchangedEntityTokens, properties, propertyListIsComplete);
        }

        IndexesRelatedToKey(int hash, EntityType entityType, int[] changedEntityTokens, int[] unchangedEntityTokens, int[] properties, boolean propertyListIsComplete) {
            super(hash);
            this.entityType = entityType;
            this.changedEntityTokens = changedEntityTokens;
            this.unchangedEntityTokens = unchangedEntityTokens;
            this.properties = properties;
            this.propertyListIsComplete = propertyListIsComplete;
        }

        static int hash(EntityType entityType, int[] changedEntityTokens, int[] unchangedEntityTokens, int[] properties, boolean propertyListIsComplete) {
            int result = 1;
            result = 31 * result + entityType.hashCode();
            result = 31 * result + Arrays.hashCode(changedEntityTokens);
            result = 31 * result + Arrays.hashCode(unchangedEntityTokens);
            result = 31 * result + Arrays.hashCode(properties);
            result = 31 * result + (propertyListIsComplete ? 1 : 0);
            return result;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexesRelatedToKey that = (IndexesRelatedToKey)o;
            if (this.propertyListIsComplete != that.propertyListIsComplete) {
                return false;
            }
            if (this.entityType != that.entityType) {
                return false;
            }
            if (!Arrays.equals(this.changedEntityTokens, that.changedEntityTokens)) {
                return false;
            }
            if (!Arrays.equals(this.unchangedEntityTokens, that.unchangedEntityTokens)) {
                return false;
            }
            return Arrays.equals(this.properties, that.properties);
        }
    }

    private static class IndexesForRelationshipTypeKey
    extends QueryCacheKey {
        private static final int PRIME = IndexesForRelationshipTypeKey.nextPrime();
        private final int relationshipType;

        IndexesForRelationshipTypeKey(int relationshipType) {
            super(IndexesForRelationshipTypeKey.hash(relationshipType) * PRIME);
            this.relationshipType = relationshipType;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexesForRelationshipTypeKey that = (IndexesForRelationshipTypeKey)o;
            return this.relationshipType == that.relationshipType;
        }
    }

    private static class IndexesForLabelKey
    extends QueryCacheKey {
        private static final int PRIME = IndexesForLabelKey.nextPrime();
        private final int label;

        private IndexesForLabelKey(int label) {
            super(IndexesForLabelKey.hash(label) * PRIME);
            this.label = label;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexesForLabelKey that = (IndexesForLabelKey)o;
            return this.label == that.label;
        }
    }

    private static abstract class QueryCacheKey {
        private static BigInteger PRIMES = new BigInteger("13");
        private final int hash;

        static synchronized int nextPrime() {
            int result = PRIMES.intValue();
            PRIMES = PRIMES.nextProbablePrime();
            return result;
        }

        QueryCacheKey(int hash) {
            this.hash = hash;
        }

        static int hash(int value) {
            return Integer.hashCode(value);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException("Equals needs to be overwritten by sub-classes.");
        }
    }

    private static class LogicalKeyState {
        private final Set<ConstraintDescriptor> constraints = Sets.mutable.empty();
        private IntSet[] logicalKeyProperties;

        public LogicalKeyState(ConstraintDescriptor descriptor) {
            this.addConstraint(descriptor);
        }

        IntSet[] propertyIds() {
            return this.logicalKeyProperties;
        }

        LogicalKeyState addConstraint(ConstraintDescriptor descriptor) {
            if (this.constraints.add(descriptor)) {
                this.rebuild();
            }
            return this;
        }

        LogicalKeyState removeConstraint(ConstraintDescriptor descriptor) {
            if (this.constraints.remove(descriptor)) {
                this.rebuild();
            }
            return this;
        }

        private void rebuild() {
            this.logicalKeyProperties = null;
            MutableList logicalProps = Lists.mutable.empty();
            MutableMap logicalMatches = Maps.mutable.empty();
            this.constraints.stream().sorted(Comparator.comparing(descriptor -> LogicalKeyState.order(descriptor.type()))).forEach(descriptor -> {
                int[] constraintProperties = descriptor.schema().getPropertyIds();
                switch (descriptor.type()) {
                    case UNIQUE_EXISTS: {
                        logicalProps.add((Object)IntSets.mutable.of(constraintProperties));
                        break;
                    }
                    case UNIQUE: {
                        logicalMatches.computeIfAbsent((Object)constraintProperties, keyProperties -> IntSets.mutable.empty());
                        break;
                    }
                    case EXISTS: {
                        logicalMatches.forEachKeyValue((Procedure2 & Serializable)(keyProperties, matched) -> {
                            if (matched.size() < ((int[])keyProperties).length) {
                                for (int keyProperty : keyProperties) {
                                    for (int constraintProperty : constraintProperties) {
                                        if (constraintProperty != keyProperty) continue;
                                        matched.add(constraintProperty);
                                    }
                                }
                                if (matched.size() == ((int[])keyProperties).length) {
                                    logicalProps.add(matched);
                                }
                            }
                        });
                        break;
                    }
                }
            });
            this.logicalKeyProperties = (IntSet[])logicalProps.sortThis((props1, props2) -> {
                int c = -Integer.compare(props1.size(), props2.size());
                if (c == 0) {
                    int[] sorted1 = props1.toSortedArray();
                    int[] sorted2 = props2.toSortedArray();
                    for (int i = 0; i < sorted1.length && (c = Integer.compare(sorted1[i], sorted2[i])) == 0; ++i) {
                    }
                }
                return c;
            }).toArray(IntSet[]::new);
        }

        private static int order(ConstraintType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case ConstraintType.UNIQUE_EXISTS -> 0;
                case ConstraintType.UNIQUE -> 1;
                case ConstraintType.EXISTS -> 2;
                case ConstraintType.PROPERTY_TYPE -> 3;
                case ConstraintType.ENDPOINT -> 4;
            };
        }
    }

    private record LogicalEntityKey(EntityType type, int tokenId) {
        private static LogicalEntityKey create(SchemaDescriptor schema) {
            EntityType entityType = schema.entityType();
            if (entityType == EntityType.NODE) {
                return new LogicalEntityKey(entityType, schema.getLabelId());
            }
            return new LogicalEntityKey(entityType, schema.getRelTypeId());
        }
    }
}

