/*
 * Decompiled with CFR 0.152.
 */
package apoc.convert;

import apoc.convert.ConvertConfig;
import apoc.convert.ConvertUtils;
import apoc.meta.Types;
import apoc.result.MapResult;
import apoc.util.JsonUtil;
import apoc.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Json {
    public static String NODE = "node";
    public static String RELATIONSHIP = "relationship";

    public static Object writeJsonResult(Object value) {
        Types type = Types.of(value);
        switch (type) {
            case NODE: {
                return Json.nodeToMap((Node)value);
            }
            case RELATIONSHIP: {
                return Json.relToMap((Relationship)value);
            }
            case PATH: {
                return Json.writeJsonResult(StreamSupport.stream(((Path)value).spliterator(), false).map(i -> i instanceof Node ? Json.nodeToMap((Node)i) : Json.relToMap((Relationship)i)).collect(Collectors.toList()));
            }
            case LIST: {
                return ConvertUtils.convertToList(value).stream().map(Json::writeJsonResult).collect(Collectors.toList());
            }
            case MAP: {
                return ((Map)value).entrySet().stream().collect(HashMap::new, (mapAccumulator, entry) -> mapAccumulator.put(entry.getKey(), Json.writeJsonResult(entry.getValue())), HashMap::putAll);
            }
        }
        return value;
    }

    private static Map<String, Object> relToMap(Relationship rel) {
        Map<String, Object> mapRel = Util.map("id", String.valueOf(rel.getId()), "type", RELATIONSHIP, "label", rel.getType().toString(), "start", Json.nodeToMap(rel.getStartNode()), "end", Json.nodeToMap(rel.getEndNode()));
        return Json.mapWithOptionalProps(mapRel, rel.getAllProperties());
    }

    private static Map<String, Object> nodeToMap(Node node) {
        Map<String, Object> mapNode = Util.map("id", String.valueOf(node.getId()));
        mapNode.put("type", NODE);
        if (node.getLabels().iterator().hasNext()) {
            mapNode.put("labels", Util.labelStrings(node));
        }
        return Json.mapWithOptionalProps(mapNode, node.getAllProperties());
    }

    private static Map<String, Object> mapWithOptionalProps(Map<String, Object> mapEntity, Map<String, Object> props) {
        if (!props.isEmpty()) {
            mapEntity.put("properties", props);
        }
        return mapEntity;
    }

    @UserFunction(value="apoc.json.path")
    @Description(value="Returns the given JSON path.")
    public Object path(@Name(value="json") String json, @Name(value="path", defaultValue="$") String path, @Name(value="pathOptions", defaultValue="null") List<String> pathOptions) {
        return JsonUtil.parse(json, path, Object.class, pathOptions);
    }

    @UserFunction(value="apoc.convert.toJson")
    @Description(value="Serializes the given JSON value.")
    public String toJson(@Name(value="value") Object value) {
        try {
            return JsonUtil.OBJECT_MAPPER.writeValueAsString(Json.writeJsonResult(value));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " to json", e);
        }
    }

    @Procedure(name="apoc.convert.setJsonProperty", mode=Mode.WRITE)
    @Description(value="Serializes the given JSON object and sets it as a property on the given `NODE`.")
    public void setJsonProperty(@Name(value="node") Node node, @Name(value="key") String key, @Name(value="value") Object value) {
        try {
            node.setProperty(key, (Object)JsonUtil.OBJECT_MAPPER.writeValueAsString(value));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " to json", e);
        }
    }

    @UserFunction(value="apoc.convert.getJsonProperty")
    @Description(value="Converts a serialized JSON object from the property of the given `NODE` into the equivalent Cypher structure (e.g. `MAP`, `LIST<ANY>`).")
    public Object getJsonProperty(@Name(value="node") Node node, @Name(value="key") String key, @Name(value="path", defaultValue="") String path, @Name(value="pathOptions", defaultValue="null") List<String> pathOptions) {
        String value = (String)node.getProperty(key, null);
        return JsonUtil.parse(value, path, Object.class, pathOptions);
    }

    @UserFunction(value="apoc.convert.getJsonPropertyMap")
    @Description(value="Converts a serialized JSON object from the property of the given `NODE` into a Cypher `MAP`.")
    public Map<String, Object> getJsonPropertyMap(@Name(value="node") Node node, @Name(value="key") String key, @Name(value="path", defaultValue="") String path, @Name(value="pathOptions", defaultValue="null") List<String> pathOptions) {
        String value = (String)node.getProperty(key, null);
        return JsonUtil.parse(value, path, Map.class, pathOptions);
    }

    @UserFunction(value="apoc.convert.fromJsonMap")
    @Description(value="Converts the given JSON map into a Cypher `MAP`.")
    public Map<String, Object> fromJsonMap(@Name(value="map") String value, @Name(value="path", defaultValue="") String path, @Name(value="pathOptions", defaultValue="null") List<String> pathOptions) {
        return JsonUtil.parse(value, path, Map.class, pathOptions);
    }

    @UserFunction(value="apoc.convert.fromJsonList")
    @Description(value="Converts the given JSON list into a Cypher `LIST<STRING>`.")
    public List<Object> fromJsonList(@Name(value="list") String value, @Name(value="path", defaultValue="") String path, @Name(value="pathOptions", defaultValue="null") List<String> pathOptions) {
        return JsonUtil.parse(value, path, List.class, pathOptions);
    }

    @Procedure(value="apoc.convert.toTree", deprecatedBy="apoc.paths.toJsonTree")
    @Description(value="Returns a stream of `MAP` values, representing the given `PATH` values as a tree with at least one root.")
    public Stream<MapResult> toTree(@Name(value="paths") List<Path> paths, @Name(value="lowerCaseRels", defaultValue="true") boolean lowerCaseRels, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (paths == null || paths.isEmpty()) {
            return Stream.of(new MapResult(Collections.emptyMap()));
        }
        ConvertConfig conf = new ConvertConfig(config);
        Map<String, List<String>> nodes = conf.getNodes();
        Map<String, List<String>> rels = conf.getRels();
        HashMap maps = new HashMap(paths.size() * 100);
        Stream<Object> stream = paths.stream();
        if (conf.isSortPaths()) {
            stream = stream.sorted(Comparator.comparingInt(Path::length).reversed());
        }
        stream.forEach(path -> {
            Iterator it = path.iterator();
            while (it.hasNext()) {
                List list;
                Optional<Map> optMap;
                String typeName;
                Node n = (Node)it.next();
                Map nMap = maps.computeIfAbsent(n.getId(), id -> this.toMap(n, nodes));
                if (!it.hasNext()) continue;
                Relationship r = (Relationship)it.next();
                Node m = r.getOtherNode(n);
                String string = typeName = lowerCaseRels ? r.getType().name().toLowerCase() : r.getType().name();
                if (!nMap.containsKey(typeName)) {
                    nMap.put(typeName, new ArrayList(16));
                }
                if ((optMap = (list = (List)nMap.get(typeName)).stream().filter(elem -> elem.get("_elementId").equals(m.getElementId()) && elem.get(typeName + "._elementId").equals(r.getElementId())).findFirst()).isPresent()) continue;
                Map<String, Object> mMap = this.toMap(m, nodes);
                mMap = this.addRelProperties(mMap, typeName, r, rels);
                maps.put(m.getId(), mMap);
                list.add((Map)maps.get(m.getId()));
            }
        });
        return paths.stream().map(Path::startNode).distinct().map(n -> (Map)maps.remove(n.getId())).map(m -> m == null ? Collections.emptyMap() : m).map(MapResult::new);
    }

    @Procedure(value="apoc.paths.toJsonTree")
    @Description(value="apoc.paths.toJsonTree([paths],[lowerCaseRels=true], [config]) creates a stream of nested documents representing the graph as a tree by traversing outgoing relationships")
    public Stream<MapResult> pathsToTree(@Name(value="paths") List<Path> paths, @Name(value="lowerCaseRels", defaultValue="true") boolean lowerCaseRels, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (paths == null || paths.isEmpty()) {
            return Stream.of(new MapResult(Collections.emptyMap()));
        }
        ConvertConfig conf = new ConvertConfig(config);
        Map<String, List<String>> nodes = conf.getNodes();
        Map<String, List<String>> rels = conf.getRels();
        HashSet visitedInOtherPaths = new HashSet();
        HashSet nodesToKeepInResult = new HashSet();
        HashMap tree = new HashMap();
        Stream<Object> allPaths = paths.stream();
        if (conf.isSortPaths()) {
            allPaths = allPaths.sorted(Comparator.comparingInt(Path::length).reversed());
        }
        allPaths.forEach(path -> {
            Iterable pathRelationships = path.relationships();
            pathRelationships.iterator().forEachRemaining(currentRel -> {
                List currentNodeRels;
                boolean alreadyProcessedRel;
                String typeName;
                Node currentNode = currentRel.getStartNode();
                Long currentNodeId = currentNode.getId();
                if (!visitedInOtherPaths.contains(currentNodeId)) {
                    nodesToKeepInResult.add(currentNodeId);
                }
                Node nextNode = currentRel.getEndNode();
                Map nodeMap = tree.computeIfAbsent(currentNode.getId(), id -> this.toMap(currentNode, nodes));
                Long nextNodeId = nextNode.getId();
                String string = typeName = lowerCaseRels ? currentRel.getType().name().toLowerCase() : currentRel.getType().name();
                if (!nodeMap.containsKey(typeName)) {
                    nodeMap.put(typeName, new ArrayList());
                }
                if (!(alreadyProcessedRel = (currentNodeRels = (List)nodeMap.get(typeName)).stream().anyMatch(elem -> elem.get("_id").equals(nextNodeId) && elem.get(typeName + "._id").equals(currentRel.getId())))) {
                    boolean nodeAlreadyVisited = tree.containsKey(nextNodeId);
                    Map<String, Object> nextNodeMap = this.toMap(nextNode, nodes);
                    this.addRelProperties(nextNodeMap, typeName, (Relationship)currentRel, rels);
                    if (!nodeAlreadyVisited) {
                        tree.put(nextNodeId, nextNodeMap);
                    }
                    visitedInOtherPaths.add(nextNodeId);
                    currentNodeRels.add(nextNodeMap);
                }
            });
        });
        Stream<MapResult> result = nodesToKeepInResult.stream().map(nodeId -> (Map)tree.get(nodeId)).map(MapResult::new);
        return result;
    }

    @UserFunction(value="apoc.convert.toSortedJsonMap")
    @Description(value="Converts a serialized JSON object from the property of a given `NODE` into a Cypher `MAP`.")
    public String toSortedJsonMap(@Name(value="value") Object value, @Name(value="ignoreCase", defaultValue="true") boolean ignoreCase) {
        TreeMap sortedMap;
        Map inputMap;
        if (value instanceof Node) {
            inputMap = ((Node)value).getAllProperties();
        } else if (value instanceof Map) {
            inputMap = (Map)value;
        } else {
            throw new IllegalArgumentException("input value must be a Node or a map");
        }
        if (ignoreCase) {
            sortedMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            sortedMap.putAll(inputMap);
        } else {
            sortedMap = new TreeMap(inputMap);
        }
        try {
            return JsonUtil.OBJECT_MAPPER.writeValueAsString(sortedMap);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " to json", e);
        }
    }

    private Map<String, Object> addRelProperties(Map<String, Object> mMap, String typeName, Relationship r, Map<String, List<String>> relFilters) {
        String prefix = typeName + ".";
        mMap.put(prefix + "_elementId", r.getElementId());
        mMap.put(prefix + "_id", r.getId());
        Map<String, Object> rProps = r.getAllProperties();
        if (rProps.isEmpty()) {
            return mMap;
        }
        if (relFilters.containsKey(typeName)) {
            rProps = this.filterProperties(rProps, relFilters.get(typeName));
        }
        rProps.forEach((k, v) -> mMap.put(prefix + k, v));
        return mMap;
    }

    private Map<String, Object> toMap(Node n, Map<String, List<String>> nodeFilters) {
        Map<String, Object> props = n.getAllProperties();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(props.size() + 2);
        String type = Util.labelString(n);
        result.put("_id", n.getId());
        result.put("_elementId", n.getElementId());
        result.put("_type", type);
        String[] types = type.split(":");
        Optional<String> filter = Arrays.stream(types).filter(t -> nodeFilters.containsKey(t)).findFirst();
        if (filter.isPresent()) {
            props = this.filterProperties(props, nodeFilters.get(filter.get()));
        }
        result.putAll(props);
        return result;
    }

    private Map<String, Object> filterProperties(Map<String, Object> props, List<String> filters) {
        boolean isExclude = filters.get(0).startsWith("-");
        return props.entrySet().stream().filter(e -> isExclude ? !filters.contains("-" + (String)e.getKey()) : filters.contains(e.getKey())).collect(Collectors.toMap(k -> (String)k.getKey(), v -> v.getValue()));
    }
}

