/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.Pools;
import apoc.cypher.CypherUtils;
import apoc.cypher.RunManyResultSpliterator;
import apoc.result.MapResult;
import apoc.util.MapUtil;
import apoc.util.Util;
import apoc.util.collection.Iterators;
import java.io.StringReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class Cypher {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public Pools pools;
    private static final Pattern shellControl = Pattern.compile("^:?\\b(begin|commit|rollback)\\b", 2);

    @NotThreadSafe
    @Procedure(value="apoc.cypher.run")
    @Description(value="Runs a dynamically constructed read-only statement with the given parameters.")
    public Stream<MapResult> run(@Name(value="statement") String statement, @Name(value="params") Map<String, Object> params) {
        return CypherUtils.runCypherQuery(this.tx, statement, params);
    }

    @Procedure(name="apoc.cypher.runMany", mode=Mode.WRITE)
    @Description(value="Runs each semicolon separated statement and returns a summary of the statement outcomes.")
    public Stream<RowResult> runMany(@Name(value="statement") String cypher, @Name(value="params") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        boolean addStatistics = Util.toBoolean(config.getOrDefault("statistics", true));
        return Iterators.stream(new Scanner(new StringReader(cypher)).useDelimiter(";\r?\n")).map(Cypher::removeShellControlCommands).filter(s -> !s.isBlank()).flatMap(s -> this.streamInNewTx((String)s, params, addStatistics));
    }

    private Stream<RowResult> streamInNewTx(String cypher, Map<String, Object> params, boolean stats) {
        try (Transaction innerTx = this.db.beginTx();){
            RunManyResultSpliterator results = new RunManyResultSpliterator(innerTx.execute(cypher, params), stats);
            return (Stream)((Stream)StreamSupport.stream(results, false).onClose(results::close)).onClose(() -> ((Transaction)innerTx).commit());
        }
    }

    @NotThreadSafe
    @Procedure(name="apoc.cypher.runManyReadOnly", mode=Mode.READ)
    @Description(value="Runs each semicolon separated read-only statement and returns a summary of the statement outcomes.")
    public Stream<RowResult> runManyReadOnly(@Name(value="statement") String cypher, @Name(value="params") Map<String, Object> params, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.runMany(cypher, params, config);
    }

    private static String removeShellControlCommands(String stmt) {
        Matcher matcher = shellControl.matcher(stmt.trim());
        if (matcher.find()) {
            return Cypher.removeShellControlCommands(matcher.replaceAll(""));
        }
        return stmt;
    }

    protected static Map<String, Object> toMap(QueryStatistics stats, long time, long rows) {
        Map<String, Object> map = MapUtil.map("rows", rows, "time", time);
        map.putAll(Cypher.toMap(stats));
        return map;
    }

    public static Map<String, Object> toMap(QueryStatistics stats) {
        return MapUtil.map("nodesCreated", stats.getNodesCreated(), "nodesDeleted", stats.getNodesDeleted(), "labelsAdded", stats.getLabelsAdded(), "labelsRemoved", stats.getLabelsRemoved(), "relationshipsCreated", stats.getRelationshipsCreated(), "relationshipsDeleted", stats.getRelationshipsDeleted(), "propertiesSet", stats.getPropertiesSet(), "constraintsAdded", stats.getConstraintsAdded(), "constraintsRemoved", stats.getConstraintsRemoved(), "indexesAdded", stats.getIndexesAdded(), "indexesRemoved", stats.getIndexesRemoved());
    }

    @Procedure(name="apoc.cypher.doIt", mode=Mode.WRITE)
    @Description(value="Runs a dynamically constructed statement with the given parameters. This procedure allows for both read and write statements.")
    public Stream<MapResult> doIt(@Name(value="statement") String statement, @Name(value="params") Map<String, Object> params) {
        return CypherUtils.runCypherQuery(this.tx, statement, params);
    }

    @Procedure(name="apoc.cypher.runWrite", mode=Mode.WRITE)
    @Description(value="Alias for `apoc.cypher.doIt`.")
    public Stream<MapResult> runWrite(@Name(value="statement") String statement, @Name(value="params") Map<String, Object> params) {
        return this.doIt(statement, params);
    }

    @Procedure(name="apoc.cypher.runSchema", mode=Mode.SCHEMA)
    @Description(value="Runs the given query schema statement with the given parameters.")
    public Stream<MapResult> runSchema(@Name(value="statement") String statement, @Name(value="params") Map<String, Object> params) {
        return CypherUtils.runCypherQuery(this.tx, statement, params);
    }

    @NotThreadSafe
    @Procedure(value="apoc.when")
    @Description(value="This procedure will run the read-only `ifQuery` if the conditional has evaluated to true, otherwise the `elseQuery` will run.")
    public Stream<MapResult> when(@Name(value="condition") boolean condition, @Name(value="ifQuery") String ifQuery, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="{}") Map<String, Object> params) {
        String targetQuery;
        if (params == null) {
            params = Collections.emptyMap();
        }
        String string = targetQuery = condition ? ifQuery : elseQuery;
        if (targetQuery.isEmpty()) {
            return Stream.of(new MapResult(Collections.emptyMap()));
        }
        return this.tx.execute(CypherUtils.withParamMapping(targetQuery, params.keySet()), params).stream().map(MapResult::new);
    }

    @Procedure(value="apoc.do.when", mode=Mode.WRITE)
    @Description(value="Runs the given read/write `ifQuery` if the conditional has evaluated to true, otherwise the `elseQuery` will run.")
    public Stream<MapResult> doWhen(@Name(value="condition") boolean condition, @Name(value="ifQuery") String ifQuery, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="{}") Map<String, Object> params) {
        return this.when(condition, ifQuery, elseQuery, params);
    }

    @NotThreadSafe
    @Procedure(value="apoc.case")
    @Description(value="For each pair of conditional and read-only queries in the given `LIST<ANY>`, this procedure will run the first query for which the conditional is evaluated to true. If none of the conditionals are true, the `ELSE` query will run instead.")
    public Stream<MapResult> whenCase(@Name(value="conditionals") List<Object> conditionals, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="{}") Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (conditionals.size() % 2 != 0) {
            throw new IllegalArgumentException("Conditionals must be an even-sized collection of boolean, query entries");
        }
        Iterator<Object> caseItr = conditionals.iterator();
        while (caseItr.hasNext()) {
            boolean condition = (Boolean)caseItr.next();
            String ifQuery = (String)caseItr.next();
            if (!condition) continue;
            return this.tx.execute(CypherUtils.withParamMapping(ifQuery, params.keySet()), params).stream().map(MapResult::new);
        }
        if (elseQuery.isEmpty()) {
            return Stream.of(new MapResult(Collections.emptyMap()));
        }
        return this.tx.execute(CypherUtils.withParamMapping(elseQuery, params.keySet()), params).stream().map(MapResult::new);
    }

    @Procedure(name="apoc.do.case", mode=Mode.WRITE)
    @Description(value="For each pair of conditional queries in the given `LIST<ANY>`, this procedure will run the first query for which the conditional is evaluated to true.\nIf none of the conditionals are true, the `ELSE` query will run instead.")
    public Stream<MapResult> doWhenCase(@Name(value="conditionals") List<Object> conditionals, @Name(value="elseQuery", defaultValue="") String elseQuery, @Name(value="params", defaultValue="{}") Map<String, Object> params) {
        return this.whenCase(conditionals, elseQuery, params);
    }

    public record RowResult(long row, Map<String, Object> result) {
    }
}

