/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.cypher.CypherUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.UserFunction;

public class CypherFunctions {
    @Context
    public Transaction tx;

    public Object runFirstColumn(String statement, Map<String, Object> params, boolean expectMultipleValues) {
        Object resolvedStatement;
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (!((String)(resolvedStatement = CypherUtils.withParamMapping(statement, params.keySet()))).contains(" runtime")) {
            resolvedStatement = "cypher runtime=slotted " + (String)resolvedStatement;
        }
        try (Result result = this.tx.execute((String)resolvedStatement, params);){
            Object object;
            block18: {
                ResourceIterator iter;
                block16: {
                    List list;
                    block17: {
                        String firstColumn = (String)result.columns().get(0);
                        iter = result.columnAs(firstColumn);
                        try {
                            if (!expectMultipleValues) break block16;
                            list = iter.stream().collect(Collectors.toList());
                            if (iter == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (iter != null) {
                                try {
                                    iter.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        iter.close();
                    }
                    return list;
                }
                Object object2 = object = iter.hasNext() ? iter.next() : null;
                if (iter == null) break block18;
                iter.close();
            }
            return object;
        }
    }

    @NotThreadSafe
    @UserFunction(value="apoc.cypher.runFirstColumnMany")
    @Description(value="Runs the given statement with the given parameters and returns the first column collected into a `LIST<ANY>`.")
    public List<Object> runFirstColumnMany(@Name(value="statement") String statement, @Name(value="params") Map<String, Object> params) {
        return (List)this.runFirstColumn(statement, params, true);
    }

    @NotThreadSafe
    @UserFunction(value="apoc.cypher.runFirstColumnSingle")
    @Description(value="Runs the given statement with the given parameters and returns the first element of the first column.")
    public Object runFirstColumnSingle(@Name(value="statement") String statement, @Name(value="params") Map<String, Object> params) {
        return this.runFirstColumn(statement, params, false);
    }
}

