/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.ApocConfig;
import apoc.SystemLabels;
import apoc.SystemPropertyKeys;
import apoc.util.LogsUtil;
import apoc.util.QueryUtil;
import apoc.util.Util;
import apoc.util.collection.Iterators;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.logging.Log;

public class CypherInitializer
implements AvailabilityListener {
    private final GraphDatabaseAPI db;
    private final Log userLog;
    private final DependencyResolver dependencyResolver;
    private final DatabaseManagementService databaseManagementService;
    private final DatabaseEventListeners databaseEventListeners;
    private volatile boolean finished = false;

    public CypherInitializer(GraphDatabaseAPI db, Log userLog, DatabaseManagementService databaseManagementService, DatabaseEventListeners databaseEventListeners) {
        this.db = db;
        this.userLog = userLog;
        this.databaseManagementService = databaseManagementService;
        this.databaseEventListeners = databaseEventListeners;
        this.dependencyResolver = db.getDependencyResolver();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void available() {
        Util.newDaemonThread(() -> {
            try {
                while (!this.db.isAvailable(100L)) {
                }
                if (this.db.databaseId().isSystemDatabase()) {
                    String apocVersion;
                    String neo4jVersion = Version.getNeo4jVersion();
                    if (CypherInitializer.isVersionDifferent(neo4jVersion, apocVersion = apoc.version.Version.class.getPackage().getImplementationVersion())) {
                        this.userLog.warn("The apoc version (%s) and the Neo4j DBMS versions %s are incompatible. \nThe two first numbers of both versions needs to be the same.", new Object[]{apocVersion, neo4jVersion});
                    }
                    this.databaseEventListeners.registerDatabaseEventListener((DatabaseEventListener)new SystemFunctionalityListener());
                }
                Configuration config = ((ApocConfig)((Object)((Object)this.dependencyResolver.resolveDependency(ApocConfig.class)))).getConfig();
                for (String query : this.collectInitializers(config)) {
                    if (QueryUtil.isValidQuery(query)) {
                        String sanitizedQuery = LogsUtil.sanitizeQuery(query);
                        try {
                            Util.retryInTx(this.userLog, (GraphDatabaseService)this.db, tx -> Iterators.count(tx.execute(query)), 0L, 5L, retries -> {});
                            this.userLog.info("successfully initialized: " + sanitizedQuery);
                        }
                        catch (Exception e) {
                            this.userLog.error("error upon initialization, running: " + sanitizedQuery, (Throwable)e);
                        }
                        continue;
                    }
                    this.userLog.error("error upon initialization, invalid query: " + query);
                }
            }
            catch (Exception e) {
                this.userLog.error("error upon initialization", (Throwable)e);
            }
            finally {
                this.finished = true;
            }
        }).start();
    }

    public static boolean isVersionDifferent(String neo4jVersion, String apocVersion) {
        String[] apocSplit = CypherInitializer.splitVersion(apocVersion);
        String[] neo4jSplit = CypherInitializer.splitVersion(neo4jVersion);
        return apocSplit == null || neo4jSplit == null || !apocSplit[0].equals(neo4jSplit[0]) || !apocSplit[1].equals(neo4jSplit[1]);
    }

    private static String[] splitVersion(String completeVersion) {
        if (StringUtils.isBlank(completeVersion)) {
            return null;
        }
        return completeVersion.split("[^\\d]");
    }

    private Collection<String> collectInitializers(Configuration config) {
        TreeMap initializers = new TreeMap();
        config.getKeys("apoc.initializer." + this.db.databaseName()).forEachRemaining(key -> this.putIfNotBlank(initializers, (String)key, config.getString(key)));
        return initializers.values();
    }

    private void putIfNotBlank(Map<String, String> map, String key, String value) {
        if (value != null && !value.isBlank()) {
            map.put(key, value);
        }
    }

    public void unavailable() {
    }

    private void forEachSystemLabel(BiConsumer<Transaction, Label> consumer) {
        try (Transaction tx = this.db.beginTx();){
            for (SystemLabels label : SystemLabels.values()) {
                consumer.accept(tx, label);
            }
            tx.commit();
        }
    }

    private class SystemFunctionalityListener
    implements DatabaseEventListener {
        private SystemFunctionalityListener() {
        }

        public void databaseDrop(DatabaseEventContext eventContext) {
            CypherInitializer.this.forEachSystemLabel((tx, label) -> tx.findNodes(label, SystemPropertyKeys.database.name(), (Object)eventContext.getDatabaseName()).forEachRemaining(Node::delete));
        }

        public void databaseStart(DatabaseEventContext eventContext) {
        }

        public void databaseShutdown(DatabaseEventContext eventContext) {
        }

        public void databasePanic(DatabaseEventContext eventContext) {
        }

        public void databaseCreate(DatabaseEventContext eventContext) {
        }
    }
}

