/*
 * Decompiled with CFR 0.152.
 */
package apoc.example;

import apoc.result.ProgressInfo;
import apoc.util.Util;
import java.util.stream.Stream;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;

public class Examples {
    @Context
    public Transaction tx;

    @NotThreadSafe
    @Procedure(name="apoc.example.movies", mode=Mode.WRITE)
    @Description(value="Seeds the database with the Neo4j movie dataset.")
    public Stream<ProgressInfo> movies() {
        long start = System.currentTimeMillis();
        String file = "movies.cypher";
        Result result = this.tx.execute(Util.readResourceFile(file));
        QueryStatistics stats = result.getQueryStatistics();
        ProgressInfo progress = new ProgressInfo(file, "example movie database from themoviedb.org", "cypher").update(stats.getNodesCreated(), stats.getRelationshipsCreated(), stats.getPropertiesSet()).done(start);
        result.close();
        return Stream.of(progress);
    }
}

