/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.arrow;

import apoc.Pools;
import apoc.export.arrow.ArrowConfig;
import apoc.export.arrow.ExportArrowService;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.result.ByteArrayResult;
import apoc.result.ProgressInfo;
import apoc.result.VirtualGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class ExportArrow {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public Pools pools;
    @Context
    public Log logger;
    @Context
    public TerminationGuard terminationGuard;

    @NotThreadSafe
    @Procedure(value="apoc.export.arrow.stream.all")
    @Description(value="Exports the full database as an arrow byte array.")
    public Stream<ByteArrayResult> all(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).stream(new DatabaseSubGraph(this.tx), new ArrowConfig(config));
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.arrow.stream.graph")
    @Description(value="Exports the given graph as an arrow byte array.")
    public Stream<ByteArrayResult> graph(@Name(value="graph") Object graph, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        NodesAndRelsSubGraph subGraph;
        if (graph instanceof Map) {
            Map mGraph = (Map)graph;
            if (!mGraph.containsKey("nodes")) {
                throw new IllegalArgumentException("Graph Map must contains `nodes` field and `relationships` optionally");
            }
            subGraph = new NodesAndRelsSubGraph(this.tx, (Collection)mGraph.get("nodes"), (Collection)mGraph.get("relationships"));
        } else if (graph instanceof VirtualGraph) {
            VirtualGraph vGraph = (VirtualGraph)graph;
            subGraph = new NodesAndRelsSubGraph(this.tx, vGraph.nodes(), vGraph.relationships());
        } else {
            throw new IllegalArgumentException("Supported inputs are VirtualGraph, Map");
        }
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).stream(subGraph, new ArrowConfig(config));
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.arrow.stream.query")
    @Description(value="Exports the given Cypher query as an arrow byte array.")
    public Stream<ByteArrayResult> query(@Name(value="query") String query, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.tx.execute(query, params);
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).stream(result, new ArrowConfig(config));
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.arrow.all")
    @Description(value="Exports the full database as an arrow file.")
    public Stream<ProgressInfo> all(@Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).file(fileName, new DatabaseSubGraph(this.tx), new ArrowConfig(config));
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.arrow.graph")
    @Description(value="Exports the given graph as an arrow file.")
    public Stream<ProgressInfo> graph(@Name(value="file") String fileName, @Name(value="graph") Object graph, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        NodesAndRelsSubGraph subGraph;
        if (graph instanceof Map) {
            Map mGraph = (Map)graph;
            if (!mGraph.containsKey("nodes")) {
                throw new IllegalArgumentException("Graph Map must contains `nodes` field and `relationships` optionally");
            }
            subGraph = new NodesAndRelsSubGraph(this.tx, (Collection)mGraph.get("nodes"), (Collection)mGraph.get("relationships"));
        } else if (graph instanceof VirtualGraph) {
            VirtualGraph vGraph = (VirtualGraph)graph;
            subGraph = new NodesAndRelsSubGraph(this.tx, vGraph.nodes(), vGraph.relationships());
        } else {
            throw new IllegalArgumentException("Supported inputs are VirtualGraph, Map");
        }
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).file(fileName, subGraph, new ArrowConfig(config));
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.arrow.query")
    @Description(value="Exports the results from the given Cypher query as an arrow file.")
    public Stream<ProgressInfo> query(@Name(value="file") String fileName, @Name(value="query") String query, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.tx.execute(query, params);
        return new ExportArrowService(this.db, this.pools, this.terminationGuard, this.logger).file(fileName, result, new ArrowConfig(config));
    }
}

