/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.arrow;

import apoc.export.arrow.ArrowConfig;
import apoc.meta.Types;
import apoc.util.JsonUtil;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.ipc.ArrowWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.values.storable.DurationValue;

public interface ExportArrowStrategy<IN, OUT> {
    public OUT export(IN var1, ArrowConfig var2);

    public Object convertValue(Object var1);

    public ArrowWriter newArrowWriter(VectorSchemaRoot var1, OutputStream var2);

    public Schema schemaFor(List<Map<String, Object>> var1);

    public TerminationGuard getTerminationGuard();

    public BufferAllocator getBufferAllocator();

    public GraphDatabaseService getGraphDatabaseApi();

    public ExecutorService getExecutorService();

    public Log getLogger();

    public static String fromMetaType(Types type) {
        switch (type) {
            case INTEGER: {
                return "Long";
            }
            case FLOAT: {
                return "Double";
            }
            case LIST: {
                String inner = type.toString().substring("LIST OF ".length()).trim();
                Types innerType = Types.from(inner);
                if (innerType == Types.LIST) {
                    return "AnyArray";
                }
                return ExportArrowStrategy.fromMetaType(innerType) + "Array";
            }
            case BOOLEAN: {
                return "Boolean";
            }
            case MAP: {
                return "Map";
            }
            case RELATIONSHIP: {
                return "Relationship";
            }
            case NODE: {
                return "Node";
            }
            case PATH: {
                return "Path";
            }
            case POINT: {
                return "Point";
            }
            case DATE: {
                return "Date";
            }
            case LOCAL_TIME: 
            case DATE_TIME: 
            case LOCAL_DATE_TIME: {
                return "DateTime";
            }
            case TIME: {
                return "Time";
            }
            case DURATION: {
                return "Duration";
            }
        }
        return "String";
    }

    public static Field toField(String fieldName, Set<String> propertyTypes) {
        String type;
        if (propertyTypes.size() > 1) {
            return new Field(fieldName, FieldType.nullable((ArrowType)new ArrowType.Utf8()), null);
        }
        switch (type = propertyTypes.iterator().next()) {
            case "Boolean": {
                return new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.BIT.getType()), null);
            }
            case "Long": {
                return new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.BIGINT.getType()), null);
            }
            case "Double": {
                return new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.FLOAT8.getType()), null);
            }
            case "DateTime": 
            case "LocalDateTime": 
            case "Date": {
                return new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.DATEMILLI.getType()), null);
            }
        }
        return type.endsWith("Array") ? new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.LIST.getType()), List.of(ExportArrowStrategy.toField("$data$", Set.of(type.replace("Array", ""))))) : new Field(fieldName, FieldType.nullable((ArrowType)Types.MinorType.VARCHAR.getType()), null);
    }

    default public void write(int index, Object value, FieldVector fieldVector) {
        if (fieldVector instanceof BaseVariableWidthVector) {
            this.writeBaseVariableWidthVector(index, value, (BaseVariableWidthVector)fieldVector);
        } else if (fieldVector instanceof BigIntVector) {
            this.writeBigIntVector(index, value, (BigIntVector)fieldVector);
        } else if (fieldVector instanceof DateMilliVector) {
            this.writeDateMilliVector(index, value, (DateMilliVector)fieldVector);
        } else if (fieldVector instanceof Float8Vector) {
            this.writeFloat8Vector(index, value, (Float8Vector)fieldVector);
        } else if (fieldVector instanceof BitVector) {
            this.writeBitVector(index, value, (BitVector)fieldVector);
        } else if (fieldVector instanceof ListVector) {
            this.writeListVector(index, value, fieldVector);
        }
    }

    private void writeListVector(int index, Object value, FieldVector fieldVector) {
        Object[] array;
        ListVector listVector = (ListVector)fieldVector;
        if (value == null) {
            listVector.setNull(index);
            return;
        }
        UnionListWriter listWriter = listVector.getWriter();
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            array = collection.toArray(new Object[collection.size()]);
        } else {
            array = (Object[])value;
        }
        listWriter.setPosition(index);
        listWriter.startList();
        FieldVector inner = (FieldVector)listVector.getChildrenFromFields().get(0);
        for (int i = 0; i < array.length; ++i) {
            Object val = this.convertValue(array[i]);
            if (val == null) {
                listWriter.writeNull();
                continue;
            }
            if (inner instanceof ListVector) {
                this.write(i, val, inner);
                continue;
            }
            if (inner instanceof BaseVariableWidthVector) {
                byte[] bytes = val instanceof String ? val.toString().getBytes(StandardCharsets.UTF_8) : JsonUtil.writeValueAsBytes(val);
                ArrowBuf tempBuf = fieldVector.getAllocator().buffer((long)bytes.length);
                tempBuf.setBytes(0L, bytes);
                listWriter.varChar().writeVarChar(0, bytes.length, tempBuf);
                tempBuf.close();
                continue;
            }
            if (inner instanceof BigIntVector) {
                long lng = (Long)val;
                listWriter.bigInt().writeBigInt(lng);
                continue;
            }
            if (inner instanceof Float8Vector) {
                double dbl = (Double)val;
                listWriter.float8().writeFloat8(dbl);
                continue;
            }
            if (!(inner instanceof BitVector)) continue;
            boolean bool = (Boolean)val;
            listWriter.bit().writeBit(bool ? 1 : 0);
        }
        listWriter.endList();
    }

    private void writeBitVector(int index, Object value, BitVector fieldVector) {
        BitVector baseVector = fieldVector;
        if (value == null) {
            baseVector.setNull(index);
        } else {
            baseVector.setSafe(index, (Boolean)value != false ? 1 : 0);
        }
    }

    private void writeFloat8Vector(int index, Object value, Float8Vector fieldVector) {
        Float8Vector baseVector = fieldVector;
        if (value == null) {
            baseVector.setNull(index);
        } else {
            baseVector.setSafe(index, ((Double)value).doubleValue());
        }
    }

    private void writeDateMilliVector(int index, Object value, DateMilliVector fieldVector) {
        DateMilliVector baseVector = fieldVector;
        Long dateInMillis = value == null ? null : (value instanceof Date ? Long.valueOf(((Date)value).getTime()) : (value instanceof LocalDateTime ? Long.valueOf(((LocalDateTime)value).toInstant(ZoneOffset.UTC).toEpochMilli()) : (value instanceof ZonedDateTime ? Long.valueOf(((ZonedDateTime)value).toInstant().toEpochMilli()) : (value instanceof OffsetDateTime ? Long.valueOf(((OffsetDateTime)value).toInstant().toEpochMilli()) : null))));
        if (dateInMillis == null) {
            baseVector.setNull(index);
        } else {
            baseVector.setSafe(index, dateInMillis.longValue());
        }
    }

    private void writeBigIntVector(int index, Object value, BigIntVector fieldVector) {
        BigIntVector baseVector = fieldVector;
        if (value == null) {
            baseVector.setNull(index);
        } else {
            baseVector.setSafe(index, ((Long)value).longValue());
        }
    }

    private void writeBaseVariableWidthVector(int index, Object value, BaseVariableWidthVector fieldVector) {
        BaseVariableWidthVector baseVector = fieldVector;
        if (value == null) {
            baseVector.setNull(index);
            return;
        }
        if (value instanceof DurationValue) {
            value = ((DurationValue)value).toString();
        }
        if (value instanceof String) {
            baseVector.setSafe(index, value.toString().getBytes(StandardCharsets.UTF_8));
        } else {
            baseVector.setSafe(index, JsonUtil.writeValueAsBytes(value));
        }
    }
}

