/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.export.csv.CsvHeaderField;
import apoc.export.csv.CsvHeaderFields;
import apoc.export.csv.CsvLoaderConfig;
import apoc.export.csv.CsvLoaderConstants;
import apoc.export.csv.CsvPropertyConverter;
import apoc.export.util.BatchTransaction;
import apoc.export.util.CountingReader;
import apoc.export.util.ProgressReporter;
import apoc.load.CSVResult;
import apoc.load.Mapping;
import apoc.load.util.Results;
import apoc.util.FileUtils;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.RFC4180ParserBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.logging.Log;

public class CsvEntityLoader {
    private final CsvLoaderConfig clc;
    private final ProgressReporter reporter;
    private final Log log;
    private final URLAccessChecker urlAccessChecker;

    public CsvEntityLoader(CsvLoaderConfig clc, ProgressReporter reporter, Log log, URLAccessChecker urlAccessChecker) {
        this.clc = clc;
        this.reporter = reporter;
        this.log = log;
        this.urlAccessChecker = urlAccessChecker;
    }

    public void loadNodes(Object fileName, List<String> labels, GraphDatabaseService db, Map<String, Map<String, String>> idMapping) throws IOException, URISyntaxException, URLAccessValidationError {
        try (CountingReader reader = FileUtils.readerFor(fileName, this.clc.getCompressionAlgo(), this.urlAccessChecker);){
            String header = CsvEntityLoader.readFirstLine(reader);
            List<CsvHeaderField> fields = CsvHeaderFields.processHeader(header, this.clc.getDelimiter(), this.clc.getQuotationCharacter());
            Optional<CsvHeaderField> idField = fields.stream().filter(f -> "ID".equals(f.getType())).findFirst();
            if (!idField.isPresent()) {
                this.log.warn("Please note that if no ID is specified, the node will be imported but it will not be able to be connected by any relationships during the import");
            }
            Optional idAttribute = idField.isPresent() ? Optional.of(idField.get().getName()) : Optional.empty();
            String idSpace = idField.isPresent() ? idField.get().getIdSpace() : "__CSV_DEFAULT_IDSPACE";
            idMapping.putIfAbsent(idSpace, new HashMap());
            Map<String, String> idspaceIdMapping = idMapping.get(idSpace);
            Map<String, Mapping> mapping = this.getMapping(fields);
            CSVReader csv = new CSVReaderBuilder(reader).withCSVParser(new RFC4180ParserBuilder().withSeparator(this.clc.getDelimiter()).withQuoteChar(this.clc.getQuotationCharacter()).build()).withSkipLines(this.clc.getSkipLines() - 1).build();
            String[] loadCsvCompatibleHeader = (String[])fields.stream().map(f -> f.getName()).toArray(String[]::new);
            AtomicInteger lineNo = new AtomicInteger();
            try (BatchTransaction btx = new BatchTransaction(db, this.clc.getBatchSize(), this.reporter);){
                csv.forEach(line -> {
                    lineNo.getAndIncrement();
                    EnumSet<Results> results = EnumSet.of(Results.map);
                    CSVResult result = new CSVResult(loadCsvCompatibleHeader, (String[])line, lineNo.get(), false, mapping, Collections.emptyList(), results);
                    String nodeCsvId = idAttribute.map(result.map::get).orElse(null);
                    if (idField.isPresent() && idspaceIdMapping.containsKey(nodeCsvId)) {
                        if (this.clc.getIgnoreDuplicateNodes()) {
                            return;
                        }
                        throw new IllegalStateException("Duplicate node with id " + nodeCsvId + " found on line " + lineNo + "\n" + Arrays.toString(line));
                    }
                    Node node = btx.getTransaction().createNode();
                    if (idField.isPresent()) {
                        idspaceIdMapping.put(nodeCsvId, node.getElementId());
                    }
                    for (String label : labels) {
                        node.addLabel(Label.label((String)label));
                    }
                    int props = 0;
                    for (CsvHeaderField field : fields) {
                        String name = field.getName();
                        Object value = result.map.get(name);
                        if (field.isMeta()) {
                            List customLabels = (List)value;
                            for (String customLabel : customLabels) {
                                node.addLabel(Label.label((String)customLabel));
                            }
                            continue;
                        }
                        if (field.isId()) {
                            Object idValue = this.clc.getStringIds() ? value : Long.valueOf((String)value);
                            node.setProperty(field.getName(), idValue);
                            ++props;
                            continue;
                        }
                        boolean propertyAdded = CsvPropertyConverter.addPropertyToGraphEntity((Entity)node, field, value, this.clc);
                        props += propertyAdded ? 1 : 0;
                    }
                    btx.increment();
                    this.reporter.update(1L, 0L, props++);
                });
                btx.doCommit();
            }
        }
    }

    public void loadRelationships(Object data, String type, GraphDatabaseService db, Map<String, Map<String, String>> idMapping) throws IOException, URISyntaxException, URLAccessValidationError {
        try (CountingReader reader = FileUtils.readerFor(data, this.clc.getCompressionAlgo(), this.urlAccessChecker);){
            String header = CsvEntityLoader.readFirstLine(reader);
            List<CsvHeaderField> fields = CsvHeaderFields.processHeader(header, this.clc.getDelimiter(), this.clc.getQuotationCharacter());
            CsvHeaderField startIdField = fields.stream().filter(f -> "START_ID".equals(f.getType())).findFirst().get();
            CsvHeaderField endIdField = fields.stream().filter(f -> "END_ID".equals(f.getType())).findFirst().get();
            List edgePropertiesFields = fields.stream().filter(field -> !"START_ID".equals(field.getType())).filter(field -> !"END_ID".equals(field.getType())).collect(Collectors.toList());
            Map<String, Mapping> mapping = this.getMapping(fields);
            try (CSVReader csv = new CSVReaderBuilder(reader).withCSVParser(new RFC4180ParserBuilder().withSeparator(this.clc.getDelimiter()).withQuoteChar(this.clc.getQuotationCharacter()).build()).withSkipLines(this.clc.getSkipLines() - 1).build();){
                String[] loadCsvCompatibleHeader = (String[])fields.stream().map(f -> f.getName()).toArray(String[]::new);
                AtomicInteger lineNo = new AtomicInteger();
                try (BatchTransaction btx = new BatchTransaction(db, this.clc.getBatchSize(), this.reporter);){
                    csv.forEach(line -> {
                        lineNo.getAndIncrement();
                        EnumSet<Results> results = EnumSet.of(Results.map);
                        CSVResult result = new CSVResult(loadCsvCompatibleHeader, (String[])line, lineNo.get(), false, mapping, Collections.emptyList(), results);
                        Object startId = result.map.get(CsvLoaderConstants.START_ID_ATTR);
                        Object startInternalId = ((Map)idMapping.get(startIdField.getIdSpace())).get(startId.toString());
                        if (startInternalId == null) {
                            throw new IllegalStateException("Node for id space " + endIdField.getIdSpace() + " and id " + startId + " not found");
                        }
                        Node source = btx.getTransaction().getNodeByElementId(startInternalId.toString());
                        Object endId = result.map.get(CsvLoaderConstants.END_ID_ATTR);
                        Object endInternalId = ((Map)idMapping.get(endIdField.getIdSpace())).get(endId.toString());
                        if (endInternalId == null) {
                            throw new IllegalStateException("Node for id space " + endIdField.getIdSpace() + " and id " + endId + " not found");
                        }
                        Node target = btx.getTransaction().getNodeByElementId(endInternalId.toString());
                        Object overridingType = result.map.get(CsvLoaderConstants.TYPE_ATTR);
                        String currentType = overridingType != null && !((String)overridingType).isEmpty() ? (String)overridingType : type;
                        Relationship rel = source.createRelationshipTo(target, RelationshipType.withName((String)currentType));
                        int props = 0;
                        for (CsvHeaderField field : edgePropertiesFields) {
                            String name;
                            Object value;
                            boolean propertyAdded = CsvPropertyConverter.addPropertyToGraphEntity((Entity)rel, field, value = result.map.get(name = field.getName()), this.clc);
                            props += propertyAdded ? 1 : 0;
                        }
                        btx.increment();
                        this.reporter.update(0L, 1L, props);
                    });
                    btx.doCommit();
                }
            }
        }
    }

    private Map<String, Mapping> getMapping(List<CsvHeaderField> fields) {
        return fields.stream().collect(Collectors.toMap(CsvHeaderField::getName, f -> {
            Map<String, Object> mappingMap = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("type", f.getType()), new AbstractMap.SimpleEntry<String, Boolean>("array", f.isArray()), new AbstractMap.SimpleEntry<String, Map<String, Object>>("optionalData", f.getOptionalData())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            return new Mapping(f.getName(), mappingMap, this.clc.getArrayDelimiter(), false);
        }));
    }

    private static String readFirstLine(CountingReader reader) throws IOException {
        char c;
        int i;
        Object line = "";
        while ((i = reader.read()) != 0 && (c = (char)i) != '\n') {
            line = (String)line + c;
        }
        return line;
    }
}

