/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.export.csv.CustomCSVWriter;
import apoc.export.cypher.ExportFileManager;
import apoc.export.util.BulkImportUtil;
import apoc.export.util.ExportConfig;
import apoc.export.util.FormatUtils;
import apoc.export.util.MetaInformation;
import apoc.export.util.Reporter;
import apoc.result.ProgressInfo;
import apoc.util.Util;
import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

public class CsvFormat {
    private final GraphDatabaseService db;
    private final InternalTransaction tx;
    private boolean applyQuotesToAll = true;
    private static final String[] NODE_HEADER_FIXED_COLUMNS = new String[]{"_id:id", "_labels:label"};
    private static final String[] REL_HEADER_FIXED_COLUMNS = new String[]{"_start:id", "_end:id", "_type:label"};

    public CsvFormat(GraphDatabaseService db, InternalTransaction tx) {
        this.db = db;
        this.tx = tx;
    }

    public void dump(SubGraph graph, ExportFileManager writer, Reporter reporter, ExportConfig config) {
        try (Transaction tx = this.db.beginTx();){
            if (config.isBulkImport()) {
                this.writeAllBulkImport(graph, reporter, config, writer);
            } else {
                try (PrintWriter printWriter = writer.getPrintWriter("csv");){
                    CSVWriter out = this.getCsvWriter(printWriter, config);
                    this.writeAll(graph, reporter, config, out);
                }
            }
            tx.commit();
            reporter.done();
        }
    }

    private CSVWriter getCsvWriter(Writer writer, ExportConfig config) {
        CustomCSVWriter out;
        switch (config.isQuotes()) {
            case "none": {
                out = new CustomCSVWriter(writer, config.getDelimChar(), '\u0000', '\u0000', "\n", config.shouldDifferentiateNulls());
                this.applyQuotesToAll = false;
                break;
            }
            case "ifNeeded": {
                out = new CustomCSVWriter(writer, config.getDelimChar(), '\"', '\"', "\n", config.shouldDifferentiateNulls());
                this.applyQuotesToAll = false;
                break;
            }
            default: {
                out = new CustomCSVWriter(writer, config.getDelimChar(), '\"', '\"', "\n", config.shouldDifferentiateNulls());
                this.applyQuotesToAll = true;
            }
        }
        return out;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ProgressInfo dump(Result result, ExportFileManager writer, Reporter reporter, ExportConfig config) {
        try (Transaction tx = this.db.beginTx();){
            PrintWriter printWriter = writer.getPrintWriter("csv");
            try {
                CSVWriter out = this.getCsvWriter(printWriter, config);
                String[] header = this.writeResultHeader(result, out);
                String[] data = new String[header.length];
                result.accept(row -> {
                    for (int col = 0; col < header.length; ++col) {
                        String key = header[col];
                        Object value = row.get(key);
                        data[col] = FormatUtils.toString(value, config.shouldDifferentiateNulls());
                        reporter.update(value instanceof Node ? 1L : 0L, value instanceof Relationship ? 1L : 0L, value instanceof Entity ? 0L : 1L);
                    }
                    out.writeNext(data, this.applyQuotesToAll);
                    reporter.nextRow();
                    return true;
                });
                tx.commit();
                reporter.done();
                ProgressInfo progressInfo = reporter.getTotal();
                if (printWriter != null) {
                    printWriter.close();
                }
                return progressInfo;
            }
            catch (Throwable throwable) {
                if (printWriter != null) {
                    try {
                        printWriter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (AuthorizationViolationException e) {
            throw new RuntimeException(Util.INVALID_QUERY_MODE_ERROR);
        }
    }

    public String[] writeResultHeader(Result result, CSVWriter out) {
        List columns = result.columns();
        int cols = columns.size();
        String[] header = columns.toArray(new String[cols]);
        out.writeNext(header, this.applyQuotesToAll);
        return header;
    }

    public void writeAll(SubGraph graph, Reporter reporter, ExportConfig config, CSVWriter out) {
        Map<String, Class> nodePropTypes = MetaInformation.collectPropTypesForNodes(graph, this.db, config);
        Map<String, Class> relPropTypes = MetaInformation.collectPropTypesForRelationships(graph, this.db, config);
        List<String> nodeHeader = this.generateHeader(nodePropTypes, config.useTypes(), NODE_HEADER_FIXED_COLUMNS);
        List<String> relHeader = this.generateHeader(relPropTypes, config.useTypes(), REL_HEADER_FIXED_COLUMNS);
        ArrayList<String> header = new ArrayList<String>(nodeHeader);
        header.addAll(relHeader);
        out.writeNext(header.toArray(new String[header.size()]), this.applyQuotesToAll);
        int cols = header.size();
        this.writeNodes(graph, out, reporter, nodeHeader.subList(NODE_HEADER_FIXED_COLUMNS.length, nodeHeader.size()), cols, config.getBatchSize(), config.shouldDifferentiateNulls());
        this.writeRels(graph, out, reporter, relHeader.subList(REL_HEADER_FIXED_COLUMNS.length, relHeader.size()), cols, nodeHeader.size(), config.getBatchSize(), config.shouldDifferentiateNulls());
    }

    private void writeAllBulkImport(SubGraph graph, Reporter reporter, ExportConfig config, ExportFileManager writer) {
        Map<Iterable<Label>, List<Node>> objectNodes = StreamSupport.stream(graph.getNodes().spliterator(), false).collect(Collectors.groupingBy(Node::getLabels));
        Map<RelationshipType, List<Relationship>> objectRels = StreamSupport.stream(graph.getRelationships().spliterator(), false).collect(Collectors.groupingBy(Relationship::getType));
        this.writeNodesBulkImport(reporter, config, writer, objectNodes);
        this.writeRelsBulkImport(reporter, config, writer, objectRels);
    }

    private void writeNodesBulkImport(Reporter reporter, ExportConfig config, ExportFileManager writer, Map<Iterable<Label>, List<Node>> objectNode) {
        objectNode.entrySet().forEach(entrySet -> {
            Set<String> headerNode = this.generateHeaderNodeBulkImport((Map.Entry<Iterable<Label>, List<Node>>)entrySet);
            List<List<String>> rows = ((List)entrySet.getValue()).stream().map(n -> {
                reporter.update(1L, 0L, n.getAllProperties().size());
                return headerNode.stream().map(s -> {
                    if (s.equals(":LABEL")) {
                        return Util.joinLabels((Iterable)entrySet.getKey(), config.getArrayDelim());
                    }
                    String prop = s.split(":")[0];
                    return prop.isEmpty() ? String.valueOf(Util.getNodeId(this.tx, n.getElementId())) : FormatUtils.toString(n.getProperty(prop, (Object)""));
                }).collect(Collectors.toList());
            }).collect(Collectors.toList());
            String type = Util.joinLabels((Iterable)entrySet.getKey(), ".");
            this.writeRow(config, writer, headerNode, rows, "nodes." + type);
        });
    }

    private void writeRelsBulkImport(Reporter reporter, ExportConfig config, ExportFileManager writer, Map<RelationshipType, List<Relationship>> objectRel) {
        objectRel.entrySet().forEach(entrySet -> {
            Set<String> headerRel = this.generateHeaderRelationshipBulkImport((Map.Entry<RelationshipType, List<Relationship>>)entrySet);
            List<List<String>> rows = ((List)entrySet.getValue()).stream().map(r -> {
                reporter.update(0L, 1L, r.getAllProperties().size());
                return headerRel.stream().map(s -> {
                    switch (s) {
                        case ":START_ID": {
                            return String.valueOf(Util.getNodeId(this.tx, r.getStartNode().getElementId()));
                        }
                        case ":END_ID": {
                            return String.valueOf(Util.getNodeId(this.tx, r.getEndNode().getElementId()));
                        }
                        case ":TYPE": {
                            return ((RelationshipType)entrySet.getKey()).name();
                        }
                    }
                    String prop = s.split(":")[0];
                    return prop.isEmpty() ? String.valueOf(Util.getRelationshipId(this.tx, r.getElementId())) : FormatUtils.toString(r.getProperty(prop, (Object)""));
                }).collect(Collectors.toList());
            }).collect(Collectors.toList());
            this.writeRow(config, writer, headerRel, rows, "relationships." + ((RelationshipType)entrySet.getKey()).name());
        });
    }

    private Set<String> generateHeaderNodeBulkImport(Map.Entry<Iterable<Label>, List<Node>> entrySet) {
        LinkedHashSet<String> headerNode = new LinkedHashSet<String>();
        headerNode.add(":ID");
        LinkedHashMap keyTypes = new LinkedHashMap();
        entrySet.getValue().forEach(node -> MetaInformation.updateKeyTypes(keyTypes, (Entity)node));
        LinkedHashSet otherFields = keyTypes.entrySet().stream().map(stringClassEntry -> BulkImportUtil.formatHeader(stringClassEntry)).collect(Collectors.toCollection(LinkedHashSet::new));
        headerNode.addAll(otherFields);
        headerNode.add(":LABEL");
        return headerNode;
    }

    private Set<String> generateHeaderRelationshipBulkImport(Map.Entry<RelationshipType, List<Relationship>> entrySet) {
        LinkedHashSet<String> headerNode = new LinkedHashSet<String>();
        LinkedHashMap keyTypes = new LinkedHashMap();
        entrySet.getValue().forEach(relationship -> MetaInformation.updateKeyTypes(keyTypes, (Entity)relationship));
        headerNode.add(":START_ID");
        headerNode.add(":END_ID");
        headerNode.add(":TYPE");
        headerNode.addAll(keyTypes.entrySet().stream().map(stringClassEntry -> BulkImportUtil.formatHeader(stringClassEntry)).collect(Collectors.toCollection(LinkedHashSet::new)));
        return headerNode;
    }

    private void writeRow(ExportConfig config, ExportFileManager writer, Set<String> headerNode, List<List<String>> rows, String name) {
        try (PrintWriter pw = writer.getPrintWriter(name);
             CSVWriter csvWriter = this.getCsvWriter(pw, config);){
            if (config.isSeparateHeader()) {
                try (PrintWriter pwHeader = writer.getPrintWriter("header." + name);){
                    CSVWriter csvWriterHeader = this.getCsvWriter(pwHeader, config);
                    csvWriterHeader.writeNext(headerNode.toArray(new String[headerNode.size()]), false);
                }
            } else {
                csvWriter.writeNext(headerNode.toArray(new String[headerNode.size()]), false);
            }
            rows.forEach(row -> csvWriter.writeNext(row.toArray(new String[row.size()]), false));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> generateHeader(Map<String, Class> propTypes, boolean useTypes, String ... starters) {
        ArrayList<String> result = new ArrayList<String>();
        if (useTypes) {
            Collections.addAll(result, starters);
        } else {
            result.addAll(Stream.of(starters).map(s -> s.split(":")[0]).collect(Collectors.toList()));
        }
        result.addAll(propTypes.entrySet().stream().map(entry -> {
            String type = MetaInformation.typeFor((Class)entry.getValue(), null);
            return type == null || type.equals("string") || !useTypes ? (String)entry.getKey() : (String)entry.getKey() + ":" + type;
        }).sorted().collect(Collectors.toList()));
        return result;
    }

    private void writeNodes(SubGraph graph, CSVWriter out, Reporter reporter, List<String> header, int cols, int batchSize, boolean keepNulls) {
        String[] row = new String[cols];
        int nodes = 0;
        for (Node node : graph.getNodes()) {
            row[0] = String.valueOf(Util.getNodeId(this.tx, node.getElementId()));
            row[1] = MetaInformation.getLabelsString(node);
            this.collectProps(header, (Entity)node, reporter, row, 2, keepNulls);
            out.writeNext(row, this.applyQuotesToAll);
            if (batchSize != -1 && ++nodes % batchSize != 0) continue;
            reporter.update(nodes, 0L, 0L);
            nodes = 0;
        }
        if (nodes > 0) {
            reporter.update(nodes, 0L, 0L);
        }
    }

    private void collectProps(Collection<String> fields, Entity pc, Reporter reporter, String[] row, int offset, boolean keepNulls) {
        for (String field : fields) {
            if (pc.hasProperty(field)) {
                row[offset] = FormatUtils.toString(pc.getProperty(field));
                reporter.update(0L, 0L, 1L);
            } else {
                row[offset] = keepNulls ? null : "";
            }
            ++offset;
        }
    }

    private void writeRels(SubGraph graph, CSVWriter out, Reporter reporter, List<String> relHeader, int cols, int offset, int batchSize, boolean keepNull) {
        String[] row = new String[cols];
        int rels = 0;
        for (Relationship rel : graph.getRelationships()) {
            row[offset] = String.valueOf(Util.getNodeId(this.tx, rel.getStartNode().getElementId()));
            row[offset + 1] = String.valueOf(Util.getNodeId(this.tx, rel.getEndNode().getElementId()));
            row[offset + 2] = rel.getType().name();
            this.collectProps(relHeader, (Entity)rel, reporter, row, 3 + offset, keepNull);
            out.writeNext(row, this.applyQuotesToAll);
            if (batchSize != -1 && ++rels % batchSize != 0) continue;
            reporter.update(0L, rels, 0L);
            rels = 0;
        }
        if (rels > 0) {
            reporter.update(0L, rels, 0L);
        }
    }
}

