/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.Pools;
import apoc.export.csv.CsvEntityLoader;
import apoc.export.csv.CsvLoaderConfig;
import apoc.export.util.ProgressReporter;
import apoc.result.ProgressInfo;
import apoc.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ImportCsv {
    @Context
    public GraphDatabaseService db;
    @Context
    public Pools pools;
    @Context
    public Log log;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(name="apoc.import.csv", mode=Mode.SCHEMA)
    @Description(value="Imports `NODE` and `RELATIONSHIP` values with the given labels and types from the provided CSV file.")
    public Stream<ProgressInfo> importCsv(@Name(value="nodes") List<Map<String, Object>> nodes, @Name(value="rels") List<Map<String, Object>> relationships, @Name(value="config") Map<String, Object> config) {
        ProgressInfo result = Util.inThread(this.pools, () -> {
            Object fileName;
            String file = "progress.csv";
            String source = "file";
            if (nodes.stream().anyMatch(node -> node.containsKey("data"))) {
                file = null;
                source = "file/binary";
            }
            CsvLoaderConfig clc = CsvLoaderConfig.from(config);
            ProgressReporter reporter = new ProgressReporter(null, null, new ProgressInfo(file, source, "csv"));
            CsvEntityLoader loader = new CsvEntityLoader(clc, reporter, this.log, this.urlAccessChecker);
            HashMap<String, Map<String, String>> idMapping = new HashMap<String, Map<String, String>>();
            for (Map node2 : nodes) {
                fileName = node2.getOrDefault("fileName", node2.get("data"));
                List labels = (List)node2.get("labels");
                loader.loadNodes(fileName, labels, this.db, idMapping);
            }
            for (Map relationship : relationships) {
                fileName = relationship.getOrDefault("fileName", relationship.get("data"));
                String type = (String)relationship.get("type");
                loader.loadRelationships(fileName, type, this.db, idMapping);
            }
            return reporter.getTotal();
        });
        return Stream.of(result);
    }
}

