/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.graphml;

import apoc.ApocConfig;
import apoc.Pools;
import apoc.export.cypher.ExportFileManager;
import apoc.export.cypher.FileManagerFactory;
import apoc.export.graphml.XmlGraphMLReader;
import apoc.export.graphml.XmlGraphMLWriter;
import apoc.export.util.CountingReader;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportUtils;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.export.util.ProgressReporter;
import apoc.export.util.Reporter;
import apoc.result.ProgressInfo;
import apoc.util.FileUtils;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.cypher.export.CypherResultSubGraph;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class ExportGraphML {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public ApocConfig apocConfig;
    @Context
    public Pools pools;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(name="apoc.import.graphml", mode=Mode.WRITE)
    @Description(value="Imports a graph from the provided GraphML file.")
    public Stream<ProgressInfo> file(@Name(value="urlOrBinaryFile") Object urlOrBinaryFile, @Name(value="config") Map<String, Object> config) {
        ProgressInfo result = Util.inThread(this.pools, () -> {
            ExportConfig exportConfig = new ExportConfig(config);
            String file = null;
            String source = "binary";
            if (urlOrBinaryFile instanceof String) {
                file = (String)urlOrBinaryFile;
                source = "file";
            }
            ProgressReporter reporter = new ProgressReporter(null, null, new ProgressInfo(file, source, "graphml"));
            XmlGraphMLReader graphMLReader = new XmlGraphMLReader(this.db).reporter(reporter).batchSize(exportConfig.getBatchSize()).relType(exportConfig.defaultRelationshipType()).source(exportConfig.getSource()).target(exportConfig.getTarget()).nodeLabels(exportConfig.readLabels());
            if (exportConfig.storeNodeIds()) {
                graphMLReader.storeNodeIds();
            }
            try (CountingReader reader = FileUtils.readerFor(urlOrBinaryFile, exportConfig.getCompressionAlgo(), this.urlAccessChecker);){
                graphMLReader.parseXML(reader, this.terminationGuard);
            }
            return reporter.getTotal();
        });
        return Stream.of(result);
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.graphml.all")
    @Description(value="Exports the full database to the provided GraphML file.")
    public Stream<ProgressInfo> all(@Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount(this.tx), Util.relCount(this.tx));
        return this.exportGraphML(fileName, source, new DatabaseSubGraph(this.tx), new ExportConfig(config));
    }

    @Procedure(value="apoc.export.graphml.data")
    @Description(value="Exports the given `NODE` and `RELATIONSHIP` values to the provided GraphML file.")
    public Stream<ProgressInfo> data(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("data: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportGraphML(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), new ExportConfig(config));
    }

    @Procedure(value="apoc.export.graphml.graph")
    @Description(value="Exports the given graph to the provided GraphML file.")
    public Stream<ProgressInfo> graph(@Name(value="graph") Map<String, Object> graph, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        String source = String.format("graph: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportGraphML(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), new ExportConfig(config));
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.graphml.query")
    @Description(value="Exports the given `NODE` and `RELATIONSHIP` values from the Cypher statement to the provided GraphML file.")
    public Stream<ProgressInfo> query(@Name(value="statement") String query, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        ExportConfig c = new ExportConfig(config);
        Result result = this.tx.execute(query);
        SubGraph graph = CypherResultSubGraph.from(this.tx, result, c.getRelsInBetween(), false);
        String source = String.format("statement: nodes(%d), rels(%d)", Iterables.count(graph.getNodes()), Iterables.count(graph.getRelationships()));
        return this.exportGraphML(fileName, source, graph, c);
    }

    private Stream<ProgressInfo> exportGraphML(@Name(value="file") String fileName, String source, SubGraph graph, ExportConfig exportConfig) throws Exception {
        this.apocConfig.checkWriteAllowed(exportConfig, fileName);
        String format = "graphml";
        ProgressReporter reporter = new ProgressReporter(null, null, new ProgressInfo(fileName, source, "graphml"));
        XmlGraphMLWriter exporter = new XmlGraphMLWriter();
        ExportFileManager cypherFileManager = FileManagerFactory.createFileManager(fileName, false, exportConfig);
        PrintWriter graphMl = cypherFileManager.getPrintWriter("graphml");
        if (exportConfig.streamStatements()) {
            return ExportUtils.getProgressInfoStream(this.db, this.pools.getDefaultExecutorService(), this.terminationGuard, "graphml", exportConfig, reporter, cypherFileManager, reporterWithConsumer -> {
                try {
                    exporter.write(graph, graphMl, (Reporter)reporterWithConsumer, exportConfig);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        exporter.write(graph, graphMl, reporter, exportConfig);
        this.closeWriter(graphMl);
        return reporter.stream();
    }

    private void closeWriter(PrintWriter writer) {
        writer.flush();
        try {
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

