/*
 * Decompiled with CFR 0.152.
 */
package apoc.graph;

import apoc.cypher.CypherUtils;
import apoc.graph.GraphsUtils;
import apoc.graph.document.builder.DocumentToGraph;
import apoc.graph.util.GraphsConfig;
import apoc.result.RowResult;
import apoc.result.VirtualGraph;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;

public class Graphs {
    @Context
    public Transaction tx;

    @Procedure(value="apoc.graph.fromData")
    @Description(value="Generates a virtual sub-graph by extracting all of the `NODE` and `RELATIONSHIP` values from the given data.")
    public Stream<VirtualGraph> fromData(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> relationships, @Name(value="name") String name, @Name(value="props") Map<String, Object> properties) {
        return Stream.of(new VirtualGraph(name, nodes, relationships, properties));
    }

    @Procedure(value="apoc.graph.from")
    @Description(value="Generates a virtual sub-graph by extracting all of the `NODE` and `RELATIONSHIP` values from the given data.")
    public Stream<VirtualGraph> from(@Name(value="data") Object data, @Name(value="name") String name, @Name(value="props") Map<String, Object> properties) {
        HashSet<Node> nodes = new HashSet<Node>(1000);
        HashSet<Relationship> rels = new HashSet<Relationship>(10000);
        GraphsUtils.extract(data, nodes, rels);
        return Stream.of(new VirtualGraph(name, nodes, rels, properties));
    }

    @Procedure(value="apoc.graph.fromPath")
    @Description(value="Generates a virtual sub-graph by extracting all of the `NODE` and `RELATIONSHIP` values from the data returned by the given `PATH`.")
    public Stream<VirtualGraph> fromPath(@Name(value="path") Path paths, @Name(value="name") String name, @Name(value="props") Map<String, Object> properties) {
        return Stream.of(new VirtualGraph(name, paths.nodes(), paths.relationships(), properties));
    }

    @Procedure(value="apoc.graph.fromPaths")
    @Description(value="Generates a virtual sub-graph by extracting all of the `NODE` and `RELATIONSHIP` values from the data returned by the given `PATH` values.")
    public Stream<VirtualGraph> fromPaths(@Name(value="paths") List<Path> paths, @Name(value="name") String name, @Name(value="props") Map<String, Object> properties) {
        ArrayList<Node> nodes = new ArrayList<Node>(1000);
        ArrayList<Relationship> rels = new ArrayList<Relationship>(1000);
        for (Path path : paths) {
            Iterables.addAll(nodes, path.nodes());
            Iterables.addAll(rels, path.relationships());
        }
        return Stream.of(new VirtualGraph(name, nodes, rels, properties));
    }

    @Procedure(value="apoc.graph.fromDB")
    @Description(value="Generates a virtual sub-graph by extracting all of the `NODE` and `RELATIONSHIP` values from the data returned by the given database.")
    public Stream<VirtualGraph> fromDB(@Name(value="name") String name, @Name(value="props") Map<String, Object> properties) {
        return Stream.of(new VirtualGraph(name, (Iterable<Node>)this.tx.getAllNodes(), (Iterable<Relationship>)this.tx.getAllRelationships(), properties));
    }

    @NotThreadSafe
    @Procedure(value="apoc.graph.fromCypher")
    @Description(value="Generates a virtual sub-graph by extracting all of the `NODE` and `RELATIONSHIP` values from the data returned by the given Cypher statement.")
    public Stream<VirtualGraph> fromCypher(@Name(value="statement") String statement, @Name(value="params") Map<String, Object> params, @Name(value="name") String name, @Name(value="props") Map<String, Object> properties) {
        params = params == null ? Collections.emptyMap() : params;
        HashSet<Node> nodes = new HashSet<Node>(1000);
        HashSet<Relationship> rels = new HashSet<Relationship>(1000);
        HashMap<String, Object> props = new HashMap<String, Object>(properties);
        this.tx.execute(CypherUtils.withParamMapping(statement, params.keySet()), params).stream().forEach(row -> row.forEach((k, v) -> {
            if (!GraphsUtils.extract(v, nodes, rels)) {
                props.put((String)k, v);
            }
        }));
        return Stream.of(new VirtualGraph(name, nodes, rels, props));
    }

    @Procedure(name="apoc.graph.fromDocument", mode=Mode.WRITE)
    @Description(value="Generates a virtual sub-graph by extracting all of the `NODE` and `RELATIONSHIP` values from the data returned by the given JSON file.")
    public Stream<VirtualGraph> fromDocument(@Name(value="json") Object document, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        DocumentToGraph documentToGraph = new DocumentToGraph(this.tx, new GraphsConfig(config));
        return Stream.of(documentToGraph.create(document));
    }

    @Procedure(name="apoc.graph.validateDocument", mode=Mode.READ)
    @Description(value="Validates the JSON file and returns the result of the validation.")
    public Stream<RowResult> validateDocument(@Name(value="json") Object document, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        GraphsConfig graphConfig = new GraphsConfig(config);
        DocumentToGraph documentToGraph = new DocumentToGraph(this.tx, graphConfig);
        Map<Long, List<String>> dups = documentToGraph.validateDocument(document);
        return dups.entrySet().stream().map(e -> new RowResult(Util.map("index", e.getKey(), "message", String.join((CharSequence)"\n", (Iterable)e.getValue()))));
    }
}

