/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.result.MapResult;
import apoc.util.FileUtils;
import apoc.util.JsonUtil;
import apoc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.channels.SeekableByteChannel;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.util.Text;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.Values;

public class LoadArrow {
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(name="apoc.load.arrow.stream")
    @Description(value="Imports `NODE` and `RELATIONSHIP` values from the provided arrow byte array.")
    public Stream<MapResult> stream(@Name(value="source") byte[] source, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException {
        RootAllocator allocator = new RootAllocator();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(source);
        ArrowStreamReader streamReader = new ArrowStreamReader((InputStream)inputStream, (BufferAllocator)allocator);
        VectorSchemaRoot schemaRoot = streamReader.getVectorSchemaRoot();
        return (Stream)StreamSupport.stream(new ArrowSpliterator((ArrowReader)streamReader, schemaRoot), false).onClose(() -> {
            Util.close((AutoCloseable)allocator);
            Util.close((AutoCloseable)streamReader);
            Util.close((AutoCloseable)schemaRoot);
            Util.close(inputStream);
        });
    }

    @Procedure(name="apoc.load.arrow")
    @Description(value="Imports `NODE` and `RELATIONSHIP` values from the provided arrow file.")
    public Stream<MapResult> file(@Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException, URISyntaxException, URLAccessValidationError {
        SeekableByteChannel channel = FileUtils.inputStreamFor(fileName, null, null, null, this.urlAccessChecker).asChannel();
        RootAllocator allocator = new RootAllocator();
        ArrowFileReader streamReader = new ArrowFileReader(channel, (BufferAllocator)allocator);
        VectorSchemaRoot schemaRoot = streamReader.getVectorSchemaRoot();
        return (Stream)StreamSupport.stream(new ArrowSpliterator((ArrowReader)streamReader, schemaRoot), false).onClose(() -> {
            Util.close((AutoCloseable)allocator);
            Util.close((AutoCloseable)streamReader);
            Util.close((AutoCloseable)schemaRoot);
            Util.close(channel);
        });
    }

    private static Object read(FieldVector fieldVector, int index) {
        if (fieldVector.isNull(index)) {
            return null;
        }
        if (fieldVector instanceof DateMilliVector) {
            DateMilliVector fe = (DateMilliVector)fieldVector;
            return Instant.ofEpochMilli(fe.get(index)).atOffset(ZoneOffset.UTC);
        }
        if (fieldVector instanceof BitVector) {
            BitVector fe = (BitVector)fieldVector;
            return fe.get(index) == 1;
        }
        Object object = fieldVector.getObject(index);
        return LoadArrow.getObject(object);
    }

    private static Object getObject(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(LoadArrow::getObject).collect(Collectors.toList());
        }
        if (object instanceof Map) {
            return ((Map)object).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> LoadArrow.getObject(e.getValue())));
        }
        if (object instanceof Text) {
            return object.toString();
        }
        try {
            return Values.of((Object)object);
        }
        catch (Exception e2) {
            return LoadArrow.valueToString(object);
        }
    }

    private static String valueToString(Object value) {
        return JsonUtil.writeValueAsString(value);
    }

    private static class ArrowSpliterator
    extends Spliterators.AbstractSpliterator<MapResult> {
        private final ArrowReader reader;
        private final VectorSchemaRoot schemaRoot;
        private final AtomicInteger counter;

        public ArrowSpliterator(ArrowReader reader, VectorSchemaRoot schemaRoot) throws IOException {
            super(Long.MAX_VALUE, 16);
            this.reader = reader;
            this.schemaRoot = schemaRoot;
            this.counter = new AtomicInteger();
            this.reader.loadNextBatch();
        }

        @Override
        public synchronized boolean tryAdvance(Consumer<? super MapResult> action) {
            try {
                if (this.counter.get() >= this.schemaRoot.getRowCount()) {
                    if (this.reader.loadNextBatch()) {
                        this.counter.set(0);
                    } else {
                        return false;
                    }
                }
                Map row = this.schemaRoot.getFieldVectors().stream().collect(HashMap::new, (map, fieldVector) -> map.put(fieldVector.getName(), LoadArrow.read(fieldVector, this.counter.get())), HashMap::putAll);
                this.counter.incrementAndGet();
                action.accept(new MapResult(row));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

