/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.ApocConfig;
import apoc.export.util.CountingInputStream;
import apoc.export.util.LimitedSizeInputStream;
import apoc.generate.config.InvalidConfigException;
import apoc.load.SkipWhitespaceInputStream;
import apoc.result.MapResult;
import apoc.result.NodeResult;
import apoc.util.CompressionAlgo;
import apoc.util.CompressionConfig;
import apoc.util.FileUtils;
import apoc.util.StreamConnection;
import apoc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.procedure.UserFunction;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class Xml {
    private static final XMLInputFactory FACTORY = XMLInputFactory.newFactory();
    @Context
    public ApocConfig apocConfig;
    @Context
    public Transaction tx;
    @Context
    public Log log;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(value="apoc.load.xml")
    @Description(value="Loads a single nested `MAP` from an XML URL (e.g. web-API).")
    public Stream<MapResult> xml(@Name(value="urlOrBinary") Object urlOrBinary, @Name(value="path", defaultValue="/") String path, @Name(value="config", defaultValue="{}") Map<String, Object> config, @Name(value="simple", defaultValue="false") boolean simpleMode) throws Exception {
        return this.xmlXpathToMapResult(urlOrBinary, simpleMode, path, config);
    }

    @UserFunction(value="apoc.xml.parse")
    @Description(value="Parses the given XML `STRING` as a `MAP`.")
    public Map<String, Object> parse(@Name(value="data") String data, @Name(value="path", defaultValue="/") String path, @Name(value="config", defaultValue="{}") Map<String, Object> config, @Name(value="simple", defaultValue="false") boolean simpleMode) throws Exception {
        if (config == null) {
            config = Collections.emptyMap();
        }
        boolean failOnError = (Boolean)config.getOrDefault("failOnError", true);
        return this.parse(new ByteArrayInputStream(data.getBytes(Charset.forName("UTF-8"))), simpleMode, path, failOnError).map(mr -> mr.value).findFirst().orElse(null);
    }

    private Stream<MapResult> xmlXpathToMapResult(Object urlOrBinary, boolean simpleMode, String path, Map<String, Object> config) throws Exception {
        if (config == null) {
            config = Collections.emptyMap();
        }
        boolean failOnError = (Boolean)config.getOrDefault("failOnError", true);
        try {
            Map<String, Object> headers = config.getOrDefault("headers", Collections.emptyMap());
            CountingInputStream is = FileUtils.inputStreamFor(urlOrBinary, headers, null, (String)config.getOrDefault("compression", CompressionAlgo.NONE.name()), this.urlAccessChecker);
            return this.parse(is, simpleMode, path, failOnError);
        }
        catch (Exception e) {
            if (!failOnError) {
                return Stream.of(new MapResult(Collections.emptyMap()));
            }
            throw e;
        }
    }

    private Stream<MapResult> parse(InputStream data, boolean simpleMode, String path, boolean failOnError) throws Exception {
        ArrayList<MapResult> result = new ArrayList<MapResult>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            Document doc = documentBuilder.parse(data);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            path = StringUtils.isEmpty(path) ? "/" : path;
            XPathExpression xPathExpression = xPath.compile(path);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                LinkedList<Map<String, Object>> stack = new LinkedList<Map<String, Object>>();
                this.handleNode(stack, nodeList.item(i), simpleMode);
                for (int index = 0; index < stack.size(); ++index) {
                    result.add(new MapResult((Map)stack.pollFirst()));
                }
            }
        }
        catch (FileNotFoundException e) {
            if (!failOnError) {
                return Stream.of(new MapResult(Collections.emptyMap()));
            }
            throw e;
        }
        catch (Exception e) {
            if (!failOnError) {
                return Stream.of(new MapResult(Collections.emptyMap()));
            }
            if (e instanceof SAXParseException && e.getMessage().contains("DOCTYPE is disallowed")) {
                throw this.generateXmlDoctypeException();
            }
            throw e;
        }
        return result.stream();
    }

    private XMLStreamReader getXMLStreamReader(Object urlOrBinary, XmlImportConfig config, URLAccessChecker urlAccessChecker) throws IOException, XMLStreamException, URISyntaxException, URLAccessValidationError {
        InputStream inputStream;
        if (urlOrBinary instanceof String) {
            String url = (String)urlOrBinary;
            url = FileUtils.changeFileUrlIfImportDirectoryConstrained(url, urlAccessChecker);
            StreamConnection streamConnection = Util.getStreamConnection(url, null, null, urlAccessChecker);
            inputStream = LimitedSizeInputStream.toLimitedIStream(streamConnection.getInputStream(), streamConnection.getLength());
        } else if (urlOrBinary instanceof byte[]) {
            inputStream = LimitedSizeInputStream.toLimitedIStream(FileUtils.getInputStreamFromBinary((byte[])urlOrBinary, config.getCompressionAlgo()), ((byte[])urlOrBinary).length);
        } else {
            throw new RuntimeException("Only byte[] or url String allowed");
        }
        if (config.isFilterLeadingWhitespace()) {
            inputStream = new SkipWhitespaceInputStream(inputStream);
        }
        return FACTORY.createXMLStreamReader(inputStream);
    }

    private void handleNode(Deque<Map<String, Object>> stack, org.w3c.dom.Node node, boolean simpleMode) {
        this.terminationGuard.check();
        if (node.getNodeType() == 9) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getLocalName() == null) continue;
                this.handleNode(stack, children.item(i), simpleMode);
                return;
            }
        }
        LinkedHashMap<String, Object> elementMap = new LinkedHashMap<String, Object>();
        this.handleTypeAndAttributes(node, elementMap);
        NodeList children = node.getChildNodes();
        int count = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (child.getNodeType() != 3 && child.getNodeType() != 4) {
                this.handleNode(stack, child, simpleMode);
                ++count;
                continue;
            }
            this.handleTextNode(child, elementMap);
        }
        if (children.getLength() > 0 && !stack.isEmpty()) {
            ArrayList<Map<String, Object>> nodeChildren = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < count; ++i) {
                nodeChildren.add(stack.pollLast());
            }
            String key = simpleMode ? "_" + node.getLocalName() : "_children";
            Collections.reverse(nodeChildren);
            if (nodeChildren.size() > 0) {
                Object text = elementMap.get("_text");
                if (text instanceof List) {
                    for (Object element : (List)text) {
                        nodeChildren.add((Map<String, Object>)element);
                    }
                    elementMap.remove("_text");
                }
                elementMap.put(key, nodeChildren);
            }
        }
        if (!elementMap.isEmpty()) {
            stack.addLast(elementMap);
        }
    }

    private void handleTypeAndAttributes(org.w3c.dom.Node node, Map<String, Object> elementMap) {
        if (node.getLocalName() != null) {
            elementMap.put("_type", node.getLocalName());
        }
        if (node.getAttributes() != null) {
            NamedNodeMap attributeMap = node.getAttributes();
            for (int i = 0; i < attributeMap.getLength(); ++i) {
                org.w3c.dom.Node attribute = attributeMap.item(i);
                elementMap.put(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
    }

    private void handleTextNode(org.w3c.dom.Node node, Map<String, Object> elementMap) {
        Object text = "";
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 3: {
                text = this.normalizeText(node.getNodeValue());
                break;
            }
            case 4: {
                text = this.normalizeText(((CharacterData)node).getData());
                break;
            }
        }
        if (!StringUtils.isEmpty(text.toString())) {
            Object previousText = elementMap.get("_text");
            if (previousText != null) {
                text = Arrays.asList(previousText.toString(), text);
            }
            elementMap.put("_text", text);
        }
    }

    private String normalizeText(String text) {
        Object[] tokens = StringUtils.split(text, "\n");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = ((String)tokens[i]).trim();
        }
        return StringUtils.join(tokens, " ").trim();
    }

    @Procedure(mode=Mode.WRITE, value="apoc.import.xml")
    @Description(value="Imports a graph from the provided XML file.")
    public Stream<NodeResult> importToGraph(@Name(value="urlOrBinary") Object urlOrBinary, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IOException, XMLStreamException, URISyntaxException, URLAccessValidationError {
        XmlImportConfig importConfig = new XmlImportConfig(config);
        XMLStreamReader xml = this.getXMLStreamReader(urlOrBinary, importConfig, this.urlAccessChecker);
        Node root = this.tx.createNode(new Label[]{Label.label((String)"XmlDocument")});
        this.setPropertyIfNotNull(root, "_xmlVersion", xml.getVersion());
        this.setPropertyIfNotNull(root, "_xmlEncoding", xml.getEncoding());
        if (urlOrBinary instanceof String) {
            root.setProperty("url", urlOrBinary);
        }
        ImportState state = new ImportState(root);
        state.push(new ParentAndChildPair(root));
        block10: while (xml.hasNext()) {
            xml.next();
            switch (xml.getEventType()) {
                case 11: {
                    throw this.generateXmlDoctypeException();
                }
                case 7: {
                    continue block10;
                }
                case 3: {
                    Node pi = this.tx.createNode(new Label[]{Label.label((String)"XmlProcessingInstruction")});
                    pi.setProperty("_piData", (Object)xml.getPIData());
                    pi.setProperty("_piTarget", (Object)xml.getPITarget());
                    state.updateLast(pi);
                    continue block10;
                }
                case 1: {
                    QName qName = xml.getName();
                    Node tag = this.tx.createNode(new Label[]{Label.label((String)"XmlTag")});
                    tag.setProperty("_name", (Object)qName.getLocalPart());
                    for (int i = 0; i < xml.getAttributeCount(); ++i) {
                        tag.setProperty(xml.getAttributeLocalName(i), (Object)xml.getAttributeValue(i));
                    }
                    state.updateLast(tag);
                    state.push(new ParentAndChildPair(tag));
                    continue block10;
                }
                case 4: {
                    List<String> words = this.parseTextIntoPartsAndDelimiters(xml.getText(), importConfig.getDelimiter());
                    for (String currentWord : words) {
                        this.createCharactersNode(currentWord, state, importConfig);
                    }
                    continue block10;
                }
                case 2: {
                    ParentAndChildPair parent;
                    String charactersForTag = importConfig.getCharactersForTag().get(xml.getName().getLocalPart());
                    if (charactersForTag != null) {
                        this.createCharactersNode(charactersForTag, state, importConfig);
                    }
                    if ((parent = state.pop()).getPreviousChild() == null) continue block10;
                    parent.getPreviousChild().createRelationshipTo(parent.getParent(), RelationshipType.withName((String)"LAST_CHILD_OF"));
                    continue block10;
                }
                case 8: {
                    state.pop();
                    continue block10;
                }
                case 5: 
                case 6: {
                    continue block10;
                }
            }
            this.log.warn("xml file contains a {} type structure - ignoring this.", new Object[]{xml.getEventType()});
        }
        if (!state.isEmpty()) {
            throw new IllegalStateException("non empty parents, this indicates a bug");
        }
        return Stream.of(new NodeResult(root));
    }

    private void createCharactersNode(String currentWord, ImportState state, XmlImportConfig importConfig) {
        Node word = this.tx.createNode(new Label[]{importConfig.getLabel()});
        word.setProperty("text", (Object)currentWord);
        word.setProperty("startIndex", (Object)state.getCurrentCharacterIndex());
        state.addCurrentCharacterIndex(currentWord.length());
        word.setProperty("endIndex", (Object)(state.getCurrentCharacterIndex() - 1));
        state.updateLast(word);
        if (importConfig.isConnectCharacters()) {
            state.getLastWord().createRelationshipTo(word, importConfig.getRelType());
            state.setLastWord(word);
        }
    }

    List<String> parseTextIntoPartsAndDelimiters(String sourceString, Pattern delimiterPattern) {
        Matcher matcher = delimiterPattern.matcher(sourceString);
        ArrayList<String> result = new ArrayList<String>();
        int prevEndIndex = 0;
        int length = sourceString.length();
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (prevEndIndex != start) {
                result.add(sourceString.substring(prevEndIndex, start));
            }
            result.add(sourceString.substring(start, end));
            prevEndIndex = end;
        }
        if (prevEndIndex != length) {
            result.add(sourceString.substring(prevEndIndex, length));
        }
        return result;
    }

    private void setPropertyIfNotNull(Node root, String propertyKey, Object value) {
        if (value != null) {
            root.setProperty(propertyKey, value);
        }
    }

    private RuntimeException generateXmlDoctypeException() {
        throw new RuntimeException("XML documents with a DOCTYPE are not allowed.");
    }

    static {
        FACTORY.setProperty("javax.xml.stream.isCoalescing", true);
        FACTORY.setProperty("javax.xml.stream.supportDTD", false);
        FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }

    private static class XmlImportConfig
    extends CompressionConfig {
        private boolean connectCharacters;
        private Pattern delimiter;
        private Label label = Label.label((String)"XmlCharacters");
        private RelationshipType relType = RelationshipType.withName((String)"NE");
        private Map<String, String> charactersForTag = new HashMap<String, String>();
        private final boolean filterLeadingWhitespace;

        public XmlImportConfig(Map<String, Object> config) {
            super(config);
            Map _charactersForTag;
            String _relType;
            if (config == null) {
                config = Collections.emptyMap();
            }
            this.connectCharacters = BooleanUtils.toBoolean((Boolean)config.get("connectCharacters"));
            this.filterLeadingWhitespace = BooleanUtils.toBoolean((Boolean)config.get("filterLeadingWhitespace"));
            String _delimiter = (String)config.get("delimiter");
            if (_delimiter != null) {
                this.connectCharacters = true;
            }
            this.delimiter = Pattern.compile(_delimiter == null ? "\\s" : _delimiter);
            String _label = (String)config.get("label");
            if (_label != null) {
                this.label = Label.label((String)_label);
                this.connectCharacters = true;
            }
            if ((_relType = (String)config.get("relType")) != null) {
                this.relType = RelationshipType.withName((String)_relType);
                this.connectCharacters = true;
            }
            if ((_charactersForTag = (Map)config.get("charactersForTag")) != null) {
                this.charactersForTag = _charactersForTag;
            }
            if (config.containsKey("createNextWordRelationships")) {
                throw new InvalidConfigException("usage of `createNextWordRelationships` is no longer allowed. Use `{relType:'NEXT_WORD', label:'XmlWord'}` instead.");
            }
        }

        public Pattern getDelimiter() {
            return this.delimiter;
        }

        public Label getLabel() {
            return this.label;
        }

        public RelationshipType getRelType() {
            return this.relType;
        }

        public boolean isConnectCharacters() {
            return this.connectCharacters;
        }

        public Map<String, String> getCharactersForTag() {
            return this.charactersForTag;
        }

        public boolean isFilterLeadingWhitespace() {
            return this.filterLeadingWhitespace;
        }
    }

    private static class ImportState {
        private final Deque<ParentAndChildPair> parents = new ArrayDeque<ParentAndChildPair>();
        private Node last;
        private Node lastWord;
        private int currentCharacterIndex = 0;

        public ImportState(Node initialNode) {
            this.last = initialNode;
            this.lastWord = initialNode;
        }

        public void push(ParentAndChildPair parentAndChildPair) {
            this.parents.push(parentAndChildPair);
        }

        public Node getLastWord() {
            return this.lastWord;
        }

        public void setLastWord(Node lastWord) {
            this.lastWord = lastWord;
        }

        public int getCurrentCharacterIndex() {
            return this.currentCharacterIndex;
        }

        public ParentAndChildPair pop() {
            return this.parents.pop();
        }

        public boolean isEmpty() {
            return this.parents.isEmpty();
        }

        public void updateLast(Node thisNode) {
            ParentAndChildPair parentAndChildPair = this.parents.peek();
            Node parent = parentAndChildPair.getParent();
            Node previousChild = parentAndChildPair.getPreviousChild();
            this.last.createRelationshipTo(thisNode, RelationshipType.withName((String)"NEXT"));
            thisNode.createRelationshipTo(parent, RelationshipType.withName((String)"IS_CHILD_OF"));
            if (previousChild == null) {
                thisNode.createRelationshipTo(parent, RelationshipType.withName((String)"FIRST_CHILD_OF"));
            } else {
                previousChild.createRelationshipTo(thisNode, RelationshipType.withName((String)"NEXT_SIBLING"));
            }
            parentAndChildPair.setPreviousChild(thisNode);
            this.last = thisNode;
        }

        public void addCurrentCharacterIndex(int length) {
            this.currentCharacterIndex += length;
        }
    }

    public static class ParentAndChildPair {
        private final Node parent;
        private Node previousChild = null;

        public ParentAndChildPair(Node parent) {
            this.parent = parent;
        }

        public Node getParent() {
            return this.parent;
        }

        public Node getPreviousChild() {
            return this.previousChild;
        }

        public void setPreviousChild(Node previousChild) {
            this.previousChild = previousChild;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParentAndChildPair that = (ParentAndChildPair)o;
            return this.parent.equals(that.parent);
        }

        public int hashCode() {
            return this.parent.hashCode();
        }
    }
}

