/*
 * Decompiled with CFR 0.152.
 */
package apoc.log;

import apoc.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Neo4jLogStream {
    @Admin
    @Procedure(name="apoc.log.stream", mode=Mode.DBMS)
    @Description(value="Returns the file contents from the given log, optionally returning only the last n lines.\nThis procedure requires users to have an admin role.")
    public Stream<FileEntry> stream(@Name(value="path") String logName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        File logDir = FileUtils.getLogDirectory();
        if (logDir == null) {
            throw new RuntimeException("Neo4j configured server.directories.logs points to a directory that does not exist or is not readable.  Please ensure this configuration is correct.");
        }
        File f = new File(logDir, logName);
        try {
            if (!f.getCanonicalFile().toPath().startsWith(logDir.getAbsolutePath())) {
                throw new RuntimeException("The path you are trying to access has a canonical path outside of the logs directory, and this procedure is only permitted to access files in the log directory.  This may occur if the path in question is a symlink or other link.");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to resolve basic log file canonical path", ioe);
        }
        try {
            Stream<String> stream = Files.lines(Paths.get(f.toURI()));
            AtomicLong lineNumber = new AtomicLong(0L);
            String p = f.getCanonicalPath();
            Stream<FileEntry> entries = stream.map(line -> new FileEntry(lineNumber.getAndIncrement(), (String)line, p));
            if (config.containsKey("last")) {
                return entries.sorted(Collections.reverseOrder()).limit(Double.valueOf(config.get("last").toString()).longValue());
            }
            return entries;
        }
        catch (NoSuchFileException nsf) {
            throw new RuntimeException("No log file exists by that name");
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static class FileEntry
    implements Comparable<FileEntry> {
        public final long lineNo;
        public final String line;
        public final String path;

        public FileEntry(long lineNumber, String data, String path) {
            this.lineNo = lineNumber;
            this.line = data;
            this.path = path;
        }

        @Override
        public int compareTo(FileEntry o) {
            return Long.compare(this.lineNo, o.lineNo);
        }
    }
}

