/*
 * Decompiled with CFR 0.152.
 */
package apoc.math;

import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Maths {
    @UserFunction(value="apoc.math.maxLong")
    @Description(value="Returns the maximum value of a long.")
    public Long maxLong() {
        return Long.MAX_VALUE;
    }

    @UserFunction(value="apoc.math.minLong")
    @Description(value="Returns the minimum value of a long.")
    public Long minLong() {
        return Long.MIN_VALUE;
    }

    @UserFunction(value="apoc.math.maxDouble")
    @Description(value="Returns the largest positive finite value of type double.")
    public Double maxDouble() {
        return Double.MAX_VALUE;
    }

    @UserFunction(value="apoc.math.minDouble")
    @Description(value="Returns the smallest positive non-zero value of type double.")
    public Double minDouble() {
        return Double.MIN_VALUE;
    }

    @UserFunction(value="apoc.math.maxInt")
    @Description(value="Returns the maximum value of an integer.")
    public Long maxInt() {
        return Integer.MAX_VALUE;
    }

    @UserFunction(value="apoc.math.minInt")
    @Description(value="Returns the minimum value of an integer.")
    public Long minInt() {
        return Integer.MIN_VALUE;
    }

    @UserFunction(value="apoc.math.maxByte")
    @Description(value="Returns the maximum value of a byte.")
    public Long maxByte() {
        return 127L;
    }

    @UserFunction(value="apoc.math.minByte")
    @Description(value="Returns the minimum value of a byte.")
    public Long minByte() {
        return -128L;
    }

    @UserFunction(value="apoc.math.sigmoid")
    @Description(value="Returns the sigmoid of the given value.")
    public Double sigmoid(@Name(value="value") Double value) {
        if (value == null) {
            return null;
        }
        return 1.0 / (1.0 + Math.exp(-value.doubleValue()));
    }

    @UserFunction(value="apoc.math.sigmoidPrime")
    @Description(value="Returns the sigmoid prime [ sigmoid(val) * (1 - sigmoid(val)) ] of the given value.")
    public Double sigmoidPrime(@Name(value="value") Double value) {
        if (value == null) {
            return null;
        }
        return this.sigmoid(value) * (1.0 - this.sigmoid(value));
    }

    @UserFunction(value="apoc.math.tanh")
    @Description(value="Returns the hyperbolic tangent of the given value.")
    public Double tanh(@Name(value="value") Double value) {
        if (value == null) {
            return null;
        }
        return this.sinh(value) / this.cosh(value);
    }

    @UserFunction(value="apoc.math.coth")
    @Description(value="Returns the hyperbolic cotangent.")
    public Double coth(@Name(value="value") Double value) {
        if (value == null || value.equals(0.0)) {
            return null;
        }
        return this.cosh(value) / this.sinh(value);
    }

    @UserFunction(value="apoc.math.cosh")
    @Description(value="Returns the hyperbolic cosine.")
    public Double cosh(@Name(value="value") Double value) {
        if (value == null) {
            return null;
        }
        return (Math.exp(value) + Math.exp(-value.doubleValue())) / 2.0;
    }

    @UserFunction(value="apoc.math.sinh")
    @Description(value="Returns the hyperbolic sine of the given value.")
    public Double sinh(@Name(value="value") Double value) {
        if (value == null) {
            return null;
        }
        return (Math.exp(value) - Math.exp(-value.doubleValue())) / 2.0;
    }

    @UserFunction(value="apoc.math.sech")
    @Description(value="Returns the hyperbolic secant of the given value.")
    public Double sech(@Name(value="value") Double value) {
        if (value == null) {
            return null;
        }
        return 1.0 / this.cosh(value);
    }

    @UserFunction(value="apoc.math.csch")
    @Description(value="Returns the hyperbolic cosecant.")
    public Double csch(@Name(value="value") Double value) {
        if (value == null || value.equals(0.0)) {
            return null;
        }
        return 1.0 / this.sinh(value);
    }
}

