/*
 * Decompiled with CFR 0.152.
 */
package apoc.math;

import apoc.math.SimpleRegression;
import java.util.stream.Stream;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Regression {
    @Context
    public Transaction tx;

    @Procedure(name="apoc.math.regr", mode=Mode.READ)
    @Description(value="Returns the coefficient of determination (R-squared) for the values of propertyY and propertyX in the given label.")
    public Stream<Output> regr(@Name(value="label") String label, @Name(value="propertyY") String y, @Name(value="propertyX") String x) {
        SimpleRegression regr = new SimpleRegression();
        double regrAvgX = 0.0;
        double regrAvgY = 0.0;
        int count = 0;
        try (ResourceIterator it = this.tx.findNodes(Label.label((String)label));){
            while (it.hasNext()) {
                Node node = (Node)it.next();
                Number propX = (Number)node.getProperty(x, null);
                Number propY = (Number)node.getProperty(y, null);
                if (propX == null || propY == null) continue;
                regrAvgX += propX.doubleValue();
                regrAvgY += propY.doubleValue();
                regr.addData(propX.doubleValue(), propY.doubleValue());
                ++count;
            }
        }
        return Stream.of(new Output(regr.getRSquare(), regrAvgX /= (double)count, regrAvgY /= (double)count, regr.getSlope()));
    }

    public static class Output {
        public double r2;
        public double avgX;
        public double avgY;
        public double slope;

        public Output(double r2, double avgX, double avgY, double slope) {
            this.r2 = r2;
            this.avgX = avgX;
            this.avgY = avgY;
            this.slope = slope;
        }
    }
}

