/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import apoc.util.collection.Iterables;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Paths {
    @UserFunction(value="apoc.path.create")
    @Description(value="Returns a `PATH` from the given start `NODE` and `LIST<RELATIONSHIP>`.")
    public Path create(@Name(value="startNode") Node startNode, @Name(value="rels", defaultValue="[]") List<Relationship> rels) {
        if (startNode == null) {
            return null;
        }
        PathImpl.Builder builder = new PathImpl.Builder(startNode);
        if (rels != null) {
            for (Relationship rel : rels) {
                if (rel == null) continue;
                builder = builder.push(rel);
            }
        }
        return builder.build();
    }

    @UserFunction(value="apoc.path.slice")
    @Description(value="Returns a new `PATH` of the given length, taken from the given `PATH` at the given offset.")
    public Path slice(@Name(value="path") Path path, @Name(value="offset", defaultValue="0") long offset, @Name(value="length", defaultValue="-1") long length) {
        if (path == null) {
            return null;
        }
        if (offset < 0L) {
            offset = 0L;
        }
        if (length == -1L) {
            length = (long)path.length() - offset;
        }
        if (offset == 0L && length >= (long)path.length()) {
            return path;
        }
        Iterator nodes = path.nodes().iterator();
        Iterator rels = path.relationships().iterator();
        for (long i = 0L; i < offset && nodes.hasNext() && rels.hasNext(); ++i) {
            nodes.next();
            rels.next();
        }
        if (!nodes.hasNext()) {
            return null;
        }
        PathImpl.Builder builder = new PathImpl.Builder((Node)nodes.next());
        for (long i = 0L; i < length && rels.hasNext(); ++i) {
            builder = builder.push((Relationship)rels.next());
        }
        return builder.build();
    }

    @UserFunction(value="apoc.path.combine")
    @Description(value="Combines the two given `PATH` values into one `PATH`.")
    public Path combine(@Name(value="path1") Path first, @Name(value="path2") Path second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (!first.endNode().equals(second.startNode())) {
            throw new IllegalArgumentException("Paths don't connect on their end and start-nodes " + first + " with " + second);
        }
        PathImpl.Builder builder = new PathImpl.Builder(first.startNode());
        for (Relationship rel : first.relationships()) {
            builder = builder.push(rel);
        }
        for (Relationship rel : second.relationships()) {
            builder = builder.push(rel);
        }
        return builder.build();
    }

    @UserFunction(value="apoc.path.elements")
    @Description(value="Converts the given `PATH` into a `LIST<NODE | RELATIONSHIP>`.")
    public List<Object> elements(@Name(value="path") Path path) {
        if (path == null) {
            return null;
        }
        return Iterables.asList(path);
    }
}

