/*
 * Decompiled with CFR 0.152.
 */
package apoc.schema;

import apoc.result.AssertSchemaResult;
import apoc.result.IndexConstraintNodeInfo;
import apoc.result.IndexConstraintRelationshipInfo;
import apoc.schema.SchemaConfig;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Schemas {
    private static final String IDX_NOT_FOUND = "NOT_FOUND";
    @Context
    public Transaction tx;
    @Context
    public KernelTransaction ktx;

    @NotThreadSafe
    @Procedure(name="apoc.schema.assert", mode=Mode.SCHEMA)
    @Description(value="Drops all other existing indexes and constraints when `dropExisting` is `true` (default is `true`).\nAsserts at the end of the operation that the given indexes and unique constraints are there.")
    public Stream<AssertSchemaResult> schemaAssert(@Name(value="indexes") Map<String, List<Object>> indexes, @Name(value="constraints") Map<String, List<Object>> constraints, @Name(value="dropExisting", defaultValue="true") boolean dropExisting) {
        return Stream.concat(this.assertIndexes(indexes, dropExisting).stream(), this.assertConstraints(constraints, dropExisting).stream());
    }

    @NotThreadSafe
    @Procedure(name="apoc.schema.nodes", mode=Mode.SCHEMA)
    @Description(value="Returns all indexes and constraints information for all `NODE` labels in the database.\nIt is possible to define a set of labels to include or exclude in the config parameters.")
    public Stream<IndexConstraintNodeInfo> nodes(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.indexesAndConstraintsForNode(config);
    }

    @NotThreadSafe
    @Procedure(name="apoc.schema.relationships", mode=Mode.SCHEMA)
    @Description(value="Returns the indexes and constraints information for all the relationship types in the database.\nIt is possible to define a set of relationship types to include or exclude in the config parameters.")
    public Stream<IndexConstraintRelationshipInfo> relationships(@Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.indexesAndConstraintsForRelationships(config);
    }

    @NotThreadSafe
    @UserFunction(name="apoc.schema.node.indexExists")
    @Description(value="Returns a `BOOLEAN` depending on whether or not an index exists for the given `NODE` label with the given property names.")
    public Boolean indexExistsOnNode(@Name(value="labelName") String labelName, @Name(value="propertyName") List<String> propertyNames) {
        return this.indexExists(labelName, propertyNames);
    }

    @NotThreadSafe
    @UserFunction(value="apoc.schema.relationship.indexExists")
    @Description(value="Returns a `BOOLEAN` depending on whether or not an index exists for the given `RELATIONSHIP` type with the given property names.")
    public Boolean indexExistsOnRelationship(@Name(value="type") String relName, @Name(value="propertyName") List<String> propertyNames) {
        return this.indexExistsForRelationship(relName, propertyNames);
    }

    @NotThreadSafe
    @UserFunction(name="apoc.schema.node.constraintExists")
    @Description(value="Returns a `BOOLEAN` depending on whether or not a constraint exists for the given `NODE` label with the given property names.")
    public Boolean constraintExistsOnNode(@Name(value="labelName") String labelName, @Name(value="propertyName") List<String> propertyNames) {
        return this.constraintsExists(labelName, propertyNames);
    }

    @NotThreadSafe
    @UserFunction(name="apoc.schema.relationship.constraintExists")
    @Description(value="Returns a `BOOLEAN` depending on whether or not a constraint exists for the given `RELATIONSHIP` type with the given property names.")
    public Boolean constraintExistsOnRelationship(@Name(value="type") String type, @Name(value="propertyName") List<String> propertyNames) {
        return this.constraintsExistsForRelationship(type, propertyNames);
    }

    public List<AssertSchemaResult> assertConstraints(Map<String, List<Object>> constraints0, boolean dropExisting) {
        Map<String, List<Object>> constraints = this.copyMapOfObjects(constraints0);
        ArrayList<AssertSchemaResult> result = new ArrayList<AssertSchemaResult>(constraints.size());
        Schema schema = this.tx.schema();
        for (ConstraintDefinition constraintDefinition : schema.getConstraints()) {
            ConstraintType constraintType = constraintDefinition.getConstraintType();
            String label = Util.isRelationshipCategory(constraintType) ? constraintDefinition.getRelationshipType().name() : constraintDefinition.getLabel().name();
            AssertSchemaResult info = new AssertSchemaResult((Object)label, Iterables.asList(constraintDefinition.getPropertyKeys()));
            if (Util.constraintIsUnique(constraintType)) {
                info = info.unique();
            }
            if (!this.checkIfConstraintExists(label, constraints, info) && dropExisting) {
                constraintDefinition.drop();
                info.dropped();
            }
            result.add(info);
        }
        for (Map.Entry entry : constraints.entrySet()) {
            for (Object key : (List)entry.getValue()) {
                if (key instanceof String) {
                    result.add(this.createUniqueConstraint(schema, (String)entry.getKey(), key.toString()));
                    continue;
                }
                if (!(key instanceof List)) continue;
                result.add(this.createNodeKeyConstraint((String)entry.getKey(), (List)key));
            }
        }
        return result;
    }

    private boolean checkIfConstraintExists(String label, Map<String, List<Object>> constraints, AssertSchemaResult info) {
        if (constraints.containsKey(label)) {
            return constraints.get(label).removeIf(item -> {
                if (item instanceof String) {
                    return item.equals(info.key);
                }
                return info.keys.equals(item);
            });
        }
        return false;
    }

    private AssertSchemaResult createNodeKeyConstraint(String lbl, List<Object> keys) {
        String keyProperties = keys.stream().map(property -> String.format("n.`%s`", Util.sanitize(property.toString()))).collect(Collectors.joining(","));
        this.tx.execute(String.format("CREATE CONSTRAINT FOR (n:`%s`) REQUIRE (%s) IS NODE KEY", Util.sanitize(lbl), keyProperties)).close();
        List<String> keysToSting = keys.stream().map(Object::toString).collect(Collectors.toList());
        return new AssertSchemaResult((Object)lbl, keysToSting).unique().created();
    }

    private AssertSchemaResult createUniqueConstraint(Schema schema, String lbl, String key) {
        schema.constraintFor(Label.label((String)lbl)).assertPropertyIsUnique(key).create();
        return new AssertSchemaResult(lbl, key).unique().created();
    }

    public List<AssertSchemaResult> assertIndexes(Map<String, List<Object>> indexes0, boolean dropExisting) throws IllegalArgumentException {
        Schema schema = this.tx.schema();
        Map<String, List<Object>> indexes = this.copyMapOfObjects(indexes0);
        ArrayList<AssertSchemaResult> result = new ArrayList<AssertSchemaResult>(indexes.size());
        for (IndexDefinition indexDefinition : Util.getIndexes(this.tx)) {
            if (indexDefinition.getIndexType() == IndexType.LOOKUP || indexDefinition.isConstraintIndex() || indexDefinition.isMultiTokenIndex()) continue;
            Object label = this.getLabelForAssert(indexDefinition, indexDefinition.isNodeIndex());
            ArrayList<String> keys = new ArrayList<String>();
            indexDefinition.getPropertyKeys().forEach(keys::add);
            AssertSchemaResult info = new AssertSchemaResult(label, keys);
            boolean included = Optional.ofNullable(indexes.get(label)).map(lbl -> {
                if (keys.size() > 1) {
                    return lbl.remove(keys);
                }
                if (keys.size() == 1) {
                    return lbl.remove(keys.get(0));
                }
                throw new IllegalArgumentException("Label given with no keys.");
            }).orElse(false);
            if (dropExisting && !included) {
                indexDefinition.drop();
                info.dropped();
            }
            result.add(info);
        }
        for (Map.Entry entry : indexes.entrySet()) {
            for (Object key : (List)entry.getValue()) {
                if (key instanceof String) {
                    result.add(this.createSinglePropertyIndex(schema, (String)entry.getKey(), (String)key));
                    continue;
                }
                if (!(key instanceof List)) continue;
                result.add(this.createCompoundIndex((String)entry.getKey(), (List)key));
            }
        }
        return result;
    }

    private Object getLabelForAssert(IndexDefinition definition, boolean nodeIndex) {
        if (nodeIndex) {
            return definition.isMultiTokenIndex() ? Iterables.stream(definition.getLabels()).map(Label::name).collect(Collectors.toList()) : ((Label)Iterables.single(definition.getLabels())).name();
        }
        return definition.isMultiTokenIndex() ? Iterables.stream(definition.getRelationshipTypes()).map(RelationshipType::name).collect(Collectors.toList()) : ((RelationshipType)Iterables.single(definition.getRelationshipTypes())).name();
    }

    private AssertSchemaResult createSinglePropertyIndex(Schema schema, String lbl, String key) {
        schema.indexFor(Label.label((String)lbl)).on(key).create();
        return new AssertSchemaResult(lbl, key).created();
    }

    private AssertSchemaResult createCompoundIndex(String label, List<String> keys) {
        ArrayList backTickedKeys = new ArrayList();
        keys.forEach(key -> backTickedKeys.add(String.format("n.`%s`", Util.sanitize(key))));
        this.tx.execute(String.format("CREATE INDEX FOR (n:`%s`) ON (%s)", Util.sanitize(label), String.join((CharSequence)",", backTickedKeys))).close();
        return new AssertSchemaResult((Object)label, keys).created();
    }

    private Map<String, List<Object>> copyMapOfObjects(Map<String, List<Object>> input) {
        if (input == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>(input.size());
        input.forEach((k, v) -> result.put((String)k, new ArrayList(v)));
        return result;
    }

    private Boolean indexExists(String labelName, List<String> propertyNames) {
        Iterable<IndexDefinition> nodeIndexes = Util.getIndexes(this.tx, Label.label((String)labelName));
        return this.isIndexExistent(propertyNames, nodeIndexes);
    }

    private Boolean indexExistsForRelationship(String relName, List<String> propertyNames) {
        Iterable<IndexDefinition> relIndexes = Util.getIndexes(this.tx, RelationshipType.withName((String)relName));
        return this.isIndexExistent(propertyNames, relIndexes);
    }

    private Boolean isIndexExistent(List<String> propertyNames, Iterable<IndexDefinition> indexes) {
        for (IndexDefinition indexDefinition : indexes) {
            List properties = Iterables.asList(indexDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }

    private Boolean constraintsExists(String labelName, List<String> propertyNames) {
        Schema schema = this.tx.schema();
        for (ConstraintDefinition constraintDefinition : Iterables.asList(schema.getConstraints(Label.label((String)labelName)))) {
            List properties = Iterables.asList(constraintDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }

    private Boolean constraintsExistsForRelationship(String type, List<String> propertyNames) {
        Schema schema = this.tx.schema();
        for (ConstraintDefinition constraintDefinition : Iterables.asList(schema.getConstraints(RelationshipType.withName((String)type)))) {
            List properties = Iterables.asList(constraintDefinition.getPropertyKeys());
            if (!properties.equals(propertyNames)) continue;
            return true;
        }
        return false;
    }

    private Stream<IndexConstraintNodeInfo> indexesAndConstraintsForNode(Map<String, Object> config) {
        Schema schema = this.tx.schema();
        SchemaConfig schemaConfig = new SchemaConfig(config);
        Set<String> includeLabels = schemaConfig.getLabels();
        Set<String> excludeLabels = schemaConfig.getExcludeLabels();
        try (Statement ignore = this.ktx.acquireStatement();){
            Iterable constraintsIterator;
            Iterable<Object> indexesIterator;
            TokenRead tokenRead = this.ktx.tokenRead();
            SchemaRead schemaRead = this.ktx.schemaRead();
            Predicate<ConstraintDefinition> isNodeConstraint = constraintDefinition -> Util.isNodeCategory(constraintDefinition.getConstraintType());
            if (includeLabels.isEmpty()) {
                Iterator allIndex = schemaRead.indexesGetAll();
                indexesIterator = this.getIndexesFromSchema(allIndex, index -> index.schema().entityType().equals((Object)EntityType.NODE) && Arrays.stream(index.schema().getEntityTokenIds()).noneMatch(id -> {
                    try {
                        return excludeLabels.contains(tokenRead.nodeLabelName(id));
                    }
                    catch (LabelNotFoundKernelException e) {
                        return false;
                    }
                }));
                Iterable allConstraints = schema.getConstraints();
                constraintsIterator = StreamSupport.stream(allConstraints.spliterator(), false).filter(isNodeConstraint).filter(constraint -> !excludeLabels.contains(constraint.getLabel().name())).collect(Collectors.toList());
            } else {
                constraintsIterator = includeLabels.stream().filter(label -> !excludeLabels.contains(label) && tokenRead.nodeLabel(label) != -1).flatMap(label -> {
                    Iterable constraintsForType = schema.getConstraints(Label.label((String)label));
                    return StreamSupport.stream(constraintsForType.spliterator(), false).filter(isNodeConstraint);
                }).collect(Collectors.toList());
                indexesIterator = includeLabels.stream().filter(label -> !excludeLabels.contains(label) && tokenRead.nodeLabel(label) != -1).flatMap(label -> {
                    Iterable indexesForLabel = () -> schemaRead.indexesGetForLabel(tokenRead.nodeLabel(label));
                    return StreamSupport.stream(indexesForLabel.spliterator(), false);
                }).collect(Collectors.toList());
            }
            Stream<IndexConstraintNodeInfo> constraintNodeInfoStream = StreamSupport.stream(constraintsIterator.spliterator(), false).map(constraintDescriptor -> this.nodeInfoFromConstraintDefinition((ConstraintDefinition)constraintDescriptor, (TokenNameLookup)tokenRead)).sorted(Comparator.comparing(i -> i.label.toString()));
            Stream<IndexConstraintNodeInfo> indexNodeInfoStream = StreamSupport.stream(indexesIterator.spliterator(), false).map(indexDescriptor -> this.nodeInfoFromIndexDefinition((IndexDescriptor)indexDescriptor, schemaRead, (TokenNameLookup)tokenRead)).sorted(Comparator.comparing(i -> i.label.toString()));
            Stream<IndexConstraintNodeInfo> stream = Stream.of(constraintNodeInfoStream, indexNodeInfoStream).flatMap(e -> e);
            return stream;
        }
    }

    private List<IndexDescriptor> getIndexesFromSchema(Iterator<IndexDescriptor> allIndex, Predicate<IndexDescriptor> indexDescriptorPredicate) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(allIndex, 16), false).filter(indexDescriptorPredicate).collect(Collectors.toList());
    }

    private Stream<IndexConstraintRelationshipInfo> indexesAndConstraintsForRelationships(Map<String, Object> config) {
        Schema schema = this.tx.schema();
        SchemaConfig schemaConfig = new SchemaConfig(config);
        Set<String> includeRelationships = schemaConfig.getRelationships();
        Set<String> excludeRelationships = schemaConfig.getExcludeRelationships();
        try (Statement ignore = this.ktx.acquireStatement();){
            Iterable<Object> indexesIterator;
            Iterable constraintsIterator;
            TokenRead tokenRead = this.ktx.tokenRead();
            SchemaRead schemaRead = this.ktx.schemaRead();
            Predicate<ConstraintDefinition> isRelConstraint = constraintDefinition -> Util.isRelationshipCategory(constraintDefinition.getConstraintType());
            if (!includeRelationships.isEmpty()) {
                constraintsIterator = includeRelationships.stream().filter(type -> !excludeRelationships.contains(type) && tokenRead.relationshipType(type) != -1).flatMap(type -> {
                    Iterable constraintsForType = schema.getConstraints(RelationshipType.withName((String)type));
                    return StreamSupport.stream(constraintsForType.spliterator(), false).filter(isRelConstraint);
                }).collect(Collectors.toList());
                indexesIterator = includeRelationships.stream().filter(type -> !excludeRelationships.contains(type) && tokenRead.relationshipType(type) != -1).flatMap(type -> {
                    Iterable indexesForRelType = () -> schemaRead.indexesGetForRelationshipType(tokenRead.relationshipType(type));
                    return StreamSupport.stream(indexesForRelType.spliterator(), false);
                }).collect(Collectors.toList());
            } else {
                Iterable allConstraints = schema.getConstraints();
                constraintsIterator = StreamSupport.stream(allConstraints.spliterator(), false).filter(isRelConstraint).filter(constraint -> !excludeRelationships.contains(constraint.getRelationshipType().name())).collect(Collectors.toList());
                Iterator allIndex = schemaRead.indexesGetAll();
                indexesIterator = this.getIndexesFromSchema(allIndex, index -> index.schema().entityType().equals((Object)EntityType.RELATIONSHIP) && Arrays.stream(index.schema().getEntityTokenIds()).noneMatch(id -> excludeRelationships.contains(tokenRead.relationshipTypeGetName(id))));
            }
            Stream<IndexConstraintRelationshipInfo> constraintRelationshipInfoStream = StreamSupport.stream(constraintsIterator.spliterator(), false).map(this::relationshipInfoFromConstraintDefinition);
            Stream<IndexConstraintRelationshipInfo> indexRelationshipInfoStream = StreamSupport.stream(indexesIterator.spliterator(), false).map(index -> this.relationshipInfoFromIndexDescription((IndexDescriptor)index, (TokenNameLookup)tokenRead, schemaRead));
            Stream<IndexConstraintRelationshipInfo> stream = Stream.of(constraintRelationshipInfoStream, indexRelationshipInfoStream).flatMap(e -> e);
            return stream;
        }
    }

    private IndexConstraintNodeInfo nodeInfoFromConstraintDefinition(ConstraintDefinition constraintDefinition, TokenNameLookup tokens) {
        String labelName = constraintDefinition.getLabel().name();
        List<String> properties = Iterables.asList(constraintDefinition.getPropertyKeys());
        return new IndexConstraintNodeInfo(String.format(":%s(%s)", labelName, StringUtils.join(properties, ",")), labelName, properties, "", constraintDefinition.getConstraintType().name(), "NO FAILURE", 0.0f, 0L, 0.0, this.ktx.schemaRead().constraintGetForName(constraintDefinition.getName()).userDescription(tokens));
    }

    private IndexConstraintNodeInfo nodeInfoFromIndexDefinition(IndexDescriptor indexDescriptor, SchemaRead schemaRead, TokenNameLookup tokens) {
        List labels;
        int[] labelIds = indexDescriptor.schema().getEntityTokenIds();
        int length = labelIds.length;
        Object labelName = length == 0 ? "<any-labels>" : ((labels = IntStream.of(labelIds).mapToObj(arg_0 -> ((TokenNameLookup)tokens).labelGetName(arg_0)).sorted().collect(Collectors.toList())).size() > 1 ? labels : labels.get(0));
        List<String> properties = IntStream.of(indexDescriptor.schema().getPropertyIds()).mapToObj(arg_0 -> ((TokenNameLookup)tokens).propertyKeyGetName(arg_0)).collect(Collectors.toList());
        String schemaInfoName = this.getSchemaInfoName(labelName, properties);
        String userDescription = indexDescriptor.userDescription(tokens);
        try {
            return new IndexConstraintNodeInfo(schemaInfoName, labelName, properties, schemaRead.indexGetState(indexDescriptor).toString(), Schemas.getIndexType(indexDescriptor), schemaRead.indexGetState(indexDescriptor).equals((Object)InternalIndexState.FAILED) ? schemaRead.indexGetFailure(indexDescriptor) : "NO FAILURE", this.getPopulationProgress(indexDescriptor, schemaRead), schemaRead.indexSize(indexDescriptor), schemaRead.indexUniqueValuesSelectivity(indexDescriptor), userDescription);
        }
        catch (IndexNotFoundKernelException e) {
            return new IndexConstraintNodeInfo(schemaInfoName, labelName, properties, IDX_NOT_FOUND, Schemas.getIndexType(indexDescriptor), IDX_NOT_FOUND, 0.0f, 0L, 0.0, userDescription);
        }
    }

    private IndexConstraintRelationshipInfo relationshipInfoFromIndexDescription(IndexDescriptor indexDescriptor, TokenNameLookup tokens, SchemaRead schemaRead) {
        String indexStatus;
        List rels;
        int[] relIds = indexDescriptor.schema().getEntityTokenIds();
        int length = relIds.length;
        Object relName = length == 0 ? "<any-types>" : ((rels = IntStream.of(relIds).mapToObj(arg_0 -> ((TokenNameLookup)tokens).relationshipTypeGetName(arg_0)).sorted().collect(Collectors.toList())).size() > 1 ? rels : rels.get(0));
        List<String> properties = Arrays.stream(indexDescriptor.schema().getPropertyIds()).mapToObj(arg_0 -> ((TokenNameLookup)tokens).propertyKeyGetName(arg_0)).collect(Collectors.toList());
        String name = this.getSchemaInfoName(relName, properties);
        String schemaType = Schemas.getIndexType(indexDescriptor);
        try {
            indexStatus = schemaRead.indexGetState(indexDescriptor).toString();
        }
        catch (IndexNotFoundKernelException e) {
            indexStatus = IDX_NOT_FOUND;
        }
        return new IndexConstraintRelationshipInfo(name, schemaType, properties, indexStatus, relName);
    }

    private IndexConstraintRelationshipInfo relationshipInfoFromConstraintDefinition(ConstraintDefinition constraintDefinition) {
        return new IndexConstraintRelationshipInfo(String.format("CONSTRAINT %s", constraintDefinition.toString()), constraintDefinition.getConstraintType().name(), Iterables.asList(constraintDefinition.getPropertyKeys()), "", constraintDefinition.getRelationshipType().name());
    }

    private static String getIndexType(IndexDescriptor indexDescriptor) {
        return indexDescriptor.getIndexType().name();
    }

    private String getSchemaInfoName(Object labelOrType, List<String> properties) {
        String labelOrTypeAsString = labelOrType instanceof String ? (String)labelOrType : StringUtils.join(labelOrType, ",");
        return String.format(":%s(%s)", labelOrTypeAsString, StringUtils.join(properties, ","));
    }

    private long getPopulationProgress(IndexDescriptor indexDescriptor, SchemaRead schemaRead) throws IndexNotFoundKernelException {
        PopulationProgress populationProgress = schemaRead.indexGetPopulationProgress(indexDescriptor);
        long populationTotal = populationProgress.getTotal();
        if (populationTotal == 0L) {
            return 0L;
        }
        return populationProgress.getCompleted() / populationTotal * 100L;
    }
}

