/*
 * Decompiled with CFR 0.152.
 */
package apoc.search;

import apoc.result.NodeResult;
import apoc.util.Util;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;

public class ParallelNodeSearch {
    private static final Set<String> OPERATORS = new HashSet<String>(Arrays.asList("exact", "starts with", "ends with", "contains", "<", ">", "=", "<>", "<=", ">=", "=~"));
    @Context
    public GraphDatabaseService api;
    @Context
    public Log log;
    @Context
    public Transaction tx;

    @NotThreadSafe
    @Procedure(value="apoc.search.nodeAllReduced")
    @Description(value="Returns a reduced representation of the `NODE` values found after a parallel search over multiple indexes.\nThe reduced `NODE` values representation includes: node id, node labels, and the searched properties.")
    public Stream<NodeReducedResult> multiSearchAll(@Name(value="labelPropertyMap") Object labelProperties, @Name(value="operator") String operator, @Name(value="value") Object value) throws Exception {
        return this.createWorkersFromValidInput(labelProperties, operator, value).flatMap(QueryWorker::queryForData);
    }

    private NodeReducedResult merge(NodeReducedResult a, NodeReducedResult b) {
        a.values.putAll(b.values);
        for (String label : b.labels) {
            if (a.labels.contains(label)) continue;
            a.labels.add(label);
        }
        return a;
    }

    @NotThreadSafe
    @Procedure(value="apoc.search.nodeReduced")
    @Description(value="Returns a reduced representation of the distinct `NODE` values found after a parallel search over multiple indexes.\nThe reduced `NODE` values representation includes: node id, node labels, and the searched properties.")
    public Stream<NodeReducedResult> multiSearch(@Name(value="labelPropertyMap") Object labelProperties, @Name(value="operator") String operator, @Name(value="value") String value) throws Exception {
        return this.createWorkersFromValidInput(labelProperties, operator, value).flatMap(QueryWorker::queryForData).collect(Collectors.groupingBy(res -> res.id, Collectors.reducing(this::merge))).values().stream().filter(Optional::isPresent).map(Optional::get);
    }

    @NotThreadSafe
    @Procedure(value="apoc.search.multiSearchReduced")
    @Description(value="Returns a reduced representation of the `NODE` values found after a parallel search over multiple indexes.\nThe reduced `NODE` values representation includes: node id, node labels, and the searched properties.")
    public Stream<NodeReducedResult> multiSearchOld(@Name(value="labelPropertyMap") Object labelProperties, @Name(value="operator") String operator, @Name(value="value") String value) throws Exception {
        return this.createWorkersFromValidInput(labelProperties, operator, value).flatMap(QueryWorker::queryForData).collect(Collectors.groupingBy(res -> res.id)).values().stream().map(list -> list.stream().reduce(this::merge)).filter(Optional::isPresent).map(Optional::get);
    }

    @NotThreadSafe
    @Procedure(value="apoc.search.nodeAll")
    @Description(value="Returns all the `NODE` values found after a parallel search over multiple indexes.")
    public Stream<NodeResult> multiSearchNodeAll(@Name(value="labelPropertyMap") Object labelProperties, @Name(value="operator") String operator, @Name(value="value") String value) throws Exception {
        long[] ids = this.createWorkersFromValidInput(labelProperties, operator, value).flatMapToLong(w -> w.queryForNodeId().mapToLong(i -> i)).toArray();
        return Arrays.stream(ids).mapToObj(id -> new NodeResult(this.tx.getNodeById(id)));
    }

    @NotThreadSafe
    @Procedure(value="apoc.search.node")
    @Description(value="Returns all the distinct `NODE` values found after a parallel search over multiple indexes.")
    public Stream<NodeResult> multiSearchNode(@Name(value="labelPropertyMap") Object labelProperties, @Name(value="operator") String operator, @Name(value="value") String value) throws Exception {
        long[] ids = this.createWorkersFromValidInput(labelProperties, operator, value).flatMapToLong(w -> w.queryForNodeId().mapToLong(i -> i)).toArray();
        return Arrays.stream(ids).boxed().distinct().map(id -> new NodeResult(this.tx.getNodeById(id.longValue())));
    }

    private Stream<QueryWorker> createWorkersFromValidInput(Object labelPropertiesInput, String operatorInput, Object value) throws Exception {
        String operator;
        String operatorNormalized = operatorInput.trim().toLowerCase();
        if (operatorInput == null || !OPERATORS.contains(operatorNormalized)) {
            throw new Exception(String.format("operator `%s` invalid, it must have one of the following values (case insensitive): %s.", operatorInput, OPERATORS));
        }
        String string = operator = operatorNormalized.equals("exact") ? "=" : operatorNormalized;
        if (labelPropertiesInput == null || labelPropertiesInput instanceof String && labelPropertiesInput.toString().trim().isEmpty()) {
            throw new Exception("LabelProperties cannot be empty. example { Person: [\"fullName\",\"lastName\"],Company:\"name\", Event : \"Description\"}");
        }
        Map<String, Object> labelProperties = labelPropertiesInput instanceof Map ? (Map<String, Object>)labelPropertiesInput : Util.readMap(labelPropertiesInput.toString());
        return labelProperties.entrySet().parallelStream().flatMap(e -> {
            String label = (String)e.getKey();
            Object properties = e.getValue();
            if (properties instanceof String) {
                return Stream.of(new QueryWorker(this.api, label, (String)properties, operator, value, this.log));
            }
            if (properties instanceof List) {
                return ((List)properties).stream().map(prop -> new QueryWorker(this.api, label, (String)prop, operator, value, this.log));
            }
            throw new RuntimeException("Invalid type for properties " + properties + ": " + (Serializable)(properties == null ? "null" : properties.getClass()));
        });
    }

    public static class NodeReducedResult {
        public final long id;
        public final List<String> labels;
        public final Map<String, Object> values;

        public NodeReducedResult(long id, List<String> labels, Map<String, Object> val) {
            this.labels = labels;
            this.id = id;
            this.values = val;
        }
    }

    public static class QueryWorker {
        private GraphDatabaseService db;
        private String label;
        private String prop;
        private String operator;
        Object value;
        private Log log;

        public QueryWorker(GraphDatabaseService db, String label, String prop, String operator, Object value, Log log) {
            this.db = db;
            this.label = label;
            this.prop = prop;
            this.value = value;
            this.operator = operator;
            this.log = log;
        }

        public Stream<NodeReducedResult> queryForData() {
            List<String> labels = Collections.singletonList(this.label);
            String query = String.format("match (n:`%s`) where n.`%s` %s $value return id(n) as id,  n.`%s` as value", this.label, this.prop, this.operator, this.prop);
            return this.queryForNode(query, row -> new NodeReducedResult((Long)row.get("id"), labels, Collections.singletonMap(this.prop, row.get("value")))).stream();
        }

        public Stream<Long> queryForNodeId() {
            String query = String.format("match (n:`%s`) where n.`%s` %s $value return id(n) AS id", this.label, this.prop, this.operator);
            return this.queryForNode(query, row -> (long)((Long)row.get("id"))).stream();
        }

        /*
         * Loose catch block
         */
        public <T> List<T> queryForNode(String query, Function<Map<String, Object>, T> transformer) {
            long start = System.currentTimeMillis();
            try (Transaction tx = this.db.beginTx();){
                List list;
                Result nodes;
                block17: {
                    nodes = tx.execute(query, Collections.singletonMap("value", this.value));
                    list = nodes.stream().map(transformer).collect(Collectors.toList());
                    if (nodes == null) break block17;
                    nodes.close();
                }
                tx.commit();
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("(%s) search on label:%s and prop:%s took %d", Thread.currentThread(), this.label, this.prop, System.currentTimeMillis() - start));
                }
                return list;
                {
                    catch (Throwable throwable) {
                        try {
                            if (nodes != null) {
                                try {
                                    nodes.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            tx.commit();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(String.format("(%s) search on label:%s and prop:%s took %d", Thread.currentThread(), this.label, this.prop, System.currentTimeMillis() - start));
                            }
                            throw throwable3;
                        }
                    }
                }
            }
        }
    }
}

