/*
 * Decompiled with CFR 0.152.
 */
package apoc.stats;

import apoc.Pools;
import apoc.path.RelationshipTypeAndDirections;
import apoc.stats.DegreeUtil;
import apoc.util.kernel.MultiThreadedGlobalGraphOperations;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.HdrHistogram.AtomicHistogram;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.token.api.NamedToken;

public class DegreeDistribution {
    private static final int BATCHSIZE = 10000;
    @Context
    public GraphDatabaseAPI db;
    @Context
    public KernelTransaction tx;
    @Context
    public Pools pools;

    @NotThreadSafe
    @Procedure(value="apoc.stats.degrees")
    @Description(value="Returns the percentile groupings of the degrees on the `NODE` values connected by the given `RELATIONSHIP` types.")
    public Stream<DegreeStats.Result> degrees(@Name(value="relTypes", defaultValue="") String types) {
        List<DegreeStats> stats = this.prepareStats(types);
        MultiThreadedGlobalGraphOperations.forAllNodes(this.db, this.pools.getDefaultExecutorService(), 10000, nodeCursor -> stats.forEach(s -> s.computeDegree((NodeCursor)nodeCursor)));
        return stats.stream().map(DegreeStats::done);
    }

    public List<DegreeStats> prepareStats(String types) {
        ArrayList<DegreeStats> stats = new ArrayList<DegreeStats>();
        TokenRead tokenRead = this.tx.tokenRead();
        Read read = this.tx.dataRead();
        if ("*".equals(types)) {
            Iterator tokens = tokenRead.relationshipTypesGetAllTokens();
            while (tokens.hasNext()) {
                NamedToken token = (NamedToken)tokens.next();
                long total = read.countsForRelationship(-1, token.id(), -1);
                stats.add(new DegreeStats(token.name(), token.id(), Direction.OUTGOING, total));
                stats.add(new DegreeStats(token.name(), token.id(), Direction.INCOMING, total));
            }
            return stats;
        }
        List<Pair<RelationshipType, Direction>> pairs = RelationshipTypeAndDirections.parse(types);
        for (Pair<RelationshipType, Direction> pair : pairs) {
            String typeName = pair.getLeft() == null ? null : pair.getLeft().name();
            int type = typeName == null ? -1 : tokenRead.relationshipType(typeName);
            long total = read.countsForRelationship(-1, type, -1);
            stats.add(new DegreeStats(typeName, type, pair.getRight(), total));
        }
        return stats;
    }

    public static class DegreeStats {
        public final String typeName;
        public final long total;
        private final int type;
        private final Direction direction;
        private transient AtomicHistogram histogram;

        public void computeDegree(NodeCursor nodeCursor) {
            int degree = DegreeUtil.degree(nodeCursor, this.type, this.direction);
            this.record(degree);
        }

        public DegreeStats(String typeName, int type, Direction direction, long total) {
            this.typeName = typeName;
            this.type = type;
            this.direction = direction;
            this.total = total;
            this.histogram = new AtomicHistogram(total, 3);
        }

        public void record(long value) {
            this.histogram.recordValue(value);
        }

        public Result done() {
            Result result = new Result();
            result.type = this.typeName;
            result.direction = this.direction.name();
            result.total = this.total;
            result.max = this.histogram.getMaxValue();
            result.min = this.histogram.getMinValue();
            result.mean = this.histogram.getMean();
            result.p50 = this.histogram.getValueAtPercentile(50.0);
            result.p75 = this.histogram.getValueAtPercentile(75.0);
            result.p90 = this.histogram.getValueAtPercentile(90.0);
            result.p95 = this.histogram.getValueAtPercentile(95.0);
            result.p99 = this.histogram.getValueAtPercentile(99.0);
            result.p999 = this.histogram.getValueAtPercentile(99.9);
            this.histogram.reset();
            this.histogram = null;
            return result;
        }

        public static class Result {
            public String type;
            public String direction;
            public long total;
            public long p50;
            public long p75;
            public long p90;
            public long p95;
            public long p99;
            public long p999;
            public long max;
            public long min;
            public double mean;
        }
    }
}

