/*
 * Decompiled with CFR 0.152.
 */
package apoc.trigger;

import apoc.ApocConfig;
import apoc.Pools;
import apoc.SystemLabels;
import apoc.SystemPropertyKeys;
import apoc.trigger.TriggerMetadata;
import apoc.util.MapUtil;
import apoc.util.Util;
import apoc.util.collection.Iterators;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class TriggerHandler
extends LifecycleAdapter
implements TransactionEventListener<Void> {
    private static final Map<String, Object> TRIGGER_META = Map.of("apoc.trigger", true);
    public static final String TRIGGER_REFRESH = "apoc.trigger.refresh";
    private final AtomicReference<Map<String, Map<String, Object>>> triggersSnapshot = new AtomicReference(Map.of());
    private final Log log;
    private final GraphDatabaseService db;
    private final DatabaseManagementService databaseManagementService;
    private final ApocConfig apocConfig;
    private final Pools pools;
    private final JobScheduler jobScheduler;
    private volatile long lastUpdate;
    private JobHandle restoreTriggerHandler;
    private final AtomicBoolean registeredWithKernel = new AtomicBoolean(false);

    public TriggerHandler(GraphDatabaseService db, DatabaseManagementService databaseManagementService, ApocConfig apocConfig, Log log, Pools pools, JobScheduler jobScheduler) {
        this.db = db;
        this.databaseManagementService = databaseManagementService;
        this.apocConfig = apocConfig;
        this.log = log;
        this.pools = pools;
        this.jobScheduler = jobScheduler;
    }

    public void updateCache() {
        try {
            this.doUpdateCache();
        }
        catch (Exception e) {
            this.log.error("Failed to update apoc triggers: " + e.getMessage(), (Throwable)e);
        }
    }

    private void doUpdateCache() {
        for (int attempt = 5; attempt > 0; --attempt) {
            Map<String, Map<String, Object>> newTriggers;
            long start = System.currentTimeMillis();
            Map<String, Map<String, Object>> oldTriggers = this.triggersSnapshot.get();
            if (!this.triggersSnapshot.compareAndSet(oldTriggers, newTriggers = this.getTriggers())) continue;
            this.lastUpdate = start;
            this.reconcileKernelRegistration();
            break;
        }
    }

    private Map<String, Map<String, Object>> getTriggers() {
        return this.withSystemDb(tx -> {
            String dbName = this.db.databaseName();
            return tx.findNodes((Label)SystemLabels.ApocTrigger, SystemPropertyKeys.database.name(), (Object)dbName).stream().collect(Collectors.toUnmodifiableMap(node -> (String)node.getProperty(SystemPropertyKeys.name.name()), node -> MapUtil.map("statement", node.getProperty(SystemPropertyKeys.statement.name()), "selector", Util.fromJson((String)node.getProperty(SystemPropertyKeys.selector.name()), Map.class), "params", Util.fromJson((String)node.getProperty(SystemPropertyKeys.params.name()), Map.class), "paused", node.getProperty(SystemPropertyKeys.paused.name()))));
        });
    }

    private void reconcileKernelRegistration() {
        if (!this.triggersSnapshot.get().isEmpty()) {
            if (this.registeredWithKernel.compareAndSet(false, true)) {
                this.databaseManagementService.registerTransactionEventListener(this.db.databaseName(), (TransactionEventListener)this);
            }
        } else if (this.registeredWithKernel.compareAndSet(true, false)) {
            this.databaseManagementService.unregisterTransactionEventListener(this.db.databaseName(), (TransactionEventListener)this);
        }
    }

    public Map<String, Object> add(String name, String statement, Map<String, Object> selector, Map<String, Object> params) {
        Map<String, Object> previous = this.triggersSnapshot.get().get(name);
        this.withSystemDb(tx -> {
            Node node = Util.mergeNode(tx, SystemLabels.ApocTrigger, null, Pair.of(SystemPropertyKeys.database.name(), this.db.databaseName()), Pair.of(SystemPropertyKeys.name.name(), name));
            node.setProperty(SystemPropertyKeys.statement.name(), (Object)statement);
            node.setProperty(SystemPropertyKeys.selector.name(), (Object)Util.toJson(selector));
            node.setProperty(SystemPropertyKeys.params.name(), (Object)Util.toJson(params));
            node.setProperty(SystemPropertyKeys.paused.name(), (Object)false);
            this.setLastUpdate((Transaction)tx);
            return null;
        });
        this.updateCache();
        return previous;
    }

    public Map<String, Object> remove(String name) {
        Map<String, Object> previous = this.triggersSnapshot.get().get(name);
        this.withSystemDb(tx -> {
            tx.findNodes((Label)SystemLabels.ApocTrigger, SystemPropertyKeys.database.name(), (Object)this.db.databaseName(), SystemPropertyKeys.name.name(), (Object)name).forEachRemaining(node -> node.delete());
            this.setLastUpdate((Transaction)tx);
            return null;
        });
        this.updateCache();
        return previous;
    }

    public Map<String, Object> updatePaused(String name, boolean paused) {
        this.withSystemDb(tx -> {
            tx.findNodes((Label)SystemLabels.ApocTrigger, SystemPropertyKeys.database.name(), (Object)this.db.databaseName(), SystemPropertyKeys.name.name(), (Object)name).forEachRemaining(node -> node.setProperty(SystemPropertyKeys.paused.name(), (Object)paused));
            this.setLastUpdate((Transaction)tx);
            return null;
        });
        this.updateCache();
        return this.triggersSnapshot.get().get(name);
    }

    public Map<String, Map<String, Object>> removeAll() {
        Map<String, Map<String, Object>> previous = this.triggersSnapshot.get();
        this.withSystemDb(tx -> {
            tx.findNodes((Label)SystemLabels.ApocTrigger, SystemPropertyKeys.database.name(), (Object)this.db.databaseName()).forEachRemaining(Node::delete);
            this.setLastUpdate((Transaction)tx);
            return null;
        });
        this.updateCache();
        return previous;
    }

    public Map<String, Map<String, Object>> list() {
        return this.triggersSnapshot.get();
    }

    public Void beforeCommit(TransactionData txData, Transaction transaction, GraphDatabaseService databaseService) {
        if (this.hasPhase(Phase.before)) {
            this.executeTriggers(transaction, txData, Phase.before);
        }
        return null;
    }

    public void afterCommit(TransactionData txData, Void state, GraphDatabaseService databaseService) {
        if (TriggerHandler.isTransactionCreatedByTrigger(txData)) {
            return;
        }
        if (this.hasPhase(Phase.after)) {
            try (Transaction tx = this.db.beginTx();){
                TriggerHandler.setTriggerMetadata(tx);
                this.executeTriggers(tx, txData, Phase.after);
                tx.commit();
            }
        }
        this.afterAsync(txData);
    }

    private static boolean isTransactionCreatedByTrigger(TransactionData txData) {
        Map metaData = txData.metaData();
        return metaData.equals(TRIGGER_META);
    }

    private void afterAsync(TransactionData txData) {
        if (this.hasPhase(Phase.afterAsync)) {
            TriggerMetadata triggerMetadata = TriggerMetadata.from(txData, true);
            Util.inTxFuture(this.pools.getDefaultExecutorService(), this.db, inner -> {
                TriggerHandler.setTriggerMetadata(inner);
                this.executeTriggers((Transaction)inner, triggerMetadata.rebind((Transaction)inner), Phase.afterAsync);
                return null;
            });
        }
    }

    private static void setTriggerMetadata(Transaction tx) {
        tx.execute("CALL tx.setMetaData($data)", Map.of("data", TRIGGER_META));
    }

    public void afterRollback(TransactionData txData, Void state, GraphDatabaseService databaseService) {
        if (this.hasPhase(Phase.rollback)) {
            try (Transaction tx = this.db.beginTx();){
                this.executeTriggers(tx, txData, Phase.rollback);
                tx.commit();
            }
        }
    }

    private boolean hasPhase(Phase phase) {
        return this.triggersSnapshot.get().values().stream().map(data -> (Map)data.get("selector")).anyMatch(selector -> this.when((Map<String, Object>)selector, phase));
    }

    private void executeTriggers(Transaction tx, TransactionData txData, Phase phase) {
        this.executeTriggers(tx, TriggerMetadata.from(txData, false), phase);
    }

    private void executeTriggers(Transaction tx, TriggerMetadata triggerMetadata, Phase phase) {
        LinkedHashMap exceptions = new LinkedHashMap();
        this.triggersSnapshot.get().forEach((name, data) -> {
            Map<String, Object> params = triggerMetadata.toMap();
            if (data.get("params") != null) {
                params.putAll((Map)data.get("params"));
            }
            Map selector = (Map)data.get("selector");
            if (!((Boolean)data.get("paused")).booleanValue() && this.when(selector, phase)) {
                try {
                    params.put("trigger", name);
                    Result result = tx.execute((String)data.get("statement"), params);
                    Iterators.count(result);
                }
                catch (Exception e) {
                    this.log.warn("Error executing trigger " + name + " in phase " + phase, (Throwable)e);
                    exceptions.put(name, e.getMessage());
                }
            }
        });
        if (!exceptions.isEmpty()) {
            throw new RuntimeException("Error executing triggers " + ((Object)exceptions).toString());
        }
    }

    private boolean when(Map<String, Object> selector, Phase phase) {
        if (selector == null) {
            return phase == Phase.before;
        }
        return Phase.valueOf(selector.getOrDefault("phase", "before").toString()) == phase;
    }

    public void start() {
        this.updateCache();
        long refreshInterval = ApocConfig.apocConfig().getInt(TRIGGER_REFRESH, 60000);
        this.restoreTriggerHandler = this.jobScheduler.scheduleRecurring(Group.STORAGE_MAINTENANCE, () -> {
            if (this.getLastUpdate() >= this.lastUpdate) {
                this.updateCache();
            }
        }, refreshInterval, refreshInterval, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.registeredWithKernel.compareAndSet(true, false)) {
            this.databaseManagementService.unregisterTransactionEventListener(this.db.databaseName(), (TransactionEventListener)this);
        }
        if (this.restoreTriggerHandler != null) {
            this.restoreTriggerHandler.cancel();
        }
    }

    private <T> T withSystemDb(Function<Transaction, T> action) {
        int timeout = 500;
        int upperTimeout = 43200000;
        return (T)Util.withBackOffRetries(() -> {
            Transaction tx = this.apocConfig.getSystemDb().beginTx();
            Object result = action.apply(tx);
            tx.commit();
            return result;
        }, timeout, upperTimeout, this.log);
    }

    private long getLastUpdate() {
        return this.withSystemDb(tx -> {
            Node node = tx.findNode((Label)SystemLabels.ApocTriggerMeta, SystemPropertyKeys.database.name(), (Object)this.db.databaseName());
            return node == null ? 0L : (Long)node.getProperty(SystemPropertyKeys.lastUpdated.name());
        });
    }

    private void setLastUpdate(Transaction tx) {
        Node node = tx.findNode((Label)SystemLabels.ApocTriggerMeta, SystemPropertyKeys.database.name(), (Object)this.db.databaseName());
        if (node == null) {
            node = tx.createNode(new Label[]{SystemLabels.ApocTriggerMeta});
            node.setProperty(SystemPropertyKeys.database.name(), (Object)this.db.databaseName());
        }
        node.setProperty(SystemPropertyKeys.lastUpdated.name(), (Object)System.currentTimeMillis());
    }

    private static enum Phase {
        before,
        after,
        rollback,
        afterAsync;

    }
}

