/*
 * Decompiled with CFR 0.152.
 */
package apoc.trigger;

import apoc.trigger.TriggerHandlerNewProcedures;
import apoc.trigger.TriggerInfo;
import apoc.util.Util;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TriggerNewProcedures {
    public static final String NON_SYS_DB_ERROR = "The procedure should be executed against a system database.";
    public static final String TRIGGER_NOT_ROUTED_ERROR = "No write operations are allowed directly on this database. Writes must pass through the leader. The role of this server is: FOLLOWER";
    public static final String TRIGGER_BAD_TARGET_ERROR = "Triggers can only be installed on user databases.";
    public static final String DB_NOT_FOUND_ERROR = "The user database with name '%s' does not exist";
    @Context
    public GraphDatabaseAPI db;
    @Context
    public Transaction tx;

    private void checkInSystemWriter() {
        TriggerHandlerNewProcedures.checkEnabled();
        if (!this.db.databaseName().equals("system") || !Util.isWriteableInstance(this.db)) {
            throw new RuntimeException(TRIGGER_NOT_ROUTED_ERROR);
        }
    }

    private void checkInSystem() {
        TriggerHandlerNewProcedures.checkEnabled();
        if (!this.db.databaseName().equals("system")) {
            throw new RuntimeException(NON_SYS_DB_ERROR);
        }
    }

    private void checkTargetDatabase(String databaseName) {
        Set databases = this.tx.execute("SHOW DATABASES", Collections.emptyMap()).columnAs("name").stream().collect(Collectors.toSet());
        if (!databases.contains(databaseName)) {
            throw new RuntimeException(String.format(DB_NOT_FOUND_ERROR, databaseName));
        }
        if (databaseName.equals("system")) {
            throw new RuntimeException(TRIGGER_BAD_TARGET_ERROR);
        }
    }

    @SystemProcedure
    @Admin
    @Procedure(name="apoc.trigger.install", mode=Mode.WRITE)
    @Description(value="Eventually adds a trigger for a given database which is invoked when a successful transaction occurs.")
    public Stream<TriggerInfo> install(@Name(value="databaseName") String databaseName, @Name(value="name") String name, @Name(value="statement") String statement, @Name(value="selector") Map<String, Object> selector, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        this.checkInSystemWriter();
        this.checkTargetDatabase(databaseName);
        Map params = config.getOrDefault("params", Collections.emptyMap());
        return this.withUpdatingTransaction(databaseName, tx -> Stream.of(TriggerHandlerNewProcedures.install(databaseName, name, statement, selector, params, tx)));
    }

    @SystemProcedure
    @Admin
    @Procedure(name="apoc.trigger.drop", mode=Mode.WRITE)
    @Description(value="Eventually removes the given trigger.")
    public Stream<TriggerInfo> drop(@Name(value="databaseName") String databaseName, @Name(value="name") String name) {
        this.checkInSystemWriter();
        return this.withUpdatingTransaction(databaseName, tx -> Stream.ofNullable(TriggerHandlerNewProcedures.drop(databaseName, name, tx)));
    }

    @SystemProcedure
    @Admin
    @Procedure(name="apoc.trigger.dropAll", mode=Mode.WRITE)
    @Description(value="Eventually removes all triggers from the given database.")
    public Stream<TriggerInfo> dropAll(@Name(value="databaseName") String databaseName) {
        this.checkInSystemWriter();
        return this.withUpdatingTransaction(databaseName, tx -> TriggerHandlerNewProcedures.dropAll(databaseName, tx).stream().sorted(Comparator.comparing(i -> i.name)));
    }

    @SystemProcedure
    @Admin
    @Procedure(name="apoc.trigger.stop", mode=Mode.WRITE)
    @Description(value="Eventually stops the given trigger.")
    public Stream<TriggerInfo> stop(@Name(value="databaseName") String databaseName, @Name(value="name") String name) {
        this.checkInSystemWriter();
        return this.withUpdatingTransaction(databaseName, tx -> {
            TriggerInfo triggerInfo = TriggerHandlerNewProcedures.updatePaused(databaseName, name, true, tx);
            return Stream.ofNullable(triggerInfo);
        });
    }

    @SystemProcedure
    @Admin
    @Procedure(name="apoc.trigger.start", mode=Mode.WRITE)
    @Description(value="Eventually restarts the given paused trigger.")
    public Stream<TriggerInfo> start(@Name(value="databaseName") String databaseName, @Name(value="name") String name) {
        this.checkInSystemWriter();
        return this.withUpdatingTransaction(databaseName, tx -> {
            TriggerInfo triggerInfo = TriggerHandlerNewProcedures.updatePaused(databaseName, name, false, tx);
            return Stream.ofNullable(triggerInfo);
        });
    }

    @SystemProcedure
    @Admin
    @Procedure(name="apoc.trigger.show", mode=Mode.READ)
    @Description(value="Lists all eventually installed triggers for a database.")
    public Stream<TriggerInfo> show(@Name(value="databaseName") String databaseName) {
        this.checkInSystem();
        return TriggerHandlerNewProcedures.getTriggerNodesList(databaseName, this.tx);
    }

    public <T> T withUpdatingTransaction(String databaseName, Function<Transaction, T> action) {
        T result = null;
        try (Transaction tx = this.db.beginTx();){
            result = action.apply(tx);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            TriggerHandlerNewProcedures.setLastUpdate(databaseName, tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return result;
    }
}

