/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.CompressionAlgo;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public enum ArchiveType {
    NONE(null, null),
    ZIP(ZipArchiveInputStream.class, CompressionAlgo.NONE),
    TAR(TarArchiveInputStream.class, CompressionAlgo.NONE),
    TAR_GZ(TarArchiveInputStream.class, CompressionAlgo.GZIP);

    private final Class<?> stream;
    private final CompressionAlgo algo;

    private ArchiveType(Class<?> stream, CompressionAlgo algo) {
        this.stream = stream;
        this.algo = algo;
    }

    public static ArchiveType from(String urlAddress) {
        if (!urlAddress.contains("!")) {
            return NONE;
        }
        if (urlAddress.contains(".zip")) {
            return ZIP;
        }
        if (urlAddress.contains(".tar.gz") || urlAddress.contains(".tgz")) {
            return TAR_GZ;
        }
        if (urlAddress.contains(".tar")) {
            return TAR;
        }
        return NONE;
    }

    public ArchiveInputStream getInputStream(InputStream is) {
        try {
            InputStream compressionStream = this.algo.getInputStream(is);
            return (ArchiveInputStream)this.stream.getConstructor(InputStream.class).newInstance(compressionStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isArchive() {
        return this.stream != null;
    }
}

