/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.CompressionAlgo;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;

public class CompressionConfig {
    public static final String COMPRESSION = "compression";
    public static final String CHARSET = "charset";
    private final String compressionAlgo;
    private final Charset charset;

    public CompressionConfig(Map<String, Object> config) {
        this(config, CompressionAlgo.NONE.name());
    }

    public CompressionConfig(Map<String, Object> config, String defaultCompression) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.compressionAlgo = (String)config.getOrDefault(COMPRESSION, defaultCompression);
        this.charset = Charset.forName((String)config.getOrDefault(CHARSET, StandardCharsets.UTF_8.name()));
    }

    public String getCompressionAlgo() {
        return this.compressionAlgo;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

