/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.export.util.CountingInputStream;
import apoc.export.util.LimitedSizeInputStream;
import apoc.util.CompressionAlgo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;

public interface StreamConnection {
    public InputStream getInputStream() throws IOException;

    public String getEncoding();

    public long getLength();

    public String getName();

    default public CountingInputStream toCountingInputStream(String algo) throws IOException {
        InputStream iStream = LimitedSizeInputStream.toLimitedIStream(this.getInputStream(), this.getLength());
        if ("gzip".equals(this.getEncoding()) || this.getName().endsWith(".gz")) {
            return new CountingInputStream(new GZIPInputStream(iStream), this.getLength());
        }
        if ("deflate".equals(this.getName())) {
            return new CountingInputStream(new DeflaterInputStream(iStream), this.getLength());
        }
        try {
            InputStream inputStream = CompressionAlgo.valueOf(algo == null ? CompressionAlgo.NONE.name() : algo).getInputStream(iStream);
            return new CountingInputStream(inputStream, this.getLength());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class FileStreamConnection
    implements StreamConnection {
        public static final String CANNOT_OPEN_FILE_FOR_READING = "Cannot open file %s for reading.";
        private final File file;

        public FileStreamConnection(File file) throws IOException {
            this.file = file;
            if (!(file.exists() && file.isFile() && file.canRead())) {
                throw new IOException(String.format(CANNOT_OPEN_FILE_FOR_READING, file.getAbsolutePath()));
            }
        }

        public FileStreamConnection(URI fileName) throws IOException {
            this(new File(fileName));
        }

        public FileStreamConnection(String fileName) throws IOException {
            this(new File(fileName));
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return LimitedSizeInputStream.toLimitedIStream(FileUtils.openInputStream((File)this.file), this.getLength());
        }

        @Override
        public String getEncoding() {
            return "UTF-8";
        }

        @Override
        public long getLength() {
            return this.file.length();
        }

        @Override
        public String getName() {
            return this.file.getName();
        }
    }

    public static class UrlStreamConnection
    implements StreamConnection {
        private final URLConnection con;

        public UrlStreamConnection(URLConnection con) {
            this.con = con;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return LimitedSizeInputStream.toLimitedIStream(this.con.getInputStream(), this.getLength());
        }

        @Override
        public String getEncoding() {
            return this.con.getContentEncoding();
        }

        @Override
        public long getLength() {
            return this.con.getContentLength();
        }

        @Override
        public String getName() {
            return this.con.getURL().toString();
        }
    }
}

