/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.collection;

import apoc.util.collection.WrappingResourceIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;

public final class Iterators {
    public static <T> T firstOrNull(Iterator<T> iterator) {
        try {
            T t = iterator.hasNext() ? (T)iterator.next() : null;
            return t;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <T> T first(Iterator<T> iterator) {
        return Iterators.assertNotNull(iterator, Iterators.firstOrNull(iterator));
    }

    public static <T> T singleOrNull(Iterator<T> iterator) {
        try {
            T result;
            T t = result = iterator.hasNext() ? (T)iterator.next() : null;
            if (iterator.hasNext()) {
                throw new NoSuchElementException("More than one element in " + iterator + ". First element is '" + result + "' and the second element is '" + iterator.next() + "'");
            }
            T t2 = result;
            return t2;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <T> T single(Iterator<T> iterator) {
        return Iterators.assertNotNull(iterator, Iterators.singleOrNull(iterator));
    }

    private static <T> T assertNotNull(Iterator<T> iterator, T result) {
        if (result == null) {
            throw new NoSuchElementException("No element found in " + iterator);
        }
        return result;
    }

    private static <C extends Collection<T>, T> C addToCollection(Iterator<T> iterator, C collection) {
        try {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
            C c = collection;
            return c;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> long count(Iterator<T> iterator) {
        try {
            long result = 0L;
            while (iterator.hasNext()) {
                iterator.next();
                ++result;
            }
            long l = result;
            return l;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <T> List<T> asList(Iterator<T> iterator) {
        return Iterators.addToCollection(iterator, new ArrayList());
    }

    public static <T> Set<T> asSet(Iterator<T> iterator) {
        return Iterators.addToCollection(iterator, new HashSet());
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    public static <T> ResourceIterator<T> asResourceIterator(Iterator<T> iterator) {
        if (iterator instanceof ResourceIterator) {
            return (ResourceIterator)iterator;
        }
        return new WrappingResourceIterator<T>(iterator);
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        Stream<T> stream = StreamSupport.stream(spliterator, false);
        if (iterator instanceof Resource) {
            Resource resource = (Resource)iterator;
            return (Stream)stream.onClose(() -> ((Resource)resource).close());
        }
        return stream;
    }

    public static void tryCloseResource(Iterator<?> iterator) {
        if (iterator instanceof Resource) {
            Resource closeable = (Resource)iterator;
            closeable.close();
        }
    }
}

