/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.kernel;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class MultiThreadedGlobalGraphOperations {
    public static BatchJobResult forAllNodes(GraphDatabaseAPI db, ExecutorService executorService, int batchSize, Consumer<NodeCursor> consumer) {
        BatchJobResult result = new BatchJobResult();
        AtomicInteger processing = new AtomicInteger();
        try (InternalTransaction tx = db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            KernelTransaction ktx = tx.kernelTransaction();
            Read dataRead = ktx.dataRead();
            PartitionedScan scan = dataRead.allNodesScan(1, ktx.cursorContext());
            Function<KernelTransaction, NodeCursor> cursorAllocator = ktx2 -> ktx2.cursors().allocateNodeCursor(ktx2.cursorContext());
            executorService.submit(new BatchJob((PartitionedScan<NodeCursor>)scan, batchSize, db, consumer, result, cursorAllocator, executorService, processing));
        }
        try {
            while (processing.get() > 0) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public static class BatchJobResult {
        final AtomicInteger batches = new AtomicInteger();
        final AtomicLong succeeded = new AtomicLong();
        final AtomicLong failures = new AtomicLong();

        public void incrementSuceeded() {
            this.succeeded.incrementAndGet();
        }

        public void incrementFailures() {
            this.failures.incrementAndGet();
        }

        public long getSucceeded() {
            return this.succeeded.get();
        }

        public long getFailures() {
            return this.failures.get();
        }
    }

    private static class BatchJob
    implements Callable<Void> {
        private final PartitionedScan<NodeCursor> scan;
        private final int batchSize;
        private final GraphDatabaseAPI db;
        private final Consumer<NodeCursor> consumer;
        private final BatchJobResult result;
        private final Function<KernelTransaction, NodeCursor> cursorAllocator;
        private final ExecutorService executorService;
        private final AtomicInteger processing;

        public BatchJob(PartitionedScan<NodeCursor> scan, int batchSize, GraphDatabaseAPI db, Consumer<NodeCursor> consumer, BatchJobResult result, Function<KernelTransaction, NodeCursor> cursorAllocator, ExecutorService executorService, AtomicInteger processing) {
            this.scan = scan;
            this.batchSize = batchSize;
            this.db = db;
            this.consumer = consumer;
            this.result = result;
            this.cursorAllocator = cursorAllocator;
            this.executorService = executorService;
            this.processing = processing;
            processing.incrementAndGet();
        }

        @Override
        public Void call() {
            try {
                Void void_;
                block18: {
                    InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
                    try {
                        KernelTransaction ktx = tx.kernelTransaction();
                        ktx.acquireStatement();
                        ExecutionContext executionContext = ktx.createExecutionContext();
                        try (NodeCursor cursor = this.cursorAllocator.apply(ktx);){
                            while (this.scan.reservePartition((Cursor)cursor, executionContext)) {
                                this.executorService.submit(new BatchJob(this.scan, this.batchSize, this.db, this.consumer, this.result, this.cursorAllocator, this.executorService, this.processing));
                                this.executorService.submit(new BatchJob(this.scan, this.batchSize, this.db, this.consumer, this.result, this.cursorAllocator, this.executorService, this.processing));
                                while (this.processAndReport(cursor)) {
                                }
                            }
                        }
                        tx.commit();
                        executionContext.complete();
                        executionContext.close();
                        void_ = null;
                        if (tx == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (tx != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    tx.close();
                }
                return void_;
            }
            finally {
                this.result.batches.incrementAndGet();
                this.processing.decrementAndGet();
            }
        }

        private boolean processAndReport(NodeCursor cursor) {
            if (cursor.next()) {
                try {
                    this.consumer.accept(cursor);
                    this.result.incrementSuceeded();
                }
                catch (Exception e) {
                    this.result.incrementFailures();
                }
                return true;
            }
            return false;
        }
    }
}

