/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import apoc.export.cypher.formatter.CypherFormatterUtils;
import apoc.util.Util;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import org.neo4j.cypher.export.CountOptimisedDatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.api.KernelTransaction;

public class DatabaseSubGraph
implements SubGraph {
    private final Transaction transaction;

    public DatabaseSubGraph(Transaction transaction) {
        this.transaction = transaction;
    }

    public static SubGraph optimizedForCount(Transaction transaction, KernelTransaction kernelTransaction) {
        return new CountOptimisedDatabaseSubGraph(transaction, kernelTransaction);
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.transaction.getAllNodes();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.transaction.getAllRelationships();
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        return Util.getIndexes(this.transaction);
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        Comparator<ConstraintDefinition> comp = Comparator.comparing(ConstraintDefinition::getName);
        return StreamSupport.stream(this.transaction.schema().getConstraints().spliterator(), false).sorted(comp).toList();
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        return this.transaction.schema().getConstraints(label);
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
        return this.transaction.schema().getConstraints(type);
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(Label label) {
        return Util.getIndexes(this.transaction, label);
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(RelationshipType type) {
        return Util.getIndexes(this.transaction, type);
    }

    @Override
    public Iterable<RelationshipType> getAllRelationshipTypesInUse() {
        return this.transaction.getAllRelationshipTypesInUse();
    }

    @Override
    public Iterable<Label> getAllLabelsInUse() {
        return this.transaction.getAllLabelsInUse();
    }

    @Override
    public long countsForRelationship(Label start, RelationshipType type, Label end) {
        String startNode = CypherFormatterUtils.cypherNode(start);
        String endNode = CypherFormatterUtils.cypherNode(end);
        String relationship = String.format("[r:%s]", Util.quote(type.name()));
        return (Long)this.transaction.execute(String.format("MATCH %s-%s->%s RETURN count(r) AS count", startNode, relationship, endNode)).columnAs("count").next();
    }

    @Override
    public long countsForNode(Label label) {
        return (Long)this.transaction.execute(String.format("MATCH (n:%s) RETURN count(n) AS count", Util.quote(label.name()))).columnAs("count").next();
    }

    @Override
    public Iterator<Node> findNodes(Label label) {
        return this.transaction.findNodes(label);
    }
}

