/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted;

import java.io.Serializable;
import org.neo4j.cypher.internal.expressions.ASTCachedProperty;
import org.neo4j.cypher.internal.physicalplanning.LongSlot;
import org.neo4j.cypher.internal.physicalplanning.RefSlot;
import org.neo4j.cypher.internal.physicalplanning.Slot;
import org.neo4j.cypher.internal.physicalplanning.SlotConfiguration;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.EntityById;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.ResourceLinenumber;
import org.neo4j.cypher.internal.runtime.slotted.SlottedCompatible;
import org.neo4j.cypher.internal.runtime.slotted.SlottedRow$;
import org.neo4j.cypher.internal.runtime.slotted.helpers.NullChecker$;
import org.neo4j.cypher.internal.util.AssertionRunner;
import org.neo4j.cypher.internal.util.attribution.Id;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.NodeType;
import org.neo4j.cypher.internal.util.symbols.RelationshipType;
import org.neo4j.exceptions.InternalException;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u001dx!B'O\u0011\u0003Yf!B/O\u0011\u0003q\u0006\"B7\u0002\t\u0003q\u0007bB8\u0002\u0005\u0004%)\u0001\u001d\u0005\u0007i\u0006\u0001\u000bQB9\t\u000bU\fA\u0011\u0001<\t\u0013\r=\u0016A1A\u0005\u0006\rE\u0006\u0002CB\\\u0003\u0001\u0006iaa-\t\u000f\re\u0016\u0001\"\u0001\u0004<\"9!QS\u0001\u0005\u0002\r\u001d\u0007\"CBg\u0003\u0005\u0005I\u0011QBh\u0011%\u0019\u0019.AA\u0001\n\u0003\u001b)\u000eC\u0005\u0004^\u0006\t\t\u0011\"\u0003\u0004`\u001a!QL\u0014!y\u0011)\t9\"\u0004BK\u0002\u0013\u0005\u0011\u0011\u0004\u0005\u000b\u0003Oi!\u0011#Q\u0001\n\u0005m\u0001BB7\u000e\t\u0003\tI\u0003C\u0005\u0002.5\u0011\r\u0011\"\u0001\u00020!A\u0011qG\u0007!\u0002\u0013\t\t\u0004C\u0005\u0002:5\u0011\r\u0011\"\u0001\u0002<!A\u00111J\u0007!\u0002\u0013\ti\u0004C\u0004\u0002N5!\t%a\u0014\t\u000f\u0005\u0005T\u0002\"\u0011\u0002d!9\u0011QO\u0007\u0005B\u0005]\u0004bBAE\u001b\u0011\u0005\u00131\u0012\u0005\b\u00037kA\u0011IAO\u0011\u001d\t9+\u0004C\u0001\u0003SCq!!.\u000e\t\u0013\t9\fC\u0004\u0002<6!\t%!0\t\u000f\u0005EW\u0002\"\u0003\u0002T\"9\u0011\u0011]\u0007\u0005B\u0005\r\bbBAw\u001b\u0011\u0005\u0013q\u001e\u0005\b\u0003glA\u0011IA{\u0011\u001d\tY0\u0004C!\u0003{DqA!\u0001\u000e\t\u0003\u0012\u0019\u0001C\u0004\u0003\n5!\tEa\u0003\t\u000f\t5Q\u0002\"\u0011\u0003\u0010!9!\u0011D\u0007\u0005B\tm\u0001b\u0002B\u0017\u001b\u0011\u0005#q\u0006\u0005\b\u0005ciA\u0011\tB\u001a\u0011\u001d\u0011I$\u0004C!\u0005wAqA!\u0011\u000e\t\u0003\u0012\u0019\u0005C\u0004\u0003`5!\tE!\u0019\t\u000f\t\u0015T\u0002\"\u0011\u0003h!9!1N\u0007\u0005B\t5\u0004b\u0002B8\u001b\u0011\u0005#\u0011\u000f\u0005\b\u0005ojA\u0011\u0002B=\u0011\u001d\u0011\t)\u0004C!\u0005\u0007CqA!&\u000e\t\u0003\u00129\nC\u0004\u0003\u001a6!\tEa'\t\u000f\teU\u0002\"\u0011\u00034\"9!\u0011T\u0007\u0005B\tu\u0006b\u0002BM\u001b\u0011\u0005#1\u001a\u0005\b\u0005;lA\u0011\tBp\u0011\u001d\u0011i.\u0004C!\u0005KDqA!8\u000e\t\u0003\u0012y\u000fC\u0004\u0003^6!\tE!@\t\u000f\r\u0005Q\u0002\"\u0003\u0004\u0004!91\u0011B\u0007\u0005\u0002\r-\u0001bBB\b\u001b\u0011\u00051\u0011\u0003\u0005\b\u0007+iA\u0011IB\f\u0011%\u0019I#DI\u0001\n\u0003\u0019Y\u0003C\u0004\u0004B5!Iaa\u0011\t\u000f\rES\u0002\"\u0011\u0004T!91QK\u0007\u0005B\r]\u0003bBB.\u001b\u0011%1Q\f\u0005\b\u0007KjA\u0011\tB\u0018\u0011%\u00199'DA\u0001\n\u0003\u0019I\u0007C\u0005\u0004n5\t\n\u0011\"\u0001\u0004p!I11O\u0007\u0002\u0002\u0013\u00053Q\u000f\u0005\n\u0007\u0003k\u0011\u0011!C\u0001\u0005\u0017A\u0011ba!\u000e\u0003\u0003%\ta!\"\t\u0013\rEU\"!A\u0005B\rM\u0005\"CBM\u001b\u0005\u0005I\u0011ABN\u0011%\u0019y*DA\u0001\n\u0003\u001a\t\u000bC\u0005\u0004&6\t\t\u0011\"\u0011\u0004(\"I1\u0011V\u0007\u0002\u0002\u0013\u000531V\u0001\u000b'2|G\u000f^3e%><(BA(Q\u0003\u001d\u0019Hn\u001c;uK\u0012T!!\u0015*\u0002\u000fI,h\u000e^5nK*\u00111\u000bV\u0001\tS:$XM\u001d8bY*\u0011QKV\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005]C\u0016!\u00028f_RR'\"A-\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005q\u000bQ\"\u0001(\u0003\u0015Mcw\u000e\u001e;fIJ{woE\u0002\u0002?\u0016\u0004\"\u0001Y2\u000e\u0003\u0005T\u0011AY\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0006\u0014a!\u00118z%\u00164\u0007C\u00014l\u001b\u00059'B\u00015j\u0003\tIwNC\u0001k\u0003\u0011Q\u0017M^1\n\u00051<'\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001\\\u00035Iej\u0015+B\u001d\u000e+ulU%[\u000bV\t\u0011\u000f\u0005\u0002ae&\u00111/\u0019\u0002\u0005\u0019>tw-\u0001\bJ\u001dN#\u0016IT\"F?NK%,\u0012\u0011\u0002\u000b\u0015l\u0007\u000f^=\u0016\u0003]\u0004\"\u0001X\u0007\u0014\r5y\u00160`A\u0001!\tQ80D\u0001Q\u0013\ta\bKA\u0005DsBDWM\u001d*poB\u0011\u0001M`\u0005\u0003\u007f\u0006\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002\u0004\u0005Ma\u0002BA\u0003\u0003\u001fqA!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017Q\u0016A\u0002\u001fs_>$h(C\u0001c\u0013\r\t\t\"Y\u0001\ba\u0006\u001c7.Y4f\u0013\ra\u0017Q\u0003\u0006\u0004\u0003#\t\u0017!B:m_R\u001cXCAA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011%\u0006\u0001\u0002\u000f[=tS\u000e\fG\u000e\u001d7b]:LgnZ\u0005\u0005\u0003K\tyBA\tTY>$8i\u001c8gS\u001e,(/\u0019;j_:\faa\u001d7piN\u0004CcA<\u0002,!9\u0011q\u0003\tA\u0002\u0005m\u0011!\u00027p]\u001e\u001cXCAA\u0019!\u0011\u0001\u00171G9\n\u0007\u0005U\u0012MA\u0003BeJ\f\u00170\u0001\u0004m_:<7\u000fI\u0001\u0005e\u001647/\u0006\u0002\u0002>A)\u0001-a\r\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002FY\u000baA^1mk\u0016\u001c\u0018\u0002BA%\u0003\u0007\u0012\u0001\"\u00118z-\u0006dW/Z\u0001\u0006e\u001647\u000fI\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u000b\t\u0005\u0003'\nYF\u0004\u0003\u0002V\u0005]\u0003cAA\u0004C&\u0019\u0011\u0011L1\u0002\rA\u0013X\rZ3g\u0013\u0011\ti&a\u0018\u0003\rM#(/\u001b8h\u0015\r\tI&Y\u0001\fG>\u0004\u00180\u00117m\rJ|W\u000e\u0006\u0003\u0002f\u0005-\u0004c\u00011\u0002h%\u0019\u0011\u0011N1\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003[2\u0002\u0019AA8\u0003\u0015Ig\u000e];u!\rQ\u0018\u0011O\u0005\u0004\u0003g\u0002&a\u0003*fC\u0012\f'\r\\3S_^\f\u0001bY8qs\u001a\u0013x.\u001c\u000b\t\u0003K\nI(a\u001f\u0002\u0006\"9\u0011QN\fA\u0002\u0005=\u0004bBA?/\u0001\u0007\u0011qP\u0001\u0007]2{gnZ:\u0011\u0007\u0001\f\t)C\u0002\u0002\u0004\u0006\u00141!\u00138u\u0011\u001d\t9i\u0006a\u0001\u0003\u007f\nQA\u001c*fMN\fQbY8qs2{gnZ:Ge>lGCCA3\u0003\u001b\u000by)a%\u0002\u0018\"9\u0011Q\u000e\rA\u0002\u0005=\u0004bBAI1\u0001\u0007\u0011qP\u0001\u000bMJ|Wn\u00144gg\u0016$\bbBAK1\u0001\u0007\u0011qP\u0001\ti>|eMZ:fi\"9\u0011\u0011\u0014\rA\u0002\u0005}\u0014A\u00027f]\u001e$\b.\u0001\u0007d_BL(+\u001a4t\rJ|W\u000e\u0006\u0006\u0002f\u0005}\u0015\u0011UAR\u0003KCq!!\u001c\u001a\u0001\u0004\ty\u0007C\u0004\u0002\u0012f\u0001\r!a \t\u000f\u0005U\u0015\u00041\u0001\u0002\u0000!9\u0011\u0011T\rA\u0002\u0005}\u0014AC2pafl\u0015\r\u001d9fIR\u0019\u00110a+\t\u000f\u00055&\u00041\u0001\u00020\u0006!a-\u001e8d!\u001d\u0001\u0017\u0011WA \u0003\u007fI1!a-b\u0005%1UO\\2uS>t\u0017'A\u0007ue\u0006t7OZ8s[J+gm\u001d\u000b\u0005\u0003K\nI\fC\u0004\u0002.n\u0001\r!a,\u0002\u001d\r|\u0007/\u001f$s_6|eMZ:fiRa\u0011QMA`\u0003\u0003\f)-!3\u0002N\"9\u0011Q\u000e\u000fA\u0002\u0005=\u0004bBAb9\u0001\u0007\u0011qP\u0001\u0011g>,(oY3M_:<wJ\u001a4tKRDq!a2\u001d\u0001\u0004\ty(A\bt_V\u00148-\u001a*fM>3gm]3u\u0011\u001d\tY\r\ba\u0001\u0003\u007f\n\u0001\u0003^1sO\u0016$Hj\u001c8h\u001f\u001a47/\u001a;\t\u000f\u0005=G\u00041\u0001\u0002\u0000\u0005yA/\u0019:hKR\u0014VMZ(gMN,G/A\bd_BLhI]8n'2|G\u000f^3e)1\t)'!6\u0002Z\u0006m\u0017Q\\Ap\u0011\u0019\t9.\ba\u0001o\u0006)q\u000e\u001e5fe\"9\u00111Y\u000fA\u0002\u0005}\u0004bBAd;\u0001\u0007\u0011q\u0010\u0005\b\u0003\u0017l\u0002\u0019AA@\u0011\u001d\ty-\ba\u0001\u0003\u007f\n\u0011b]3u\u0019>tw-\u0011;\u0015\r\u0005\u0015\u0014Q]Au\u0011\u001d\t9O\ba\u0001\u0003\u007f\naa\u001c4gg\u0016$\bBBAv=\u0001\u0007\u0011/A\u0003wC2,X-A\u0005hKRduN\\4BiR\u0019\u0011/!=\t\u000f\u0005\u001dx\u00041\u0001\u0002\u0000\u0005A1/\u001a;SK\u001a\fE\u000f\u0006\u0004\u0002f\u0005]\u0018\u0011 \u0005\b\u0003O\u0004\u0003\u0019AA@\u0011\u001d\tY\u000f\ta\u0001\u0003\u007f\t\u0001bZ3u%\u00164\u0017\t\u001e\u000b\u0005\u0003\u007f\ty\u0010C\u0004\u0002h\u0006\u0002\r!a \u0002\u0013\u001d,GOQ=OC6,G\u0003BA \u0005\u000bAqAa\u0002#\u0001\u0004\t\t&\u0001\u0003oC6,\u0017a\u00048v[\n,'o\u00144D_2,XN\\:\u0016\u0005\u0005}\u0014\u0001D2p]R\f\u0017N\\:OC6,G\u0003\u0002B\t\u0005/\u00012\u0001\u0019B\n\u0013\r\u0011)\"\u0019\u0002\b\u0005>|G.Z1o\u0011\u001d\u00119\u0001\na\u0001\u0003#\n1c]3u\u0007\u0006\u001c\u0007.\u001a3Qe>\u0004XM\u001d;z\u0003R$b!!\u001a\u0003\u001e\t}\u0001bBAtK\u0001\u0007\u0011q\u0010\u0005\b\u0003W,\u0003\u0019\u0001B\u0011!\u0011\u0011\u0019C!\u000b\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0003\u0007\n\u0001b\u001d;pe\u0006\u0014G.Z\u0005\u0005\u0005W\u0011)CA\u0003WC2,X-\u0001\u000ej]Z\fG.\u001b3bi\u0016\u001c\u0015m\u00195fIB\u0013x\u000e]3si&,7\u000f\u0006\u0002\u0002f\u0005q\u0012N\u001c<bY&$\u0017\r^3DC\u000eDW\r\u001a(pI\u0016\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0003K\u0012)\u0004\u0003\u0004\u00038\u001d\u0002\r!]\u0001\u0005]>$W-\u0001\u0014j]Z\fG.\u001b3bi\u0016\u001c\u0015m\u00195fIJ+G.\u0019;j_:\u001c\b.\u001b9Qe>\u0004XM\u001d;jKN$B!!\u001a\u0003>!1!q\b\u0015A\u0002E\f1A]3m\u0003E\u0019X\r^\"bG\",G\r\u0015:pa\u0016\u0014H/\u001f\u000b\u0007\u0003K\u0012)E!\u0018\t\u000f\t\u001d\u0013\u00061\u0001\u0003J\u0005\u00191.Z=\u0011\t\t-#q\u000b\b\u0005\u0005\u001b\u0012\u0019&\u0004\u0002\u0003P)\u0019!\u0011\u000b*\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0005+\u0012y%A\tB'R\u001b\u0015m\u00195fIB\u0013x\u000e]3sifLAA!\u0017\u0003\\\tQ!+\u001e8uS6,7*Z=\u000b\t\tU#q\n\u0005\b\u0003WL\u0003\u0019\u0001B\u0011\u0003M9W\r^\"bG\",G\r\u0015:pa\u0016\u0014H/_!u)\u0011\u0011\tCa\u0019\t\u000f\u0005\u001d(\u00061\u0001\u0002\u0000\u0005\tr-\u001a;DC\u000eDW\r\u001a)s_B,'\u000f^=\u0015\t\t\u0005\"\u0011\u000e\u0005\b\u0005\u000fZ\u0003\u0019\u0001B%\u0003I)7\u000f^5nCR,G\rS3baV\u001b\u0018mZ3\u0015\u0003E\fa\u0004Z3ekBd\u0017nY1uK\u0012,5\u000f^5nCR,G\rS3baV\u001b\u0018mZ3\u0015\u0007E\u0014\u0019\b\u0003\u0004\u0003v5\u0002\r!_\u0001\taJ,g/[8vg\u0006!a-Y5m)\t\u0011Y\bE\u0002a\u0005{J1Aa b\u0005\u001dqu\u000e\u001e5j]\u001e\fQb]3u\u0019&tWM\\;nE\u0016\u0014H\u0003BA3\u0005\u000bCqAa\"0\u0001\u0004\u0011I)\u0001\u0003mS:,\u0007#\u00021\u0003\f\n=\u0015b\u0001BGC\n1q\n\u001d;j_:\u00042A\u001fBI\u0013\r\u0011\u0019\n\u0015\u0002\u0013%\u0016\u001cx.\u001e:dK2Kg.\u001a8v[\n,'/A\u0007hKRd\u0015N\\3ok6\u0014WM]\u000b\u0003\u0005\u0013\u000b1a]3u)\u0011\t)G!(\t\u000f\t}\u0015\u00071\u0001\u0003\"\u0006Qa.Z<F]R\u0014\u0018.Z:\u0011\r\t\r&\u0011\u0016BW\u001b\t\u0011)KC\u0002\u0003(\u0006\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YK!*\u0003\u0007M+\u0017\u000fE\u0004a\u0005_\u000b\t&a\u0010\n\u0007\tE\u0016M\u0001\u0004UkBdWM\r\u000b\u0007\u0003K\u0012)L!/\t\u000f\t]&\u00071\u0001\u0002R\u0005!1.Z=2\u0011\u001d\u0011YL\ra\u0001\u0003\u007f\taA^1mk\u0016\fDCCA3\u0005\u007f\u0013\tMa1\u0003H\"9!qW\u001aA\u0002\u0005E\u0003b\u0002B^g\u0001\u0007\u0011q\b\u0005\b\u0005\u000b\u001c\u0004\u0019AA)\u0003\u0011YW-\u001f\u001a\t\u000f\t%7\u00071\u0001\u0002@\u00051a/\u00197vKJ\"b\"!\u001a\u0003N\n='\u0011\u001bBj\u0005+\u0014I\u000eC\u0004\u00038R\u0002\r!!\u0015\t\u000f\tmF\u00071\u0001\u0002@!9!Q\u0019\u001bA\u0002\u0005E\u0003b\u0002Bei\u0001\u0007\u0011q\b\u0005\b\u0005/$\u0004\u0019AA)\u0003\u0011YW-_\u001a\t\u000f\tmG\u00071\u0001\u0002@\u00051a/\u00197vKN\n\u0001bY8qs^KG\u000f\u001b\u000b\u0006s\n\u0005(1\u001d\u0005\b\u0005o+\u0004\u0019AA)\u0011\u001d\u0011Y,\u000ea\u0001\u0003\u007f!\u0012\"\u001fBt\u0005S\u0014YO!<\t\u000f\t]f\u00071\u0001\u0002R!9!1\u0018\u001cA\u0002\u0005}\u0002b\u0002Bcm\u0001\u0007\u0011\u0011\u000b\u0005\b\u0005\u00134\u0004\u0019AA )5I(\u0011\u001fBz\u0005k\u00149P!?\u0003|\"9!qW\u001cA\u0002\u0005E\u0003b\u0002B^o\u0001\u0007\u0011q\b\u0005\b\u0005\u000b<\u0004\u0019AA)\u0011\u001d\u0011Im\u000ea\u0001\u0003\u007fAqAa68\u0001\u0004\t\t\u0006C\u0004\u0003\\^\u0002\r!a\u0010\u0015\u0007e\u0014y\u0010C\u0004\u0003 b\u0002\rA!)\u0002\u0011M,GOV1mk\u0016$b!!\u001a\u0004\u0006\r\u001d\u0001b\u0002B\\s\u0001\u0007\u0011\u0011\u000b\u0005\b\u0005wK\u0004\u0019AA \u0003AI7OU3g\u0013:LG/[1mSj,G\r\u0006\u0003\u0003\u0012\r5\u0001bBAtu\u0001\u0007\u0011qP\u0001#O\u0016$(+\u001a4Bi^KG\u000f[8vi\u000eCWmY6j]\u001eLe.\u001b;jC2L'0\u001a3\u0015\t\u0005}21\u0003\u0005\b\u0003O\\\u0004\u0019AA@\u0003%iWM]4f/&$\b\u000e\u0006\u0005\u0002f\re11DB\u0013\u0011\u001d\t9\u000e\u0010a\u0001\u0003_Bqa!\b=\u0001\u0004\u0019y\"\u0001\u0006f]RLG/\u001f\"z\u0013\u0012\u00042A_B\u0011\u0013\r\u0019\u0019\u0003\u0015\u0002\u000b\u000b:$\u0018\u000e^=Cs&#\u0007\"CB\u0014yA\u0005\t\u0019\u0001B\t\u0003A\u0019\u0007.Z2l\u001dVdG.\u00192jY&$\u00180A\nnKJ<WmV5uQ\u0012\"WMZ1vYR$3'\u0006\u0002\u0004.)\"!\u0011CB\u0018W\t\u0019\t\u0004\u0005\u0003\u00044\ruRBAB\u001b\u0015\u0011\u00199d!\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAB\u001eC\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r}2Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aG2iK\u000e\\7i\\7qCRL'\r\\3Ok2d\u0017M\u00197jY&$\u0018\u0010\u0006\u0004\u0003\u0012\r\u00153q\t\u0005\b\u0005\u000fr\u0004\u0019AA)\u0011\u001d\u0019IE\u0010a\u0001\u0007\u0017\n\u0011b\u001c;iKJ\u001cFn\u001c;\u0011\t\u0005u1QJ\u0005\u0005\u0007\u001f\nyBA\u0004SK\u001a\u001cFn\u001c;\u0002\u0017\r\u0014X-\u0019;f\u00072|g.\u001a\u000b\u0002s\u00061\u0011n\u001d(vY2$BA!\u0005\u0004Z!9!q\t!A\u0002\u0005E\u0013\u0001C5uKJ\fGo\u001c:\u0016\u0005\r}\u0003CBA\u0002\u0007C\u0012i+\u0003\u0003\u0004d\u0005U!\u0001C%uKJ\fGo\u001c:\u0002\u000f\r|W\u000e]1di\u0006!1m\u001c9z)\r981\u000e\u0005\n\u0003/\u0019\u0005\u0013!a\u0001\u00037\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004r)\"\u00111DB\u0018\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111q\u000f\t\u0005\u0007s\u001ay(\u0004\u0002\u0004|)\u00191QP5\u0002\t1\fgnZ\u0005\u0005\u0003;\u001aY(\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\r\u001d5Q\u0012\t\u0004A\u000e%\u0015bABFC\n\u0019\u0011I\\=\t\u0013\r=u)!AA\u0002\u0005}\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004\u0016B1!1UBL\u0007\u000fKAaa\u0019\u0003&\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0012\ru\u0005\"CBH\u0013\u0006\u0005\t\u0019ABD\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\r]41\u0015\u0005\n\u0007\u001fS\u0015\u0011!a\u0001\u0003\u007f\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u007f\na!Z9vC2\u001cH\u0003\u0002B\t\u0007[C\u0011ba$M\u0003\u0003\u0005\raa\"\u0002\u000b\u0011+%)V$\u0016\u0005\rMvBAB[3\u0005\u0001\u0011A\u0002#F\u0005V;\u0005%A\u0005hKRtu\u000eZ3JIR9\u0011o!0\u0004B\u000e\r\u0007bBB`\u0011\u0001\u0007\u0011qN\u0001\u0004e><\bbBAt\u0011\u0001\u0007\u0011q\u0010\u0005\b\u0007\u000bD\u0001\u0019\u0001B\t\u0003-I7OU3gKJ,gnY3\u0015\r\t%5\u0011ZBf\u0011\u001d\u0019y,\u0003a\u0001\u0003_Bq!a\u0006\n\u0001\u0004\tY\"A\u0003baBd\u0017\u0010F\u0002x\u0007#Dq!a\u0006\u000b\u0001\u0004\tY\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r]7\u0011\u001c\t\u0006A\n-\u00151\u0004\u0005\t\u00077\\\u0011\u0011!a\u0001o\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r\u0005\b\u0003BB=\u0007GLAa!:\u0004|\t1qJ\u00196fGR\u0004")
public class SlottedRow
implements CypherRow,
Product,
Serializable {
    private final SlotConfiguration slots;
    private final long[] longs;
    private final AnyValue[] refs;

    public static Option<SlotConfiguration> unapply(SlottedRow x$0) {
        return SlottedRow$.MODULE$.unapply(x$0);
    }

    public static SlottedRow apply(SlotConfiguration slots) {
        return SlottedRow$.MODULE$.apply(slots);
    }

    public static long getNodeId(ReadableRow row, int offset, boolean isReference) {
        return SlottedRow$.MODULE$.getNodeId(row, offset, isReference);
    }

    public static boolean DEBUG() {
        return SlottedRow$.MODULE$.DEBUG();
    }

    public static SlottedRow empty() {
        return SlottedRow$.MODULE$.empty();
    }

    public static long INSTANCE_SIZE() {
        return SlottedRow$.MODULE$.INSTANCE_SIZE();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SlotConfiguration slots() {
        return this.slots;
    }

    public long[] longs() {
        return this.longs;
    }

    public AnyValue[] refs() {
        return this.refs;
    }

    public String toString() {
        Iterator<Tuple2<String, AnyValue>> iter = this.iterator();
        StringBuilder s = package$.MODULE$.StringBuilder().newBuilder();
        s.$plus$plus$eq("\nSlottedExecutionContext {\n    " + this.slots());
        while (iter.hasNext()) {
            Tuple2 slotValue = (Tuple2)iter.next();
            s.$plus$plus$eq(StringOps$.MODULE$.format$extension("\n    %-40s = %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{slotValue._1(), slotValue._2()})));
        }
        s.$plus$plus$eq("\n}\n");
        return s.result();
    }

    public void copyAllFrom(ReadableRow input) {
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            this.copyFromSlotted(slottedRow, 0, 0, 0, 0);
            return;
        }
        if (readableRow instanceof SlottedCompatible) {
            ReadableRow readableRow2 = readableRow;
            ((SlottedCompatible)readableRow2).copyAllToSlottedRow(this);
            return;
        }
        throw this.fail();
    }

    public void copyFrom(ReadableRow input, int nLongs, int nRefs) {
        if (nLongs > this.slots().numberOfLongs() || nRefs > this.slots().numberOfReferences()) {
            throw new InternalException("A bug has occurred in the slotted runtime: The target slotted execution context cannot hold the data to copy.");
        }
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            System.arraycopy(slottedRow.longs(), 0, this.longs(), 0, nLongs);
            System.arraycopy(slottedRow.refs(), 0, this.refs(), 0, nRefs);
            return;
        }
        if (readableRow instanceof SlottedCompatible) {
            ReadableRow readableRow2 = readableRow;
            ((SlottedCompatible)readableRow2).copyLongsToSlottedRow(this, 0, 0, nLongs);
            ((SlottedCompatible)readableRow2).copyRefsToSlottedRow(this, 0, 0, nRefs);
            return;
        }
        throw this.fail();
    }

    public void copyLongsFrom(ReadableRow input, int fromOffset, int toOffset, int length) {
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            System.arraycopy(slottedRow.longs(), fromOffset, this.longs(), toOffset, length);
            return;
        }
        if (readableRow instanceof SlottedCompatible) {
            ReadableRow readableRow2 = readableRow;
            ((SlottedCompatible)readableRow2).copyLongsToSlottedRow(this, fromOffset, toOffset, length);
            return;
        }
        throw this.fail();
    }

    public void copyRefsFrom(ReadableRow input, int fromOffset, int toOffset, int length) {
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            System.arraycopy(slottedRow.refs(), fromOffset, this.refs(), toOffset, length);
            return;
        }
        if (readableRow instanceof SlottedCompatible) {
            ReadableRow readableRow2 = readableRow;
            ((SlottedCompatible)readableRow2).copyRefsToSlottedRow(this, fromOffset, toOffset, length);
            return;
        }
        throw this.fail();
    }

    public CypherRow copyMapped(Function1<AnyValue, AnyValue> func) {
        SlottedRow clone = new SlottedRow(this.slots());
        clone.copyAllFrom((ReadableRow)this);
        clone.transformRefs(func);
        return clone;
    }

    private void transformRefs(Function1<AnyValue, AnyValue> func) {
        this.slots().foreachSlot((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$transformRefs$1(this, func, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void copyFromOffset(ReadableRow input, int sourceLongOffset, int sourceRefOffset, int targetLongOffset, int targetRefOffset) {
        ReadableRow readableRow = input;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            this.copyFromSlotted(slottedRow, sourceLongOffset, sourceRefOffset, targetLongOffset, targetRefOffset);
            return;
        }
        throw this.fail();
    }

    private void copyFromSlotted(SlottedRow other, int sourceLongOffset, int sourceRefOffset, int targetLongOffset, int targetRefOffset) {
        SlotConfiguration otherPipeline = other.slots();
        if (otherPipeline.numberOfLongs() > this.slots().numberOfLongs() || otherPipeline.numberOfReferences() > this.slots().numberOfReferences()) {
            throw new InternalException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A bug has occurred in the slotted runtime: The target slotted execution context cannot hold the data to copy\n           |From : " + otherPipeline + "\n           |To :   " + this.slots())));
        }
        System.arraycopy(other.longs(), sourceLongOffset, this.longs(), targetLongOffset, other.slots().numberOfLongs() - sourceLongOffset);
        System.arraycopy(other.refs(), sourceRefOffset, this.refs(), targetRefOffset, other.slots().numberOfReferences() - sourceRefOffset);
    }

    public void setLongAt(int offset, long value) {
        this.longs()[offset] = value;
    }

    public long getLongAt(int offset) {
        return this.longs()[offset];
    }

    public void setRefAt(int offset, AnyValue value) {
        this.refs()[offset] = value;
    }

    public AnyValue getRefAt(int offset) {
        AnyValue value = this.refs()[offset];
        if (false && value == null) {
            throw new InternalException("Reference value not initialised at offset " + offset + " in " + this);
        }
        return value;
    }

    public AnyValue getByName(String name) {
        return (AnyValue)this.slots().maybeGetter(name).map((Function1 & Serializable)g -> (AnyValue)g.apply((Object)this)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Unknown variable `" + name + "`.");
        });
    }

    public int numberOfColumns() {
        return this.refs().length + this.longs().length;
    }

    public boolean containsName(String name) {
        return this.slots().maybeGetter(name).map((Function1 & Serializable)g -> (AnyValue)g.apply((Object)this)).isDefined();
    }

    public void setCachedPropertyAt(int offset, Value value) {
        this.refs()[offset] = value;
    }

    public void invalidateCachedProperties() {
        this.slots().foreachCachedSlot((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$invalidateCachedProperties$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void invalidateCachedNodeProperties(long node) {
        this.slots().foreachCachedSlot((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$invalidateCachedNodeProperties$1(this, node, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void invalidateCachedRelationshipProperties(long rel) {
        this.slots().foreachCachedSlot((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$invalidateCachedRelationshipProperties$1(this, rel, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void setCachedProperty(ASTCachedProperty.RuntimeKey key, Value value) {
        this.setCachedPropertyAt(this.slots().getCachedPropertyOffsetFor(key), value);
    }

    public Value getCachedPropertyAt(int offset) {
        return (Value)this.refs()[offset];
    }

    public Value getCachedProperty(ASTCachedProperty.RuntimeKey key) {
        throw this.fail();
    }

    public long estimatedHeapUsage() {
        long usage = SlottedRow$.MODULE$.INSTANCE_SIZE() + HeapEstimator.sizeOf((long[])this.longs()) + HeapEstimator.shallowSizeOf((Object[])this.refs());
        for (int i = 0; i < this.refs().length; ++i) {
            AnyValue ref = this.refs()[i];
            if (ref == null) continue;
            usage += ref.estimatedHeapUsage();
        }
        return usage;
    }

    public long deduplicatedEstimatedHeapUsage(CypherRow previous) {
        if (previous == null) {
            return this.estimatedHeapUsage();
        }
        long usage = SlottedRow$.MODULE$.INSTANCE_SIZE() + HeapEstimator.sizeOf((long[])this.longs()) + HeapEstimator.shallowSizeOf((Object[])this.refs());
        for (int i = 0; i < this.refs().length; ++i) {
            AnyValue ref = this.refs()[i];
            if (ref == null || ref == previous.getRefAt(i)) continue;
            usage += ref.estimatedHeapUsage();
        }
        return usage;
    }

    private Nothing$ fail() {
        throw new InternalException("Tried using a slotted context as a map");
    }

    public void setLinenumber(Option<ResourceLinenumber> line) {
        throw this.fail();
    }

    public Option<ResourceLinenumber> getLinenumber() {
        return SlottedRow$.MODULE$.getLinenumber((ReadableRow)this, this.slots());
    }

    public void set(Seq<Tuple2<String, AnyValue>> newEntries) {
        newEntries.foreach((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$set$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void set(String key1, AnyValue value1) {
        this.setValue(key1, value1);
    }

    public void set(String key1, AnyValue value1, String key2, AnyValue value2) {
        this.setValue(key1, value1);
        this.setValue(key2, value2);
    }

    public void set(String key1, AnyValue value1, String key2, AnyValue value2, String key3, AnyValue value3) {
        this.setValue(key1, value1);
        this.setValue(key2, value2);
        this.setValue(key3, value3);
    }

    public CypherRow copyWith(String key1, AnyValue value1) {
        SlottedRow newCopy = new SlottedRow(this.slots());
        newCopy.copyAllFrom((ReadableRow)this);
        newCopy.setValue(key1, value1);
        return newCopy;
    }

    public CypherRow copyWith(String key1, AnyValue value1, String key2, AnyValue value2) {
        throw new UnsupportedOperationException("Use ExecutionContextFactory.copyWith instead to get the correct slot configuration");
    }

    public CypherRow copyWith(String key1, AnyValue value1, String key2, AnyValue value2, String key3, AnyValue value3) {
        throw new UnsupportedOperationException("Use ExecutionContextFactory.copyWith instead to get the correct slot configuration");
    }

    public CypherRow copyWith(Seq<Tuple2<String, AnyValue>> newEntries) {
        throw new UnsupportedOperationException("Use ExecutionContextFactory.copyWith instead to get the correct slot configuration");
    }

    private void setValue(String key1, AnyValue value1) {
        ((Function2)this.slots().maybeSetter(key1).getOrElse((Function0 & Serializable)() -> {
            throw new InternalException("Ouch, no suitable slot for key " + key1 + " = " + value1 + "\nSlots: " + this.slots());
        })).apply((Object)this, (Object)value1);
    }

    public boolean isRefInitialized(int offset) {
        return this.refs()[offset] != null;
    }

    public AnyValue getRefAtWithoutCheckingInitialized(int offset) {
        return this.refs()[offset];
    }

    public void mergeWith(ReadableRow other, EntityById entityById, boolean checkNullability) {
        ReadableRow readableRow = other;
        if (readableRow instanceof SlottedRow) {
            SlottedRow slottedRow = (SlottedRow)readableRow;
            slottedRow.slots().foreachSlot((Function1 & Serializable)x0$1 -> {
                SlottedRow.$anonfun$mergeWith$1(this, other, entityById, slottedRow, checkNullability, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new InternalException("Well well, isn't this a delicate situation?");
    }

    public boolean mergeWith$default$3() {
        return true;
    }

    private boolean checkCompatibleNullablility(String key, RefSlot otherSlot) {
        Slot thisSlot = (Slot)this.slots().get(key).get();
        if (!thisSlot.nullable() && otherSlot.nullable()) {
            throw new InternalException("Tried to merge slot " + otherSlot + " into " + thisSlot + " but its nullability is incompatible");
        }
        return true;
    }

    public CypherRow createClone() {
        SlottedRow clone = new SlottedRow(this.slots());
        clone.copyAllFrom((ReadableRow)this);
        return clone;
    }

    public boolean isNull(String key) {
        Slot slot;
        Slot slot2;
        boolean bl = false;
        Some some = null;
        Option option = this.slots().get(key);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Slot slot3 = (Slot)some.value();
            if (slot3 instanceof RefSlot) {
                RefSlot refSlot = (RefSlot)slot3;
                int offset = refSlot.offset();
                boolean bl2 = refSlot.nullable();
                if (bl2 && this.isRefInitialized(offset)) {
                    return this.getRefAtWithoutCheckingInitialized(offset) == Values.NO_VALUE;
                }
            }
        }
        if (bl && (slot2 = (Slot)some.value()) instanceof LongSlot) {
            LongSlot longSlot = (LongSlot)slot2;
            int offset = longSlot.offset();
            boolean bl3 = longSlot.nullable();
            CypherType cypherType = longSlot.typ();
            if (bl3) {
                NodeType nodeType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode();
                CypherType cypherType2 = cypherType;
                if (!(nodeType != null ? !nodeType.equals(cypherType2) : cypherType2 != null)) {
                    return NullChecker$.MODULE$.entityIsNull(this.getLongAt(offset));
                }
            }
        }
        if (bl && (slot = (Slot)some.value()) instanceof LongSlot) {
            LongSlot longSlot = (LongSlot)slot;
            int offset = longSlot.offset();
            boolean bl4 = longSlot.nullable();
            CypherType cypherType = longSlot.typ();
            if (bl4) {
                RelationshipType relationshipType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship();
                CypherType cypherType3 = cypherType;
                if (!(relationshipType != null ? !relationshipType.equals(cypherType3) : cypherType3 != null)) {
                    return NullChecker$.MODULE$.entityIsNull(this.getLongAt(offset));
                }
            }
        }
        return false;
    }

    private Iterator<Tuple2<String, AnyValue>> iterator() {
        ObjectRef tuples = ObjectRef.create((Object)Nil$.MODULE$);
        this.slots().foreachSlotAndAliasesOrdered((Function1 & Serializable)x0$1 -> {
            SlottedRow.$anonfun$iterator$1(this, tuples, x0$1);
            return BoxedUnit.UNIT;
        }, this.slots().foreachSlotAndAliasesOrdered$default$2());
        return ((List)tuples.elem).iterator();
    }

    public void compact() {
        if (this.refs().length > 0 && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.intArrayOps(this.slots().discardedRefSlotOffsets()))) {
            int[] discard = this.slots().discardedRefSlotOffsets();
            for (int i = 0; i < discard.length; ++i) {
                this.refs()[discard[i]] = null;
            }
            return;
        }
    }

    public SlottedRow copy(SlotConfiguration slots) {
        return new SlottedRow(slots);
    }

    public SlotConfiguration copy$default$1() {
        return this.slots();
    }

    public String productPrefix() {
        return "SlottedRow";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.slots();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SlottedRow;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "slots";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SlottedRow)) return false;
        boolean bl = true;
        if (!bl) return false;
        SlottedRow slottedRow = (SlottedRow)x$1;
        SlotConfiguration slotConfiguration = this.slots();
        SlotConfiguration slotConfiguration2 = slottedRow.slots();
        if (slotConfiguration == null) {
            if (slotConfiguration2 != null) {
                return false;
            }
        } else if (!slotConfiguration.equals(slotConfiguration2)) return false;
        if (!slottedRow.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$transformRefs$1(SlottedRow $this, Function1 func$1, Tuple2 x0$1) {
        Slot slot;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (slot = (Slot)tuple2._2()) instanceof RefSlot) {
            RefSlot refSlot = (RefSlot)slot;
            AnyValue refValue = $this.getRefAt(refSlot.offset());
            AnyValue newRefValue = (AnyValue)func$1.apply((Object)refValue);
            $this.setRefAt(refSlot.offset(), newRefValue);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$invalidateCachedProperties$1(SlottedRow $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            RefSlot propertyRefSLot = (RefSlot)tuple2._2();
            $this.setCachedPropertyAt(propertyRefSLot.offset(), null);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$invalidateCachedNodeProperties$1(SlottedRow $this, long node$1, Tuple2 x0$1) {
        Slot refSlot;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ASTCachedProperty.RuntimeKey cnp = (ASTCachedProperty.RuntimeKey)tuple2._1();
        RefSlot propertyRefSLot = (RefSlot)tuple2._2();
        boolean bl = false;
        Some some = null;
        Option option = $this.slots().get(cnp.entityName());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Slot longSlot = (Slot)some.value();
            if (longSlot instanceof LongSlot) {
                LongSlot longSlot2 = (LongSlot)longSlot;
                CypherType cypherType = longSlot2.typ();
                NodeType nodeType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode();
                if (cypherType == null) {
                    if (nodeType != null) {
                        return;
                    }
                } else if (!cypherType.equals(nodeType)) return;
                if ($this.getLongAt(longSlot2.offset()) != node$1) return;
                $this.setCachedPropertyAt(propertyRefSLot.offset(), null);
                return;
            }
        }
        if (bl && (refSlot = (Slot)some.value()) instanceof RefSlot) {
            RefSlot refSlot2 = (RefSlot)refSlot;
            CypherType cypherType = refSlot2.typ();
            NodeType nodeType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode();
            if (cypherType == null) {
                if (nodeType != null) {
                    return;
                }
            } else if (!cypherType.equals(nodeType)) return;
            if (((VirtualNodeValue)$this.getRefAt(refSlot2.offset())).id() != node$1) return;
            $this.setCachedPropertyAt(propertyRefSLot.offset(), null);
            return;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$invalidateCachedRelationshipProperties$1(SlottedRow $this, long rel$1, Tuple2 x0$1) {
        Slot refSlot;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ASTCachedProperty.RuntimeKey crp = (ASTCachedProperty.RuntimeKey)tuple2._1();
        RefSlot propertyRefSLot = (RefSlot)tuple2._2();
        boolean bl = false;
        Some some = null;
        Option option = $this.slots().get(crp.entityName());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Slot longSlot = (Slot)some.value();
            if (longSlot instanceof LongSlot) {
                LongSlot longSlot2 = (LongSlot)longSlot;
                CypherType cypherType = longSlot2.typ();
                RelationshipType relationshipType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship();
                if (cypherType == null) {
                    if (relationshipType != null) {
                        return;
                    }
                } else if (!cypherType.equals(relationshipType)) return;
                if ($this.getLongAt(longSlot2.offset()) != rel$1) return;
                $this.setCachedPropertyAt(propertyRefSLot.offset(), null);
                return;
            }
        }
        if (bl && (refSlot = (Slot)some.value()) instanceof RefSlot) {
            RefSlot refSlot2 = (RefSlot)refSlot;
            CypherType cypherType = refSlot2.typ();
            RelationshipType relationshipType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship();
            if (cypherType == null) {
                if (relationshipType != null) {
                    return;
                }
            } else if (!cypherType.equals(relationshipType)) return;
            if (((VirtualRelationshipValue)$this.getRefAt(refSlot2.offset())).id() != rel$1) return;
            $this.setCachedPropertyAt(propertyRefSLot.offset(), null);
            return;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$set$1(SlottedRow $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            AnyValue v = (AnyValue)tuple2._2();
            $this.setValue(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$mergeWith$1(SlottedRow $this, ReadableRow other$1, EntityById entityById$1, SlottedRow x2$1, boolean checkNullability$1, Tuple2 x0$1) {
        SlotConfiguration.SlotKey slotKey;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            SlotConfiguration.SlotKey slotKey2 = (SlotConfiguration.SlotKey)tuple2._1();
            Slot otherSlot = (Slot)tuple2._2();
            if (slotKey2 instanceof SlotConfiguration.VariableSlotKey) {
                SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey2;
                String key = variableSlotKey.name();
                if (otherSlot instanceof LongSlot) {
                    LongSlot longSlot = (LongSlot)otherSlot;
                    int offset = longSlot.offset();
                    CypherType cypherType = longSlot.typ();
                    NodeType nodeType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode();
                    CypherType cypherType2 = cypherType;
                    if (!(nodeType != null ? !nodeType.equals(cypherType2) : cypherType2 != null)) {
                        Function3 thisSlotSetter = (Function3)$this.slots().maybePrimitiveNodeSetter(key).getOrElse((Function0 & Serializable)() -> {
                            throw new InternalException("Tried to merge primitive node slot " + longSlot + " from " + other$1 + " but it is missing from " + $this + ".Looks like something needs to be fixed in slot allocation.");
                        });
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)thisSlotSetter.apply((Object)$this, (Object)BoxesRunTime.boxToLong((long)other$1.getLongAt(offset)), (Object)entityById$1);
                        return;
                    }
                }
            }
        }
        if (tuple2 != null) {
            SlotConfiguration.SlotKey slotKey3 = (SlotConfiguration.SlotKey)tuple2._1();
            Slot otherSlot = (Slot)tuple2._2();
            if (slotKey3 instanceof SlotConfiguration.VariableSlotKey) {
                SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey3;
                String key = variableSlotKey.name();
                if (otherSlot instanceof LongSlot) {
                    LongSlot longSlot = (LongSlot)otherSlot;
                    int offset = longSlot.offset();
                    CypherType cypherType = longSlot.typ();
                    RelationshipType relationshipType = org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship();
                    CypherType cypherType3 = cypherType;
                    if (!(relationshipType != null ? !relationshipType.equals(cypherType3) : cypherType3 != null)) {
                        Function3 thisSlotSetter = (Function3)$this.slots().maybePrimitiveRelationshipSetter(key).getOrElse((Function0 & Serializable)() -> {
                            throw new InternalException("Tried to merge primitive relationship slot " + longSlot + " from " + other$1 + " but it is missing from " + $this + ".Looks like something needs to be fixed in slot allocation.");
                        });
                        BoxedUnit cfr_ignored_1 = (BoxedUnit)thisSlotSetter.apply((Object)$this, (Object)BoxesRunTime.boxToLong((long)other$1.getLongAt(offset)), (Object)entityById$1);
                        return;
                    }
                }
            }
        }
        if (tuple2 != null) {
            SlotConfiguration.SlotKey slotKey4 = (SlotConfiguration.SlotKey)tuple2._1();
            Slot otherSlot = (Slot)tuple2._2();
            if (slotKey4 instanceof SlotConfiguration.VariableSlotKey) {
                RefSlot refSlot;
                int offset;
                SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey4;
                String key = variableSlotKey.name();
                if (otherSlot instanceof RefSlot && x2$1.isRefInitialized(offset = (refSlot = (RefSlot)otherSlot).offset())) {
                    Function2 thisSlotSetter = (Function2)$this.slots().maybeSetter(key).getOrElse((Function0 & Serializable)() -> {
                        throw new InternalException("Tried to merge slot " + refSlot + " from " + other$1 + " but it is missing from " + $this + ".Looks like something needs to be fixed in slot allocation.");
                    });
                    if (AssertionRunner.ASSERTIONS_ENABLED && checkNullability$1 && !$this.checkCompatibleNullablility(key, refSlot)) {
                        throw new AssertionError((Object)"assertion failed");
                    }
                    AnyValue otherValue = x2$1.getRefAtWithoutCheckingInitialized(offset);
                    BoxedUnit cfr_ignored_2 = (BoxedUnit)thisSlotSetter.apply((Object)$this, (Object)otherValue);
                    return;
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof SlotConfiguration.VariableSlotKey) {
            return;
        }
        if (tuple2 != null) {
            SlotConfiguration.SlotKey slotKey5 = (SlotConfiguration.SlotKey)tuple2._1();
            Slot refSlot = (Slot)tuple2._2();
            if (slotKey5 instanceof SlotConfiguration.CachedPropertySlotKey) {
                SlotConfiguration.CachedPropertySlotKey cachedPropertySlotKey = (SlotConfiguration.CachedPropertySlotKey)slotKey5;
                ASTCachedProperty.RuntimeKey property = cachedPropertySlotKey.property();
                $this.setCachedProperty(property, other$1.getCachedPropertyAt(refSlot.offset()));
                return;
            }
        }
        if (tuple2 != null) {
            SlotConfiguration.SlotKey key = (SlotConfiguration.SlotKey)tuple2._1();
            Slot refSlot = (Slot)tuple2._2();
            if (key instanceof SlotConfiguration.MetaDataSlotKey) {
                SlotConfiguration.MetaDataSlotKey metaDataSlotKey = (SlotConfiguration.MetaDataSlotKey)key;
                int thisOffset = $this.slots().getMetaDataOffsetFor(metaDataSlotKey);
                if (!$this.isRefInitialized(thisOffset) || $this.getRefAtWithoutCheckingInitialized(thisOffset) == Values.NO_VALUE) {
                    $this.setRefAt(thisOffset, other$1.getRefAt(refSlot.offset()));
                    return;
                }
                return;
            }
        }
        if (tuple2 != null && (slotKey = (SlotConfiguration.SlotKey)tuple2._1()) instanceof SlotConfiguration.DuplicatedSlotKey) {
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String prettyKey$1(String key, Set aliases) {
        String string = key;
        return ((IterableOnceOps)aliases.toSeq().$plus$colon((Object)string)).mkString(",");
    }

    public static final /* synthetic */ void $anonfun$iterator$1(SlottedRow $this, ObjectRef tuples$1, SlotConfiguration.SlotWithKeyAndAliases x0$1) {
        SlotConfiguration.SlotWithKeyAndAliases slotWithKeyAndAliases = x0$1;
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            Set aliases = slotWithKeyAndAliases.aliases();
            if (slotKey instanceof SlotConfiguration.VariableSlotKey) {
                SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey;
                String key = variableSlotKey.name();
                if (slot instanceof RefSlot) {
                    RefSlot refSlot = (RefSlot)slot;
                    int offset = refSlot.offset();
                    tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)SlottedRow.prettyKey$1(key, aliases), (Object)$this.refs()[offset]));
                    return;
                }
            }
        }
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            Set aliases = slotWithKeyAndAliases.aliases();
            if (slotKey instanceof SlotConfiguration.VariableSlotKey) {
                SlotConfiguration.VariableSlotKey variableSlotKey = (SlotConfiguration.VariableSlotKey)slotKey;
                String key = variableSlotKey.name();
                if (slot instanceof LongSlot) {
                    LongSlot longSlot = (LongSlot)slot;
                    int offset = longSlot.offset();
                    tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)SlottedRow.prettyKey$1(key, aliases), (Object)Values.longValue((long)$this.longs()[offset])));
                    return;
                }
            }
        }
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            if (slotKey instanceof SlotConfiguration.CachedPropertySlotKey) {
                SlotConfiguration.CachedPropertySlotKey cachedPropertySlotKey = (SlotConfiguration.CachedPropertySlotKey)slotKey;
                ASTCachedProperty.RuntimeKey cachedProperty = cachedPropertySlotKey.property();
                tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)cachedProperty.asCanonicalStringVal(), (Object)$this.refs()[slot.offset()]));
                return;
            }
        }
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            if (slotKey instanceof SlotConfiguration.MetaDataSlotKey) {
                SlotConfiguration.MetaDataSlotKey metaDataSlotKey = (SlotConfiguration.MetaDataSlotKey)slotKey;
                String key = metaDataSlotKey.name();
                int id = metaDataSlotKey.planId();
                tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)("MetaData(" + key + ", " + new Id(id) + ")"), (Object)$this.refs()[slot.offset()]));
                return;
            }
        }
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            if (slotKey instanceof SlotConfiguration.ApplyPlanSlotKey) {
                SlotConfiguration.ApplyPlanSlotKey applyPlanSlotKey = (SlotConfiguration.ApplyPlanSlotKey)slotKey;
                int id = applyPlanSlotKey.applyPlanId();
                tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)("Apply-Plan(" + new Id(id) + ")"), (Object)Values.longValue((long)$this.longs()[slot.offset()])));
                return;
            }
        }
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            if (slotKey instanceof SlotConfiguration.OuterNestedApplyPlanSlotKey) {
                SlotConfiguration.OuterNestedApplyPlanSlotKey outerNestedApplyPlanSlotKey = (SlotConfiguration.OuterNestedApplyPlanSlotKey)slotKey;
                int id = outerNestedApplyPlanSlotKey.applyPlanId();
                tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)("Nested-Apply-Plan(" + new Id(id) + ")"), (Object)Values.longValue((long)$this.longs()[slot.offset()])));
                return;
            }
        }
        if (slotWithKeyAndAliases != null) {
            SlotConfiguration.SlotKey slotKey = slotWithKeyAndAliases.key();
            Slot slot = slotWithKeyAndAliases.slot();
            if (slotKey instanceof SlotConfiguration.DuplicatedSlotKey) {
                SlotConfiguration.DuplicatedSlotKey duplicatedSlotKey = (SlotConfiguration.DuplicatedSlotKey)slotKey;
                String key = duplicatedSlotKey.name();
                int id = duplicatedSlotKey.slotId();
                tuples$1.elem = ((List)tuples$1.elem).$colon$colon((Object)new Tuple2((Object)("DuplicatedSlot(" + key + ", " + id + ")"), slot.isLongSlot() ? Values.longValue((long)$this.longs()[slot.offset()]) : $this.refs()[slot.offset()]));
                return;
            }
        }
        throw new MatchError((Object)slotWithKeyAndAliases);
    }

    public SlottedRow(SlotConfiguration slots) {
        this.slots = slots;
        CypherRow.$init$((CypherRow)this);
        Product.$init$((Product)this);
        this.longs = new long[slots.numberOfLongs()];
        this.refs = new AnyValue[slots.numberOfReferences()];
    }
}

