/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import java.util.Map;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextNode;
import org.neo4j.kernel.impl.core.AbstractEntity;

public class ExecutionContextRelationship
extends AbstractEntity
implements Relationship {
    private final ExecutionContext executionContext;
    private final long id;

    public ExecutionContextRelationship(long relationshipId, ExecutionContext executionContext) {
        this.id = relationshipId;
        this.executionContext = executionContext;
    }

    public long getId() {
        return this.id;
    }

    public String getElementId() {
        return this.executionContext.elementIdMapper().relationshipElementId(this.id);
    }

    public boolean hasProperty(String key) {
        CursorFactory cursors = this.executionContext.cursors();
        try (RelationshipScanCursor relationships = cursors.allocateRelationshipScanCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());){
            boolean bl;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleRelationship(relationships);
                    bl = this.hasProperty(key, (EntityCursor)relationships, properties);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return bl;
        }
    }

    public Object getProperty(String key) {
        CursorFactory cursors = this.executionContext.cursors();
        try (RelationshipScanCursor relationships = cursors.allocateRelationshipScanCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());){
            Object object;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleRelationship(relationships);
                    object = this.getProperty(key, (EntityCursor)relationships, properties);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return object;
        }
    }

    public Object getProperty(String key, Object defaultValue) {
        CursorFactory cursors = this.executionContext.cursors();
        try (RelationshipScanCursor relationships = cursors.allocateRelationshipScanCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());){
            Object object;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleRelationship(relationships);
                    object = this.getProperty(key, defaultValue, (EntityCursor)relationships, properties);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return object;
        }
    }

    public void setProperty(String key, Object value) {
        throw new UnsupportedOperationException("Operation unsupported during parallel query execution");
    }

    public Object removeProperty(String key) {
        throw new UnsupportedOperationException("Operation unsupported during parallel query execution");
    }

    public Iterable<String> getPropertyKeys() {
        CursorFactory cursors = this.executionContext.cursors();
        try (RelationshipScanCursor relationships = cursors.allocateRelationshipScanCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());){
            Iterable<String> iterable;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleRelationship(relationships);
                    iterable = this.getPropertyKeys((EntityCursor)relationships, properties);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return iterable;
        }
    }

    public Map<String, Object> getProperties(String ... keys) {
        CursorFactory cursors = this.executionContext.cursors();
        try (RelationshipScanCursor relationships = cursors.allocateRelationshipScanCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());){
            Map<String, Object> map;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleRelationship(relationships);
                    map = this.getProperties((EntityCursor)relationships, properties, keys);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return map;
        }
    }

    public Map<String, Object> getAllProperties() {
        CursorFactory cursors = this.executionContext.cursors();
        try (RelationshipScanCursor relationships = cursors.allocateRelationshipScanCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());){
            Map<String, Object> map;
            block12: {
                PropertyCursor properties = cursors.allocatePropertyCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());
                try {
                    this.singleRelationship(relationships);
                    map = this.getAllProperties((EntityCursor)relationships, properties);
                    if (properties == null) break block12;
                }
                catch (Throwable throwable) {
                    if (properties != null) {
                        try {
                            properties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                properties.close();
            }
            return map;
        }
    }

    public void delete() {
        throw new UnsupportedOperationException("Operation unsupported during parallel query execution");
    }

    public Node getStartNode() {
        try (RelationshipScanCursor relationships = this.executionContext.cursors().allocateRelationshipScanCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());){
            this.singleRelationship(relationships);
            ExecutionContextNode executionContextNode = new ExecutionContextNode(relationships.sourceNodeReference(), this.executionContext);
            return executionContextNode;
        }
    }

    public Node getEndNode() {
        try (RelationshipScanCursor relationships = this.executionContext.cursors().allocateRelationshipScanCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());){
            this.singleRelationship(relationships);
            ExecutionContextNode executionContextNode = new ExecutionContextNode(relationships.targetNodeReference(), this.executionContext);
            return executionContextNode;
        }
    }

    public Node getOtherNode(Node node) {
        return new ExecutionContextNode(this.getOtherNodeId(node.getId()), this.executionContext);
    }

    public Node[] getNodes() {
        return new Node[]{this.getStartNode(), this.getEndNode()};
    }

    public RelationshipType getType() {
        try (RelationshipScanCursor relationships = this.executionContext.cursors().allocateRelationshipScanCursor(this.executionContext.cursorContext(), this.executionContext.memoryTracker());){
            this.singleRelationship(relationships);
            int type = relationships.type();
            if ((long)type == -1L) {
                throw new NotFoundException((Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, this.getElementId()));
            }
            try {
                String name = this.executionContext.tokenRead().relationshipTypeName(type);
                RelationshipType relationshipType = RelationshipType.withName((String)name);
                return relationshipType;
            }
            catch (KernelException e) {
                throw new IllegalStateException("Kernel API returned non-existent relationship type: " + type, e);
            }
        }
    }

    public boolean isType(RelationshipType type) {
        return this.getType().equals(type);
    }

    private void singleRelationship(RelationshipScanCursor relationships) {
        this.executionContext.dataRead().singleRelationship(this.id, relationships);
        if (!relationships.next()) {
            throw new NotFoundException((Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, this.getElementId()));
        }
    }

    @Override
    protected TokenRead tokenRead() {
        return this.executionContext.tokenRead();
    }

    public boolean equals(Object o) {
        return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.getId() >>> 32 ^ this.getId());
    }

    public String toString() {
        try {
            String relType = this.getType().name();
            return String.format("(%d)-[%s,%d]->(%d)", this.getStartNode().getId(), relType, this.getId(), this.getEndNode().getId());
        }
        catch (DatabaseShutdownException | NotInTransactionException throwable) {
            return String.format("(?)-[%d]->(?)", this.getId());
        }
    }
}

