/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.RawIterator;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.CypherScope;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.OverridableSecurityContext;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextProcedureKernelTransaction;
import org.neo4j.kernel.impl.api.parallel.ThreadExecutionContext;
import org.neo4j.kernel.impl.newapi.ProcedureCaller;
import org.neo4j.values.AnyValue;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class KernelProcedures
implements Procedures {
    private final AssertOpen assertOpen;

    private KernelProcedures(AssertOpen assertOpen) {
        this.assertOpen = assertOpen;
    }

    protected abstract ProcedureCaller getProcedureCaller();

    private void performCheckBeforeOperation() {
        this.assertOpen.assertOpen();
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallRead(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.getProcedureCaller().callProcedure(id, arguments, AccessMode.Static.READ, context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallWrite(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.getProcedureCaller().callProcedure(id, arguments, AccessMode.Static.TOKEN_WRITE, context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallSchema(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.getProcedureCaller().callProcedure(id, arguments, AccessMode.Static.SCHEMA, context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallDbms(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.getProcedureCaller().callProcedure(id, arguments, AccessMode.Static.ACCESS, context);
    }

    public AnyValue functionCall(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.getProcedureCaller().callFunction(id, arguments, context);
    }

    public AnyValue builtInFunctionCall(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.getProcedureCaller().callBuiltInFunction(id, arguments, context);
    }

    public UserAggregationReducer aggregationFunction(int id, ProcedureCallContext context) throws ProcedureException {
        return this.getProcedureCaller().createAggregationFunction(id, context);
    }

    public UserAggregationReducer builtInAggregationFunction(int id, ProcedureCallContext context) throws ProcedureException {
        return this.getProcedureCaller().createBuiltInAggregationFunction(id, context);
    }

    public UserFunctionHandle functionGet(QualifiedName name, CypherScope scope) {
        this.performCheckBeforeOperation();
        return this.getProcedureCaller().procedureView.function(name, scope);
    }

    public Stream<UserFunctionSignature> functionGetAll(CypherScope scope) {
        this.performCheckBeforeOperation();
        return this.getProcedureCaller().procedureView.getAllNonAggregatingFunctions(scope);
    }

    public ProcedureHandle procedureGet(QualifiedName name, CypherScope scope) throws ProcedureException {
        this.performCheckBeforeOperation();
        return this.getProcedureCaller().procedureView.procedure(name, scope);
    }

    public Stream<ProcedureSignature> proceduresGetAll(CypherScope scope) {
        this.performCheckBeforeOperation();
        return this.getProcedureCaller().procedureView.getAllProcedures(scope);
    }

    public UserFunctionHandle aggregationFunctionGet(QualifiedName name, CypherScope scope) {
        this.performCheckBeforeOperation();
        return this.getProcedureCaller().procedureView.aggregationFunction(name, scope);
    }

    public Stream<UserFunctionSignature> aggregationFunctionGetAll(CypherScope scope) {
        this.performCheckBeforeOperation();
        return this.getProcedureCaller().procedureView.getAllAggregatingFunctions(scope);
    }

    public long signatureVersion() {
        return this.getProcedureCaller().procedureView.signatureVersion();
    }

    public static final class ForThreadExecutionContextScope
    extends KernelProcedures {
        private final ProcedureCaller.ForThreadExecutionContextScope procedureCaller;

        public ForThreadExecutionContextScope(ThreadExecutionContext executionContext, Dependencies databaseDependencies, OverridableSecurityContext overridableSecurityContext, ExecutionContextProcedureKernelTransaction kernelTransaction, SecurityAuthorizationHandler securityAuthorizationHandler, Supplier<ClockContext> clockContextSupplier, ProcedureView procedureView) {
            super((AssertOpen)kernelTransaction);
            this.procedureCaller = new ProcedureCaller.ForThreadExecutionContextScope(executionContext, (DependencyResolver)databaseDependencies, overridableSecurityContext, kernelTransaction, securityAuthorizationHandler, clockContextSupplier, procedureView);
        }

        @Override
        protected ProcedureCaller getProcedureCaller() {
            return this.procedureCaller;
        }

        @Override
        public RawIterator<AnyValue[], ProcedureException> procedureCallWrite(int id, AnyValue[] arguments, ProcedureCallContext context) {
            throw new UnsupportedOperationException("Invoking procedure with WRITE access mode is not allowed during parallel execution.");
        }

        @Override
        public RawIterator<AnyValue[], ProcedureException> procedureCallSchema(int id, AnyValue[] arguments, ProcedureCallContext context) {
            throw new UnsupportedOperationException("Invoking procedure with SCHEMA access mode is not allowed during parallel execution.");
        }
    }

    public static final class ForTransactionScope
    extends KernelProcedures {
        private final KernelTransactionImplementation ktx;
        private final Dependencies databaseDependencies;
        private ProcedureCaller.ForTransactionScope procedureCaller;

        public ForTransactionScope(KernelTransactionImplementation ktx, Dependencies databaseDependencies, AssertOpen assertOpen) {
            super(assertOpen);
            this.ktx = ktx;
            this.databaseDependencies = databaseDependencies;
        }

        @Override
        protected ProcedureCaller getProcedureCaller() {
            return this.procedureCaller;
        }

        public void initialize(ProcedureView procedureView) {
            this.procedureCaller = new ProcedureCaller.ForTransactionScope(this.ktx, (DependencyResolver)this.databaseDependencies, procedureView);
        }

        public void reset() {
            this.procedureCaller = null;
        }
    }
}

