/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.TransactionId;

public interface CommittedCommandBatchRepresentation {
    public CommandBatch commandBatch();

    public int serialize(LogEntryWriter<? extends WritableChannel> var1) throws IOException;

    public int checksum();

    public long timeWritten();

    public long txId();

    public boolean isRollback();

    public long appendIndex();

    public LogPosition previousBatchLogPosition();

    default public BatchInformation batchInformation() {
        return new BatchInformation(this.txId(), this.commandBatch().kernelVersion(), this.checksum(), this.timeWritten(), this.commandBatch().consensusIndex(), this.appendIndex());
    }

    public record BatchInformation(long txId, KernelVersion kernelVersion, int checksum, long timeWritten, long consensusIndex, long appendIndex) {
        public BatchInformation(TransactionId transactionId, long appendIndex) {
            this(transactionId.id(), transactionId.kernelVersion(), transactionId.checksum(), transactionId.commitTimestamp(), transactionId.consensusIndex(), appendIndex);
        }
    }
}

