/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.nio.file.Path;
import java.time.Instant;
import org.neo4j.internal.helpers.Format;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.recovery.RecoveryMode;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryPredicate;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartInformationProvider;
import org.neo4j.logging.InternalLog;

public class LoggingLogFileMonitor
implements RecoveryMonitor,
RecoveryStartInformationProvider.Monitor,
LogRotationMonitor {
    private long minObservedTransaction = Long.MAX_VALUE;
    private long maxObservedTransaction = Long.MIN_VALUE;
    private final InternalLog log;
    private int numberOfRecoveredTransactions;
    private int skippedFirstBatches;
    private int observedRollbacks;

    public LoggingLogFileMonitor(InternalLog log) {
        this.log = log;
    }

    @Override
    public void recoveryRequired(RecoveryStartInformation recoveryStartInfo) {
        this.log.info("Recovery required from position " + recoveryStartInfo.transactionLogPosition());
    }

    @Override
    public void recoveryCompleted(long recoveryTimeInMilliseconds, RecoveryMode mode) {
        this.log.info(String.format("Recovery in '%s' mode completed. Observed transactions range [first:%s, last:%s]: %d transactions applied, %d not completed transactions rolled back, skipped applying %d previously rolled back transactions. Time spent: %s.", mode.description(), LoggingLogFileMonitor.valueOrDefault(this.minObservedTransaction, Long.MAX_VALUE), LoggingLogFileMonitor.valueOrDefault(this.maxObservedTransaction, Long.MIN_VALUE), this.numberOfRecoveredTransactions, this.numberOfRecoveredTransactions(), this.observedRollbacks, Format.duration((long)recoveryTimeInMilliseconds)));
    }

    @Override
    public void failToRecoverTransactionsAfterCommit(Throwable t, CommittedCommandBatchRepresentation.BatchInformation commandBatch, LogPosition recoveryToPosition) {
        this.log.warn(String.format("Fail to recover database. Highest recovered transaction id:%d, committed at:%d. Any transactional logs after position %s can not be recovered and will be truncated.", commandBatch.txId(), commandBatch.timeWritten(), recoveryToPosition), t);
    }

    @Override
    public void partialRecovery(RecoveryPredicate recoveryPredicate, CommittedCommandBatchRepresentation.BatchInformation commandBatch) {
        this.log.info("Partial database recovery based on provided criteria: " + recoveryPredicate.describe() + ". Last replayed transaction: " + LoggingLogFileMonitor.describeBatch(commandBatch) + ".");
    }

    @Override
    public void failToRecoverTransactionsAfterPosition(Throwable t, LogPosition recoveryFromPosition) {
        this.log.warn(String.format("Fail to recover database. Any transactional logs after position %s can not be recovered and will be truncated.", recoveryFromPosition), t);
    }

    @Override
    public void failToExtractInitialFileHeader(Exception e) {
        this.log.warn("Fail to read initial transaction log file header.", (Throwable)e);
    }

    @Override
    public void batchRecovered(CommittedCommandBatchRepresentation committedBatch) {
        this.trackTxId(committedBatch.txId());
        if (committedBatch.commandBatch().isLast()) {
            ++this.numberOfRecoveredTransactions;
        }
    }

    @Override
    public void batchApplySkipped(CommittedCommandBatchRepresentation committedBatch) {
        this.trackTxId(committedBatch.txId());
        if (committedBatch.commandBatch().isFirst()) {
            ++this.skippedFirstBatches;
        }
        if (committedBatch.isRollback()) {
            ++this.observedRollbacks;
        }
    }

    @Override
    public void recoveryNotRequired(LogPosition logPosition) {
        this.log.info(String.format("No commits found after last check point (which is at %s)", logPosition != null ? logPosition.toString() : "<no log position given>"));
    }

    @Override
    public void recoveryRequiredAfterLastCheckPoint(LogPosition logPosition, LogPosition oldestNotVisibleTransactionLogPosition, long appendIndexAfterLastCheckPoint) {
        this.log.info(String.format("Transaction logs recovery is required with the last check point (which points to %s, oldest log entry to recover %s). First observed post checkpoint append index: %d.", logPosition, oldestNotVisibleTransactionLogPosition, appendIndexAfterLastCheckPoint));
    }

    @Override
    public void noCheckPointFound() {
        this.log.info("No check point found in transaction log.");
    }

    @Override
    public void started(Path logFile, long logVersion) {
        this.log.info("Starting transaction log [%s] at version=%d", new Object[]{logFile, logVersion});
    }

    @Override
    public void startRotation(long currentLogVersion) {
    }

    @Override
    public void finishLogRotation(Path logFile, long logVersion, long lastAppendIndex, long rotationMillis, long millisSinceLastRotation) {
        StringBuilder sb = new StringBuilder("Rotated to transaction log [");
        sb.append(logFile).append("] version=").append(logVersion).append(", last append index in previous log=");
        sb.append(lastAppendIndex).append(", rotation took ").append(rotationMillis).append(" millis");
        if (millisSinceLastRotation > 0L) {
            sb.append(", started after ").append(millisSinceLastRotation).append(" millis");
        }
        this.log.info(sb.append('.').toString());
    }

    private void trackTxId(long txId) {
        this.minObservedTransaction = Math.min(this.minObservedTransaction, txId);
        this.maxObservedTransaction = Math.max(this.maxObservedTransaction, txId);
    }

    private int numberOfRecoveredTransactions() {
        return this.skippedFirstBatches - this.observedRollbacks;
    }

    private static String valueOrDefault(long value, long unknownValue) {
        return value == unknownValue ? "None" : String.valueOf(value);
    }

    private static String describeBatch(CommittedCommandBatchRepresentation.BatchInformation commandBatch) {
        if (commandBatch == null) {
            return "Not found.";
        }
        return "transaction id: " + commandBatch.txId() + ", time " + Format.date((Instant)Instant.ofEpochMilli(commandBatch.timeWritten()));
    }
}

